/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.tracking.service;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.core.util.ApplicationEdition;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.tracking.model.TrackInfo;
import com.kms.katalon.tracking.service.TrackingApiService;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TrackingService {
    private IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();
    private ExecutorService executor = Executors.newFixedThreadPool(10);

    public void track(TrackInfo trackInfo) {
        ScopedPreferenceStore prefStore = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon");
        boolean checkAllowUsage = prefStore.contains("general.autoCheckAllowUsage_Tracking") ? prefStore.getBoolean("general.autoCheckAllowUsage_Tracking") : true;
        boolean canConfigUsageTracking = this.featureService.canUse(KSEFeature.CONFIGURE_USAGE_TRACKING);
        if (canConfigUsageTracking && !checkAllowUsage) {
            return;
        }
        this.executor.submit(() -> {
            try {
                String payload = this.buildEventPayload(trackInfo);
                this.sendEventPayload(payload);
            }
            catch (Exception exception) {}
        });
    }

    protected String buildEventPayload(TrackInfo trackInfo) {
        PayloadBuilder payloadBuilder = new PayloadBuilder();
        String payloadJson = payloadBuilder.build(trackInfo);
        return payloadJson;
    }

    private void sendEventPayload(String payload) throws IOException, GeneralSecurityException {
        TrackingApiService.getInstance().post(payload);
    }

    private class PayloadBuilder {
        private PayloadBuilder() {
        }

        public String build(TrackInfo trackInfo) {
            JsonObject payload = new JsonObject();
            payload = this.addUserInfo(payload, trackInfo);
            payload = this.addEventName(payload, trackInfo);
            payload = this.addEventProperties(payload, trackInfo);
            payload = this.addApplicationTraits(payload);
            return payload.toString();
        }

        private JsonObject addUserInfo(JsonObject payload, TrackInfo trackInfo) {
            String userId = this.getUserId();
            if (userId != null) {
                userId = userId.toLowerCase();
            }
            payload.addProperty("userId", userId);
            return payload;
        }

        private String getUserId() {
            return ApplicationContext.getInstance().getUserId();
        }

        private JsonObject addEventName(JsonObject payload, TrackInfo trackInfo) {
            payload.addProperty("event", trackInfo.getEventName());
            return payload;
        }

        private JsonObject addEventProperties(JsonObject payload, TrackInfo trackInfo) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("accountID", ActivationInfoCollector.getAccountId());
            jsonObject.addProperty("organizationID", ActivationInfoCollector.getOrgId());
            jsonObject.addProperty("edition", ApplicationEdition.get().getName());
            trackInfo.addProperty(jsonObject);
            payload.add("properties", (JsonElement)trackInfo.getProperties());
            return payload;
        }

        private JsonObject addApplicationTraits(JsonObject payload) {
            JsonObject appTraitsObject = ActivationInfoCollector.traitsWithAppInfo();
            JsonUtil.mergeJsonObject((JsonObject)appTraitsObject, (JsonObject)payload.get("properties").getAsJsonObject());
            return payload;
        }
    }
}

