/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.platform.internal.controller;

import com.katalon.platform.api.controller.ObjectRepositoryController;
import com.katalon.platform.api.exception.ResourceException;
import com.katalon.platform.api.model.TestObjectEntity;
import com.katalon.platform.api.model.testobject.BasicRestRequestEntity;
import com.katalon.platform.api.model.testobject.BasicSoapRequestEntity;
import com.katalon.platform.api.model.testobject.BasicWebElementEntity;
import com.katalon.platform.api.model.testobject.RestRequestEntity;
import com.katalon.platform.api.model.testobject.SoapRequestEntity;
import com.katalon.platform.api.model.testobject.WebElementEntity;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebElementSelectorMethod;
import com.kms.katalon.entity.repository.WebElementXpathEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.platform.internal.entity.testobject.RestRequestEntityImpl;
import com.kms.katalon.platform.internal.entity.testobject.SoapRequestEntityImpl;
import com.kms.katalon.platform.internal.entity.testobject.WebElementEntityImpl;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class ObjectRepositoryControllerImpl
implements ObjectRepositoryController {
    private com.kms.katalon.controller.ObjectRepositoryController objectRepositoryController = com.kms.katalon.controller.ObjectRepositoryController.getInstance();
    private FolderController folderController = FolderController.getInstance();
    private ProjectController projectController = ProjectController.getInstance();

    public TestObjectEntity getTestObject(com.katalon.platform.api.model.ProjectEntity project, String testObjectId) throws ResourceException {
        com.kms.katalon.entity.repository.WebElementEntity sourceWebElement;
        block5: {
            try {
                sourceWebElement = this.objectRepositoryController.getWebElementByDisplayPk(testObjectId);
                if (sourceWebElement != null) break block5;
                return null;
            }
            catch (ControllerException e) {
                throw new ResourceException(ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
            }
        }
        if (sourceWebElement instanceof WebServiceRequestEntity) {
            WebServiceRequestEntity sourceRequestElement = (WebServiceRequestEntity)sourceWebElement;
            if (sourceRequestElement.getServiceType() == "SOAP") {
                return new SoapRequestEntityImpl(sourceRequestElement);
            }
            return new RestRequestEntityImpl(sourceRequestElement);
        }
        return new WebElementEntityImpl(sourceWebElement);
    }

    public List<TestObjectEntity> getChildTestObjects(com.katalon.platform.api.model.ProjectEntity project, com.katalon.platform.api.model.FolderEntity parentFolder) throws ResourceException {
        try {
            ProjectEntity projectEntity = this.projectController.getProject(project.getId());
            if (projectEntity == null) {
                throw new ResourceException(MessageFormat.format("Project {0} doesn't exist", project.getId()));
            }
            FolderEntity folder = this.folderController.getFolderByDisplayId(projectEntity, parentFolder.getId());
            if (folder == null) {
                throw new ResourceException(MessageFormat.format("Parent folder {0} doesn't exist", parentFolder.getId()));
            }
            return this.folderController.getChildren(folder).stream().filter(entity -> entity instanceof com.kms.katalon.entity.repository.WebElementEntity).map(entity -> {
                try {
                    return this.getTestObject(project, entity.getIdForDisplay());
                }
                catch (ResourceException resourceException) {
                    return null;
                }
            }).filter(entity -> entity != null).collect(Collectors.toList());
        }
        catch (ControllerException e) {
            throw new ResourceException(ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
        }
    }

    public RestRequestEntity newRestRequest(com.katalon.platform.api.model.ProjectEntity project, com.katalon.platform.api.model.FolderEntity parentFolder, String name, BasicRestRequestEntity requestTemplate) throws ResourceException {
        try {
            ProjectEntity projectEntity = this.projectController.getProject(project.getId());
            if (projectEntity == null) {
                throw new ResourceException(MessageFormat.format("Project {0} doesn't exist", project.getId()));
            }
            FolderEntity folder = this.folderController.getFolderByDisplayId(projectEntity, parentFolder.getId());
            if (folder == null) {
                throw new ResourceException(MessageFormat.format("Parent folder {0} doesn't exist", parentFolder.getId()));
            }
            WebServiceRequestEntity sourceWebService = this.objectRepositoryController.newWSTestObject(folder, name);
            this.updateRestRequest(requestTemplate, sourceWebService);
            return (RestRequestEntity)this.getTestObject(project, sourceWebService.getIdForDisplay());
        }
        catch (ControllerException e) {
            throw new ResourceException(ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
        }
    }

    private void updateRestRequest(BasicRestRequestEntity requestTemplate, WebServiceRequestEntity sourceWebService) throws ControllerException {
        if (requestTemplate != null) {
            sourceWebService.setServiceType("REST");
            sourceWebService.setRestUrl(requestTemplate.getRequestUrl());
            sourceWebService.setRestRequestMethod(requestTemplate.getRequestMethod());
            ArrayList variableEntities = new ArrayList();
            if (requestTemplate.getVariables() != null) {
                variableEntities.addAll(requestTemplate.getVariables().stream().map(v -> new VariableEntity(v.getName(), v.getDefaultValue())).collect(Collectors.toList()));
            }
            ArrayList httpHeaderProperties = new ArrayList();
            if (requestTemplate.getHttpHeaders() != null) {
                httpHeaderProperties.addAll(requestTemplate.getHttpHeaders().stream().map(prop -> new WebElementPropertyEntity(prop.getName(), prop.getValue())).collect(Collectors.toList()));
            }
            sourceWebService.setHttpHeaderProperties(httpHeaderProperties);
            ArrayList paramProperties = new ArrayList();
            if (requestTemplate.getHttpHeaders() != null) {
                paramProperties.addAll(requestTemplate.getRequestParameters().stream().map(prop -> new WebElementPropertyEntity(prop.getName(), prop.getValue())).collect(Collectors.toList()));
            }
            sourceWebService.setRestParameters(paramProperties);
            sourceWebService.setVerificationScript(requestTemplate.getVerificationScript());
            sourceWebService.setHttpBodyContent(requestTemplate.getHttpBodyContent());
            sourceWebService.setHttpBodyType(requestTemplate.getHttpBodyType());
        }
        this.objectRepositoryController.updateTestObject((com.kms.katalon.entity.repository.WebElementEntity)sourceWebService);
    }

    public SoapRequestEntity newSoapRequest(com.katalon.platform.api.model.ProjectEntity project, com.katalon.platform.api.model.FolderEntity parentFolder, String name, BasicSoapRequestEntity requestTemplate) throws ResourceException {
        try {
            ProjectEntity projectEntity = this.projectController.getProject(project.getId());
            if (projectEntity == null) {
                throw new ResourceException(MessageFormat.format("Project {0} doesn't exist", project.getId()));
            }
            FolderEntity folder = this.folderController.getFolderByDisplayId(projectEntity, parentFolder.getId());
            if (folder == null) {
                throw new ResourceException(MessageFormat.format("Parent folder {0} doesn't exist", parentFolder.getId()));
            }
            WebServiceRequestEntity sourceWebService = this.objectRepositoryController.newWSTestObject(folder, name);
            this.updateSoapRequest(requestTemplate, sourceWebService);
            return (SoapRequestEntity)this.getTestObject(project, sourceWebService.getIdForDisplay());
        }
        catch (ControllerException e) {
            throw new ResourceException(ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
        }
    }

    public WebElementEntity newWebElement(com.katalon.platform.api.model.ProjectEntity project, com.katalon.platform.api.model.FolderEntity parentFolder, String name, BasicWebElementEntity webElementTemplate) throws ResourceException {
        try {
            ProjectEntity projectEntity = this.projectController.getProject(project.getId());
            if (projectEntity == null) {
                throw new ResourceException(MessageFormat.format("Project {0} doesn't exist", project.getId()));
            }
            FolderEntity folder = this.folderController.getFolderByDisplayId(projectEntity, parentFolder.getId());
            if (folder == null) {
                throw new ResourceException(MessageFormat.format("Parent folder {0} doesn't exist", parentFolder.getId()));
            }
            com.kms.katalon.entity.repository.WebElementEntity sourceWebElement = this.objectRepositoryController.newTestObject(folder, name);
            this.updateWebElement(webElementTemplate, sourceWebElement);
            return (WebElementEntity)this.getTestObject(project, sourceWebElement.getIdForDisplay());
        }
        catch (ControllerException e) {
            throw new ResourceException(ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
        }
    }

    private void updateWebElement(BasicWebElementEntity webElementTemplate, com.kms.katalon.entity.repository.WebElementEntity sourceWebElement) {
        if (webElementTemplate != null) {
            sourceWebElement.setImagePath(webElementTemplate.getImagePath());
            sourceWebElement.setUseRalativeImagePath(webElementTemplate.isRelativeImagePath());
            sourceWebElement.setSelectorMethod(WebElementSelectorMethod.valueOf((String)webElementTemplate.getSelectorMethod().name()));
            HashMap selectorCollection = new HashMap();
            if (webElementTemplate != null) {
                webElementTemplate.getSelectorCollection().entrySet().stream().forEach(entry -> {
                    String string = selectorCollection.put(WebElementSelectorMethod.valueOf((String)((com.katalon.platform.api.model.testobject.WebElementSelectorMethod)entry.getKey()).name()), (String)entry.getValue());
                });
            }
            ArrayList<WebElementPropertyEntity> webElementProperties = new ArrayList<WebElementPropertyEntity>();
            if (webElementTemplate.hasParentElement()) {
                WebElementPropertyEntity parentRefElement = new WebElementPropertyEntity("ref_element", webElementTemplate.getParentElementId());
                webElementProperties.add(parentRefElement);
            }
            if (webElementTemplate.getWebElementProperties() != null) {
                webElementProperties.addAll(webElementTemplate.getWebElementProperties().stream().map(prop -> new WebElementPropertyEntity(prop.getName(), prop.getValue())).collect(Collectors.toList()));
            }
            sourceWebElement.setWebElementProperties(webElementProperties);
            ArrayList xpathElementProperties = new ArrayList();
            if (webElementTemplate.getWebElementProperties() != null) {
                xpathElementProperties.addAll(webElementTemplate.getXpathElementProperties().stream().map(prop -> new WebElementXpathEntity(prop.getName(), prop.getValue())).collect(Collectors.toList()));
            }
            sourceWebElement.setWebElementXpaths(xpathElementProperties);
        }
    }

    public RestRequestEntity updateRestRequest(com.katalon.platform.api.model.ProjectEntity project, String requestId, BasicRestRequestEntity requestTemplate) throws ResourceException {
        try {
            ProjectEntity projectEntity = this.projectController.getProject(project.getId());
            if (projectEntity == null) {
                throw new ResourceException(MessageFormat.format("Project {0} doesn't exist", project.getId()));
            }
            com.kms.katalon.entity.repository.WebElementEntity sourceObject = this.objectRepositoryController.getWebElementByDisplayPk(requestId);
            if (!(sourceObject instanceof WebServiceRequestEntity)) {
                throw new ResourceException(MessageFormat.format("Request object {0} is not valid Rest Request", requestId));
            }
            WebServiceRequestEntity sourceWebService = (WebServiceRequestEntity)sourceObject;
            this.updateRestRequest(requestTemplate, sourceWebService);
            return (RestRequestEntity)this.getTestObject(project, sourceWebService.getIdForDisplay());
        }
        catch (ControllerException e) {
            throw new ResourceException(ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
        }
    }

    public SoapRequestEntity updateSoapRequest(com.katalon.platform.api.model.ProjectEntity project, String requestId, BasicSoapRequestEntity requestTemplate) throws ResourceException {
        try {
            ProjectEntity projectEntity = this.projectController.getProject(project.getId());
            if (projectEntity == null) {
                throw new ResourceException(MessageFormat.format("Project {0} doesn't exist", project.getId()));
            }
            com.kms.katalon.entity.repository.WebElementEntity sourceObject = this.objectRepositoryController.getWebElementByDisplayPk(requestId);
            if (!(sourceObject instanceof WebServiceRequestEntity)) {
                throw new ResourceException(MessageFormat.format("Request object {0} is not SOAP Request", requestId));
            }
            WebServiceRequestEntity sourceWebService = (WebServiceRequestEntity)sourceObject;
            this.updateSoapRequest(requestTemplate, sourceWebService);
            return (SoapRequestEntity)this.getTestObject(project, sourceWebService.getIdForDisplay());
        }
        catch (ControllerException e) {
            throw new ResourceException(ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
        }
    }

    private void updateSoapRequest(BasicSoapRequestEntity requestTemplate, WebServiceRequestEntity sourceWebService) throws ControllerException {
        if (requestTemplate != null) {
            sourceWebService.setServiceType("SOAP");
            sourceWebService.setWsdlAddress(requestTemplate.getRequestUrl());
            sourceWebService.setRestRequestMethod(requestTemplate.getRequestMethod());
            ArrayList variableEntities = new ArrayList();
            if (requestTemplate.getVariables() != null) {
                variableEntities.addAll(requestTemplate.getVariables().stream().map(v -> new VariableEntity(v.getName(), v.getDefaultValue())).collect(Collectors.toList()));
            }
            ArrayList httpHeaderProperties = new ArrayList();
            if (requestTemplate.getHttpHeaders() != null) {
                httpHeaderProperties.addAll(requestTemplate.getHttpHeaders().stream().map(prop -> new WebElementPropertyEntity(prop.getName(), prop.getValue())).collect(Collectors.toList()));
            }
            sourceWebService.setHttpHeaderProperties(httpHeaderProperties);
            ArrayList paramProperties = new ArrayList();
            if (requestTemplate.getHttpHeaders() != null) {
                paramProperties.addAll(requestTemplate.getRequestParameters().stream().map(prop -> new WebElementPropertyEntity(prop.getName(), prop.getValue())).collect(Collectors.toList()));
            }
            sourceWebService.setSoapParameters(paramProperties);
            sourceWebService.setVerificationScript(requestTemplate.getVerificationScript());
            sourceWebService.setSoapBody(requestTemplate.getSoapBodyContent());
            sourceWebService.setSoapServiceFunction(requestTemplate.getSoapServiceFunction());
        }
        this.objectRepositoryController.updateTestObject((com.kms.katalon.entity.repository.WebElementEntity)sourceWebService);
    }

    public WebElementEntity updateWebElement(com.katalon.platform.api.model.ProjectEntity project, String webElementId, BasicWebElementEntity webElementTemplate) throws ResourceException {
        try {
            ProjectEntity projectEntity = this.projectController.getProject(project.getId());
            if (projectEntity == null) {
                throw new ResourceException(MessageFormat.format("Project {0} doesn't exist", project.getId()));
            }
            com.kms.katalon.entity.repository.WebElementEntity sourceWebElement = this.objectRepositoryController.getWebElementByDisplayPk(webElementId);
            this.updateWebElement(webElementTemplate, sourceWebElement);
            return (WebElementEntity)this.getTestObject(project, sourceWebElement.getIdForDisplay());
        }
        catch (ControllerException e) {
            throw new ResourceException(ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
        }
    }

    public TestObjectEntity renameTestObject(com.katalon.platform.api.model.ProjectEntity projectEntity, String testObjectId, String newName) throws ResourceException {
        com.kms.katalon.entity.repository.WebElementEntity sourceWebElement;
        block3: {
            try {
                sourceWebElement = this.objectRepositoryController.getWebElementByDisplayPk(testObjectId);
                if (sourceWebElement != null) break block3;
                return null;
            }
            catch (ControllerException e) {
                throw new ResourceException(ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
            }
        }
        com.kms.katalon.entity.repository.WebElementEntity renamedSourceElement = this.objectRepositoryController.updateTestObject(sourceWebElement);
        return this.getTestObject(projectEntity, renamedSourceElement.getIdForDisplay());
    }
}

