/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.source.attach.attacher;

import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.sf.feeling.decompiler.source.attach.attacher.SourceAttacher;

public class MySourceAttacher2
implements SourceAttacher {
    @Override
    public boolean attachSource(IPackageFragmentRoot root, File sourcePath) throws Exception {
        IClasspathEntry entry;
        try {
            entry = JavaModelUtil.getClasspathEntry((IPackageFragmentRoot)root);
        }
        catch (JavaModelException ex) {
            if (!ex.isDoesNotExist()) {
                throw ex;
            }
            entry = null;
        }
        IPath containerPath = null;
        IJavaProject jproject = root.getJavaProject();
        if (entry.getEntryKind() == 5) {
            containerPath = entry.getPath();
            IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)jproject);
            entry = JavaModelUtil.findEntryInContainer((IClasspathContainer)container, (IPath)root.getPath());
            Assert.isNotNull((Object)entry);
        }
        IClasspathEntry newEntry = this.configureSourceAttachment(sourcePath.getAbsolutePath(), entry, jproject);
        this.applySourceAttachment(newEntry, jproject, containerPath, entry.getReferencingEntry() != null);
        return true;
    }

    private IClasspathEntry configureSourceAttachment(String sourcePath, IClasspathEntry initialEntry, IJavaProject jproject) throws Exception {
        if (initialEntry == null) {
            throw new IllegalArgumentException();
        }
        int entryKind = initialEntry.getEntryKind();
        if (entryKind != 1 && entryKind != 4) {
            throw new IllegalArgumentException();
        }
        return this.getNewEntry(sourcePath, initialEntry, jproject);
    }

    public IClasspathEntry getNewEntry(String sourcePath, IClasspathEntry fEntry, IJavaProject fProject) throws Exception {
        CPListElement elem = CPListElement.createFromExisting((IClasspathEntry)fEntry, (IJavaProject)fProject);
        IPath sourceAttachmentPath = Path.fromOSString((String)sourcePath).makeAbsolute();
        String encoding = ResourcesPlugin.getWorkspace().getRoot().getDefaultCharset();
        elem.setAttribute("sourcepath", (Object)sourceAttachmentPath);
        elem.setAttribute("source_encoding", (Object)encoding);
        return elem.getClasspathEntry();
    }

    private void applySourceAttachment(IClasspathEntry newEntry, IJavaProject project, IPath containerPath, boolean isReferencedEntry) throws Exception {
        String[] changedAttributes = new String[]{"sourcepath", "source_encoding"};
        BuildPathSupport.modifyClasspathEntry(null, (IClasspathEntry)newEntry, (String[])changedAttributes, (IJavaProject)project, (IPath)containerPath, (boolean)isReferencedEntry, (IProgressMonitor)new NullProgressMonitor());
    }
}

