/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.source.attach.finder;

import java.io.File;
import java.io.StringReader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.sf.feeling.decompiler.source.attach.finder.AbstractSourceCodeFinder;
import org.sf.feeling.decompiler.source.attach.finder.SourceCodeFinder;
import org.sf.feeling.decompiler.source.attach.finder.SourceFileResult;
import org.sf.feeling.decompiler.source.attach.utils.SourceAttachUtil;
import org.sf.feeling.decompiler.source.attach.utils.SourceBindingUtil;
import org.sf.feeling.decompiler.source.attach.utils.UrlDownloader;
import org.sf.feeling.decompiler.util.Logger;

public class EclipsePluginSourceByUrlPatternFinder
extends AbstractSourceCodeFinder
implements SourceCodeFinder {
    private String urlPattern;

    public EclipsePluginSourceByUrlPatternFinder(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    public String toString() {
        return this.getClass() + "; urlPattern=" + this.urlPattern;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void find(String binFile, List<SourceFileResult> results) {
        String[] result;
        File bin = new File(binFile);
        Object fileResult = null;
        try {
            String fileName = bin.getName();
            int position = fileName.lastIndexOf(95);
            if (position != -1) {
                String baseName = fileName.substring(0, position);
                String version = fileName.substring(position + 1);
                String sourceFileName = String.valueOf(baseName) + ".source_" + version;
                fileResult = this.findFile(sourceFileName, bin);
            }
        }
        catch (Throwable e) {
            Logger.debug((Throwable)e);
        }
        if (fileResult instanceof SourceFileResult) {
            results.add((SourceFileResult)fileResult);
        } else if (fileResult instanceof String[] && (result = (String[])fileResult)[0] != null) {
            String name = result[0].substring(result[0].lastIndexOf(47) + 1);
            SourceFileResult object = new SourceFileResult((SourceCodeFinder)this, binFile, result[1], name, 50);
            Logger.debug((String)(String.valueOf(this.toString()) + " FOUND: " + object), null);
            results.add(object);
        }
    }

    private Object findFile(String fileName, File bin) throws Exception {
        String file = null;
        String url = null;
        List<String> links = this.searchFileLinksByName(fileName);
        Iterator<String> it = links.iterator();
        while (it.hasNext()) {
            String link = it.next();
            boolean keep = false;
            if (link.endsWith("/" + fileName)) {
                keep = true;
            }
            if (keep) continue;
            it.remove();
        }
        for (String url1 : links) {
            String[] sourceFiles = SourceBindingUtil.getSourceFileByDownloadUrl(url1);
            if (sourceFiles == null || sourceFiles[0] == null || !new File(sourceFiles[0]).exists()) continue;
            File sourceFile = new File(sourceFiles[0]);
            File tempFile = new File(sourceFiles[1]);
            SourceFileResult result = new SourceFileResult((SourceCodeFinder)this, bin.getAbsolutePath(), sourceFile, tempFile, 100);
            return result;
        }
        for (String url1 : links) {
            String tmpFile = new UrlDownloader().download(url1);
            if (tmpFile == null || !new File(tmpFile).exists() || !SourceAttachUtil.isSourceCodeFor(tmpFile, bin.getAbsolutePath())) continue;
            this.setDownloadUrl(url1);
            file = tmpFile;
            url = url1;
            break;
        }
        return new String[]{url, file};
    }

    private List<String> searchFileLinksByName(String fileName) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        URL baseUrl = new URL(this.urlPattern.replace("{0}", URLEncoder.encode(fileName, "UTF-8")));
        String html = this.getHtmlFromUrl(baseUrl, fileName);
        ArrayList<String> links = new ArrayList<String>();
        HTMLEditorKit kit = new HTMLEditorKit();
        HTMLDocument doc = (HTMLDocument)((EditorKit)kit).createDefaultDocument();
        doc.putProperty("IgnoreCharsetDirective", new Boolean(true));
        StringReader reader = new StringReader(html);
        ((EditorKit)kit).read(reader, (Document)doc, 0);
        HTMLDocument.Iterator it = doc.getIterator(HTML.Tag.A);
        while (it.isValid()) {
            this.addLink(baseUrl, fileName, doc, it, links);
            it.next();
        }
        result.addAll(links);
        return result;
    }

    protected String getHtmlFromUrl(URL baseUrl, String fileName) throws Exception {
        return this.getString(baseUrl);
    }

    protected void addLink(URL baseUrl, String fileName, HTMLDocument doc, HTMLDocument.Iterator aElement, List<String> links) throws Exception {
        SimpleAttributeSet s = (SimpleAttributeSet)aElement.getAttributes();
        String href = (String)s.getAttribute(HTML.Attribute.HREF);
        if (href != null && !href.startsWith("javascript:") && !href.startsWith("news:") && href.indexOf(35) == -1) {
            String absHref = new URL(new URL(baseUrl.toString()), href).toString();
            links.add(absHref);
        }
    }

    public static void main(String[] args) {
        EclipsePluginSourceByUrlPatternFinder finder = new EclipsePluginSourceByUrlPatternFinder("http://www.mmnt.ru/int/get?st={0}");
        ArrayList<SourceFileResult> results = new ArrayList<SourceFileResult>();
        finder = new EclipsePluginSourceByUrlPatternFinder("http://www.filewatcher.com/_/?q={0}");
        results = new ArrayList();
        finder.find("C:\\Users\\Feeling\\.m2\\repository\\ant\\ant\\1.6.5\\ant-1.6.5.jar", results);
        System.out.println(((SourceFileResult)results.get(0)).getSource());
    }
}

