/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.source.attach.finder;

import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.sf.feeling.decompiler.source.attach.finder.AbstractSourceCodeFinder;
import org.sf.feeling.decompiler.source.attach.finder.GAV;
import org.sf.feeling.decompiler.source.attach.finder.SourceCodeFinder;
import org.sf.feeling.decompiler.source.attach.finder.SourceFileResult;
import org.sf.feeling.decompiler.source.attach.utils.SourceAttachUtil;
import org.sf.feeling.decompiler.source.attach.utils.SourceBindingUtil;
import org.sf.feeling.decompiler.source.attach.utils.UrlDownloader;
import org.sf.feeling.decompiler.util.HashUtils;
import org.sf.feeling.decompiler.util.Logger;
import org.sonatype.nexus.rest.model.NexusArtifact;
import org.sonatype.nexus.rest.model.SearchNGResponse;
import org.sonatype.nexus.rest.model.SearchResponse;

public class NexusSourceCodeFinder
extends AbstractSourceCodeFinder
implements SourceCodeFinder {
    private boolean canceled = false;
    private String serviceUrl;

    public NexusSourceCodeFinder(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public String toString() {
        return this.getClass() + "; serviceUrl=" + this.serviceUrl;
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void find(String binFile, List<SourceFileResult> results) {
        HashSet<GAV> gavs = new HashSet<GAV>();
        try {
            String sha1 = HashUtils.sha1Hash((File)new File(binFile));
            gavs.addAll(this.findArtifactsUsingNexus(null, null, null, null, sha1, false));
        }
        catch (Throwable e) {
            Logger.debug((Throwable)e);
        }
        if (this.canceled) {
            return;
        }
        if (gavs.isEmpty()) {
            try {
                gavs.addAll(this.findGAVFromFile(binFile));
            }
            catch (Throwable e) {
                Logger.debug((Throwable)e);
            }
        }
        if (this.canceled) {
            return;
        }
        HashMap<GAV, String> sourcesUrls = new HashMap<GAV, String>();
        try {
            sourcesUrls.putAll(this.findSourcesUsingNexus(gavs));
        }
        catch (Throwable e) {
            Logger.debug((Throwable)e);
        }
        for (Map.Entry entry : sourcesUrls.entrySet()) {
            try {
                String[] sourceFiles = SourceBindingUtil.getSourceFileByDownloadUrl((String)entry.getValue());
                if (sourceFiles == null || sourceFiles[0] == null || !new File(sourceFiles[0]).exists()) continue;
                File sourceFile = new File(sourceFiles[0]);
                File tempFile = new File(sourceFiles[1]);
                SourceFileResult result = new SourceFileResult((SourceCodeFinder)this, binFile, sourceFile, tempFile, 100);
                results.add(result);
                return;
            }
            catch (Throwable e) {
                Logger.debug((Throwable)e);
            }
        }
        for (Map.Entry entry : sourcesUrls.entrySet()) {
            String name = String.valueOf(((GAV)entry.getKey()).getA()) + '-' + ((GAV)entry.getKey()).getV() + "-sources.jar";
            try {
                String tmpFile = new UrlDownloader().download((String)entry.getValue());
                if (tmpFile == null || !new File(tmpFile).exists() || !SourceAttachUtil.isSourceCodeFor(tmpFile, binFile)) continue;
                this.setDownloadUrl((String)entry.getValue());
                SourceFileResult object = new SourceFileResult((SourceCodeFinder)this, binFile, tmpFile, name, 100);
                Logger.debug((String)(String.valueOf(this.toString()) + " FOUND: " + object), null);
                results.add(object);
            }
            catch (Throwable e) {
                Logger.debug((Throwable)e);
            }
        }
    }

    private Map<GAV, String> findSourcesUsingNexus(Collection<GAV> gavs) throws Exception {
        HashMap<GAV, String> results = new HashMap<GAV, String>();
        for (GAV gav : gavs) {
            if (this.canceled) {
                return results;
            }
            Set<GAV> gavs2 = this.findArtifactsUsingNexus(gav.getG(), gav.getA(), gav.getV(), "sources", null, true);
            for (GAV gav2 : gavs2) {
                results.put(gav, gav2.getArtifactLink());
            }
        }
        return results;
    }

    private Set<GAV> findArtifactsUsingNexus(String g, String a, String v, String c, String sha1, boolean getLink) throws Exception {
        String[] endpoints;
        HashSet<GAV> results = new HashSet<GAV>();
        String nexusUrl = this.getNexusContextUrl();
        String[] stringArray = endpoints = new String[]{String.valueOf(nexusUrl) + "service/local/data_index"};
        int n = endpoints.length;
        int n2 = 0;
        while (n2 < n) {
            String endpoint = stringArray[n2];
            if (this.canceled) {
                return results;
            }
            String urlStr = endpoint;
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            if (g != null) {
                params.put("g", g);
            }
            if (a != null) {
                params.put("a", a);
            }
            if (v != null) {
                params.put("v", v);
            }
            if (c != null) {
                params.put("c", c);
            }
            if (sha1 != null) {
                params.put("sha1", sha1);
            }
            for (Map.Entry entry : params.entrySet()) {
                if (!urlStr.endsWith("&") && !urlStr.endsWith("?")) {
                    urlStr = urlStr.indexOf(63) == -1 ? String.valueOf(urlStr) + "?" : String.valueOf(urlStr) + "&";
                }
                urlStr = String.valueOf(urlStr) + URLEncoder.encode((String)entry.getKey(), "UTF-8") + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8");
            }
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{SearchResponse.class, SearchNGResponse.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            URLConnection connection = new URL(urlStr).openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.connect();
            try {
                Object resp = unmarshaller.unmarshal(connection.getInputStream());
                if (resp instanceof SearchResponse) {
                    SearchResponse srsp = (SearchResponse)resp;
                    for (NexusArtifact ar : srsp.getData()) {
                        GAV gav = new GAV();
                        gav.setG(ar.getGroupId());
                        gav.setA(ar.getArtifactId());
                        gav.setV(ar.getVersion());
                        if (getLink) {
                            gav.setArtifactLink(ar.getArtifactLink());
                        }
                        results.add(gav);
                    }
                }
            }
            catch (Throwable e) {
                Logger.debug((Throwable)e);
            }
            ++n2;
        }
        return results;
    }

    private String getNexusContextUrl() {
        String result = this.serviceUrl.substring(0, this.serviceUrl.lastIndexOf(47));
        if (!result.endsWith("/")) {
            result = String.valueOf(result) + '/';
        }
        return result;
    }
}

