/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.source.attach.finder;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.sf.feeling.decompiler.source.attach.utils.UrlDownloader;
import org.sf.feeling.decompiler.util.HashUtils;
import org.sf.feeling.decompiler.util.Logger;

public class SourceCheck {
    public static boolean proposeSourceLink(String path, String url) throws IOException {
        boolean success = false;
        try {
            if (StringUtils.isNotBlank((String)path) && StringUtils.isNotBlank((String)url)) {
                path = StringUtils.trimToEmpty((String)path);
                url = StringUtils.trimToEmpty((String)url);
                File file1 = new File(path);
                List<String> classnames = SourceCheck.getJavaFileNames(file1, ".class");
                File file2 = SourceCheck.download(url);
                List<String> javanames = SourceCheck.getJavaFileNames(file2, ".java");
                boolean isSource = SourceCheck.isSource(javanames, classnames);
                if (isSource) {
                    String origin = path;
                    String md5 = HashUtils.md5Hash((File)file1);
                    String sha1 = HashUtils.sha1Hash((File)file1);
                    String src_origin = url;
                    String src_md5 = HashUtils.md5Hash((File)file2);
                    String src_sha1 = HashUtils.md5Hash((File)file2);
                    String src_urls = url;
                    SourceCheck.postToServer(origin, md5, sha1, src_origin, src_md5, src_sha1, src_urls);
                    success = true;
                }
            }
        }
        catch (Exception e) {
            Logger.debug((Throwable)e);
        }
        return success;
    }

    private static void postToServer(String origin, String md5, String sha1, String src_origin, String src_md5, String src_sha1, String src_urls) throws UnsupportedEncodingException, MalformedURLException, IOException {
        String data = "origin=" + URLEncoder.encode(origin, "UTF-8");
        data = String.valueOf(String.valueOf(data)) + "&md5=" + md5;
        data = String.valueOf(String.valueOf(data)) + "&sha1=" + sha1;
        data = String.valueOf(String.valueOf(data)) + "&src_origin=" + URLEncoder.encode(src_origin, "UTF-8");
        data = String.valueOf(String.valueOf(data)) + "&src_md5=" + src_md5;
        data = String.valueOf(String.valueOf(data)) + "&src_sha1=" + src_sha1;
        data = String.valueOf(String.valueOf(data)) + "&src_urls=" + URLEncoder.encode(src_urls, "UTF-8");
        URL url2 = new URL("http://javasourceattacher2.appspot.com/rest/libraries");
        HttpURLConnection conn = (HttpURLConnection)url2.openConnection();
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(5000);
        conn.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
        wr.write(data);
        wr.flush();
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while (rd.readLine() != null) {
        }
        wr.close();
        rd.close();
        if (conn.getResponseCode() != 200) {
            throw new IllegalStateException("Cannot submit " + src_origin);
        }
    }

    private static File download(String str) throws Exception {
        return new File(new UrlDownloader().download(str));
    }

    public static boolean isWrongSource(File srcFile, File binFile) throws IOException {
        List<String> classnames = SourceCheck.getJavaFileNames(binFile, ".class");
        List<String> javanames = SourceCheck.getJavaFileNames(srcFile, ".java");
        boolean isWrongSource = !classnames.isEmpty() && javanames.isEmpty();
        return isWrongSource;
    }

    private static boolean isSource(List<String> javanames, List<String> classnames) {
        HashSet<String> javanames2 = new HashSet<String>();
        for (String javaname : javanames) {
            String name = FilenameUtils.getName((String)javaname);
            if (!name.endsWith(".java")) continue;
            javanames2.add(name.substring(0, name.length() - ".java".length()));
        }
        HashSet<String> classnames2 = new HashSet<String>();
        for (String classname : classnames) {
            String name2 = FilenameUtils.getName((String)classname);
            if (!name2.endsWith(".class") || name2.contains("$")) continue;
            classnames2.add(name2.substring(0, name2.length() - ".class".length()));
        }
        javanames2.retainAll(classnames2);
        int commonCount = javanames2.size();
        return (double)(commonCount / classnames2.size()) >= 0.5;
    }

    private static List<String> getJavaFileNames(File file, String ext) throws IOException {
        ArrayList<String> classnames = new ArrayList<String>();
        try (ZipFile zf = new ZipFile(file);){
            Enumeration entries = zf.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(ext)) continue;
                classnames.add(entryName);
            }
        }
        zf.close();
        return classnames;
    }
}

