/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.source.attach.finder;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.sf.feeling.decompiler.source.attach.finder.ArtifactorySourceCodeFinder;
import org.sf.feeling.decompiler.source.attach.finder.EclipsePluginSourceByFTPSearchv3Finder;
import org.sf.feeling.decompiler.source.attach.finder.EclipsePluginSourceByUrlPatternFinder;
import org.sf.feeling.decompiler.source.attach.finder.EclipseSourceReferencesSourceCodeFinder;
import org.sf.feeling.decompiler.source.attach.finder.GrepCodeSourceCodeFinder;
import org.sf.feeling.decompiler.source.attach.finder.JreSourceCodeFinder;
import org.sf.feeling.decompiler.source.attach.finder.MavenRepoSourceCodeFinder;
import org.sf.feeling.decompiler.source.attach.finder.NexusSourceCodeFinder;
import org.sf.feeling.decompiler.source.attach.finder.SourceAttacherServiceSourceCodeFinder;
import org.sf.feeling.decompiler.source.attach.finder.SourceCodeFinder;
import org.sf.feeling.decompiler.source.attach.finder.SourceFileResult;
import org.sf.feeling.decompiler.source.attach.utils.SourceBindingUtil;
import org.sf.feeling.decompiler.util.HashUtils;
import org.sf.feeling.decompiler.util.Logger;

public class SourceCodeFinderFacade
implements SourceCodeFinder {
    private SourceCodeFinder[] finders = new SourceCodeFinder[]{new MavenRepoSourceCodeFinder(), new NexusSourceCodeFinder("https://repository.jboss.org/nexus/index.html"), new NexusSourceCodeFinder("https://oss.sonatype.org/index.html"), new ArtifactorySourceCodeFinder("https://repo.grails.org/grails/webapp/home.html"), new EclipsePluginSourceByUrlPatternFinder("http://www.filewatcher.com/_/?q={0}"), new GrepCodeSourceCodeFinder(), new SourceAttacherServiceSourceCodeFinder(), new NexusSourceCodeFinder("https://repository.apache.org/index.html"), new NexusSourceCodeFinder("https://repository.ow2.org/nexus/index.html"), new NexusSourceCodeFinder("https://maven.java.net/index.html"), new NexusSourceCodeFinder("https://maven.nuxeo.org/nexus/index.html"), new NexusSourceCodeFinder("https://maven.alfresco.com/nexus/index.html"), new NexusSourceCodeFinder("http://nexus.xwiki.org/nexus/index.html"), new ArtifactorySourceCodeFinder("https://repository.cloudera.com/artifactory/webapp/home.html"), new ArtifactorySourceCodeFinder("https://repo.spring.io/webapp/home.html"), new EclipsePluginSourceByFTPSearchv3Finder(), new EclipsePluginSourceByUrlPatternFinder("http://www.mmnt.ru/int/get?st={0}"), new EclipseSourceReferencesSourceCodeFinder(), new JreSourceCodeFinder()};
    private SourceCodeFinder[] jreFinders = new SourceCodeFinder[]{new MavenRepoSourceCodeFinder(), new NexusSourceCodeFinder("https://repository.jboss.org/nexus/index.html"), new JreSourceCodeFinder(), new NexusSourceCodeFinder("https://oss.sonatype.org/index.html"), new ArtifactorySourceCodeFinder("https://repo.grails.org/grails/webapp/home.html"), new EclipsePluginSourceByUrlPatternFinder("http://www.filewatcher.com/_/?q={0}"), new GrepCodeSourceCodeFinder(), new SourceAttacherServiceSourceCodeFinder(), new NexusSourceCodeFinder("https://repository.apache.org/index.html"), new NexusSourceCodeFinder("https://repository.ow2.org/nexus/index.html"), new NexusSourceCodeFinder("https://maven.java.net/index.html"), new NexusSourceCodeFinder("https://maven.nuxeo.org/nexus/index.html"), new NexusSourceCodeFinder("https://maven.alfresco.com/nexus/index.html"), new NexusSourceCodeFinder("http://nexus.xwiki.org/nexus/index.html"), new ArtifactorySourceCodeFinder("https://repository.cloudera.com/artifactory/webapp/home.html"), new ArtifactorySourceCodeFinder("https://repo.spring.io/webapp/home.html"), new EclipsePluginSourceByFTPSearchv3Finder(), new EclipsePluginSourceByUrlPatternFinder("http://www.mmnt.ru/int/get?st={0}"), new EclipseSourceReferencesSourceCodeFinder()};
    private SourceCodeFinder[] eclipseFinders = new SourceCodeFinder[]{new EclipsePluginSourceByFTPSearchv3Finder(), new EclipsePluginSourceByUrlPatternFinder("http://www.mmnt.ru/int/get?st={0}"), new MavenRepoSourceCodeFinder(), new NexusSourceCodeFinder("https://repository.jboss.org/nexus/index.html"), new EclipseSourceReferencesSourceCodeFinder(), new NexusSourceCodeFinder("https://oss.sonatype.org/index.html"), new ArtifactorySourceCodeFinder("https://repo.grails.org/grails/webapp/home.html"), new EclipsePluginSourceByUrlPatternFinder("http://www.filewatcher.com/_/?q={0}"), new GrepCodeSourceCodeFinder(), new SourceAttacherServiceSourceCodeFinder(), new NexusSourceCodeFinder("https://repository.apache.org/index.html"), new NexusSourceCodeFinder("https://repository.ow2.org/nexus/index.html"), new NexusSourceCodeFinder("https://maven.java.net/index.html"), new NexusSourceCodeFinder("https://maven.nuxeo.org/nexus/index.html"), new NexusSourceCodeFinder("https://maven.alfresco.com/nexus/index.html"), new NexusSourceCodeFinder("http://nexus.xwiki.org/nexus/index.html"), new ArtifactorySourceCodeFinder("https://repository.cloudera.com/artifactory/webapp/home.html"), new ArtifactorySourceCodeFinder("https://repo.spring.io/webapp/home.html"), new JreSourceCodeFinder()};
    private boolean canceled;

    @Override
    public void find(String binFilePath, List<SourceFileResult> results) {
        File binFile = new File(binFilePath);
        if (!binFile.exists() || binFile.isDirectory()) {
            return;
        }
        String sha1 = HashUtils.sha1Hash((File)binFile);
        String[] sourceFiles = SourceBindingUtil.getSourceFileBySha(sha1);
        if (sourceFiles != null && sourceFiles[0] != null && new File(sourceFiles[0]).exists()) {
            File sourceFile = new File(sourceFiles[0]);
            File tempFile = new File(sourceFiles[1]);
            SourceFileResult result = new SourceFileResult((SourceCodeFinder)this, binFilePath, sourceFile, tempFile, 100);
            results.add(result);
            return;
        }
        SourceCodeFinder[] searchFinders = this.finders;
        if (binFilePath.toLowerCase().indexOf("jre") != -1) {
            searchFinders = this.jreFinders;
        } else if (binFilePath.toLowerCase().indexOf("eclipse") != -1) {
            searchFinders = this.eclipseFinders;
        }
        int i = 0;
        while (i < searchFinders.length && !this.canceled) {
            ArrayList<SourceFileResult> results2 = new ArrayList<SourceFileResult>();
            SourceCodeFinder finder = searchFinders[i];
            Logger.debug((String)(finder + " " + binFile), null);
            finder.find(binFilePath, results2);
            if (!results2.isEmpty()) {
                results.addAll(results2);
                break;
            }
            ++i;
        }
    }

    @Override
    public void cancel() {
        this.canceled = true;
        int i = 0;
        while (i < this.finders.length && !this.canceled) {
            SourceCodeFinder finder = this.finders[i];
            finder.cancel();
            ++i;
        }
    }

    public static void main(String[] args) {
        SourceCodeFinderFacade finder = new SourceCodeFinderFacade();
        ArrayList<SourceFileResult> results = new ArrayList<SourceFileResult>();
        finder.find("C:\\develop\\runtime-EclipseApplication\\Test\\lib\\groovy-all-1.7.6.jar", results);
        System.out.println(((SourceFileResult)results.get(0)).getSource());
    }

    @Override
    public String getDownloadUrl() {
        return null;
    }
}

