/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.source.attach.handler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.menus.ExtensionContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.services.IServiceLocator;
import org.sf.feeling.decompiler.source.attach.handler.AttachSourceAction;
import org.sf.feeling.decompiler.source.attach.utils.SourceAttachUtil;

public class AttachSourceContributionFactory
extends ExtensionContributionFactory {
    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        boolean attachClasses;
        boolean attachRoot;
        ISelectionService selService = (ISelectionService)serviceLocator.getService(ISelectionService.class);
        final List selectedJars = this.getSelectedElements(selService, IPackageFragmentRoot.class);
        boolean bl = attachRoot = selectedJars.size() == 1;
        if (attachRoot) {
            additions.addContributionItem((IContributionItem)new ActionContributionItem((IAction)new AttachSourceAction(selectedJars)), new Expression(){

                public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
                    boolean menuVisible = SourceAttachUtil.needDownloadSource(selectedJars);
                    if (menuVisible) {
                        return EvaluationResult.TRUE;
                    }
                    return EvaluationResult.FALSE;
                }
            });
            return;
        }
        if (selectedJars.size() > 1) {
            return;
        }
        List selectedPackages = this.getSelectedElements(selService, IPackageFragment.class);
        final List selectedClasses = this.getSelectedElements(selService, IClassFile.class);
        selectedClasses.addAll(selectedPackages);
        boolean bl2 = attachClasses = !selectedClasses.isEmpty();
        if (attachClasses) {
            additions.addContributionItem((IContributionItem)new ActionContributionItem((IAction)new AttachSourceAction(selectedClasses)), new Expression(){

                public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
                    boolean menuVisible = SourceAttachUtil.needDownloadSource(selectedClasses);
                    if (menuVisible) {
                        return EvaluationResult.TRUE;
                    }
                    return EvaluationResult.FALSE;
                }
            });
            return;
        }
    }

    private List getSelectedElements(ISelectionService selService, Class eleClass) {
        Iterator selections = this.getSelections(selService);
        ArrayList elements = new ArrayList();
        while (selections != null && selections.hasNext()) {
            Object select = selections.next();
            if (!eleClass.isInstance(select)) continue;
            elements.add(select);
        }
        return elements;
    }

    private Iterator getSelections(ISelectionService selService) {
        ISelection selection = selService.getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return structuredSelection.iterator();
        }
        return null;
    }
}

