/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.source.attach.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.sf.feeling.decompiler.source.attach.handler.JavaSourceAttacherHandler;
import org.sf.feeling.decompiler.source.attach.utils.SourceBindingUtil;
import org.sf.feeling.decompiler.source.attach.utils.SourceConstants;
import org.sf.feeling.decompiler.util.FileUtil;
import org.sf.feeling.decompiler.util.HashUtils;
import org.sf.feeling.decompiler.util.Logger;
import org.sf.feeling.decompiler.util.ReflectionUtils;

public class SourceAttachUtil {
    public static File getBinFile(IPackageFragmentRoot root) {
        File binFile = !root.isExternal() ? root.getResource().getLocation().toFile() : root.getPath().toFile();
        return binFile;
    }

    public static boolean reattchSource(IPackageFragmentRoot pkgRoot, File sourceFile, File tempSourceFile, String downloadUrl) {
        try {
            File tempFile;
            IPath sourcePath = pkgRoot.getSourceAttachmentPath();
            File tempfile = new File(sourcePath.toOSString());
            if (!tempfile.getAbsolutePath().equals(tempSourceFile.getAbsolutePath())) {
                tempFile = tempSourceFile;
            } else {
                String suffix = "-" + System.currentTimeMillis() + ".jar";
                tempFile = new File(SourceConstants.SourceTempDir, sourceFile.getName().replaceAll("(?i)(\\-)*(\\d)*(\\.)jar", suffix).replaceAll("(?i)(\\-)*(\\d)*(\\.)zip", suffix));
            }
            if (!tempFile.exists()) {
                if (tempSourceFile.exists()) {
                    tempSourceFile.renameTo(tempFile);
                } else {
                    FileUtil.copyFile((String)sourceFile.getAbsolutePath(), (String)tempFile.getAbsolutePath());
                }
            }
            JavaSourceAttacherHandler.attachSource(pkgRoot, tempFile);
            tempFile.deleteOnExit();
            String sha = HashUtils.sha1Hash((File)SourceAttachUtil.getBinFile(pkgRoot));
            SourceBindingUtil.saveSourceBindingRecord(sourceFile, sha, downloadUrl, tempFile);
            return true;
        }
        catch (Exception e) {
            Logger.debug((Throwable)e);
            return false;
        }
    }

    public static boolean refreshSourceAttachStatus(IPackageFragmentRoot root) {
        block8: {
            File tempFile;
            File sourceFile;
            String sha;
            block10: {
                String[] files;
                block9: {
                    sha = HashUtils.sha1Hash((File)SourceAttachUtil.getBinFile(root));
                    files = SourceBindingUtil.getSourceFileBySha(sha);
                    if (files == null || files[0] == null) break block8;
                    sourceFile = new File(files[0]);
                    if (sourceFile.exists()) break block9;
                    return false;
                }
                tempFile = new File(files[1]);
                if (files[1] == null || !tempFile.exists()) break block10;
                JavaSourceAttacherHandler.attachSource(root, tempFile);
                SourceBindingUtil.saveSourceBindingRecord(sourceFile, sha, null, tempFile);
                if (sourceFile.getName().startsWith("jre_")) {
                    SourceAttachUtil.refreshJRELibrarySources(root);
                }
                if (sourceFile.getName().startsWith("eclipse_")) {
                    List<String> packages = SourceAttachUtil.getEclipsePlugins(sourceFile);
                    SourceAttachUtil.refreshEclipseLibrarySources(root, packages);
                }
                return true;
            }
            try {
                String suffix = "-" + System.currentTimeMillis() + ".jar";
                tempFile = new File(SourceConstants.SourceTempDir, sourceFile.getName().replaceAll("(?i)(\\-)*(\\d)*(\\.)jar", suffix).replaceAll("(?i)(\\-)*(\\d)*(\\.)zip", suffix));
                FileUtil.copyFile((String)sourceFile.getAbsolutePath(), (String)tempFile.getAbsolutePath());
                JavaSourceAttacherHandler.attachSource(root, tempFile);
                tempFile.deleteOnExit();
                SourceBindingUtil.saveSourceBindingRecord(sourceFile, sha, null, tempFile);
                if (sourceFile.getName().startsWith("jre_")) {
                    SourceAttachUtil.refreshJRELibrarySources(root);
                }
                if (sourceFile.getName().startsWith("eclipse_")) {
                    List<String> packages = SourceAttachUtil.getEclipsePlugins(sourceFile);
                    SourceAttachUtil.refreshEclipseLibrarySources(root, packages);
                }
                return true;
            }
            catch (Exception e) {
                Logger.debug((Throwable)e);
            }
        }
        return false;
    }

    public static List<String> getEclipsePlugins(File file) throws IOException {
        HashSet<String> plugins = new HashSet<String>();
        ZipFile zf = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            String zipEntryName = entries.nextElement().getName();
            if (!zipEntryName.endsWith(".project")) continue;
            String[] segements = zipEntryName.replace("/.project", "").split("/");
            plugins.add(segements[segements.length - 1]);
        }
        zf.close();
        return new ArrayList<String>(plugins);
    }

    private static boolean refreshLibrarySources(IPackageFragmentRoot root, String[] files) {
        File tempFile;
        File sourceFile;
        String sha;
        block5: {
            block4: {
                try {
                    sha = HashUtils.sha1Hash((File)SourceAttachUtil.getBinFile(root));
                    sourceFile = new File(files[0]);
                    if (sourceFile.exists()) break block4;
                    return false;
                }
                catch (Exception e) {
                    Logger.debug((Throwable)e);
                    return false;
                }
            }
            tempFile = new File(files[1]);
            if (files[1] == null || !tempFile.exists()) break block5;
            JavaSourceAttacherHandler.attachSource(root, tempFile);
            tempFile.deleteOnExit();
            SourceBindingUtil.saveSourceBindingRecord(sourceFile, sha, null, tempFile);
            return true;
        }
        String suffix = "-" + System.currentTimeMillis() + ".jar";
        tempFile = new File(SourceConstants.SourceTempDir, sourceFile.getName().replaceAll("(?i)(\\-)*(\\d)*(\\.)jar", suffix).replaceAll("(?i)(\\-)*(\\d)*(\\.)zip", suffix));
        FileUtil.copyFile((String)sourceFile.getAbsolutePath(), (String)tempFile.getAbsolutePath());
        JavaSourceAttacherHandler.attachSource(root, tempFile);
        tempFile.deleteOnExit();
        SourceBindingUtil.saveSourceBindingRecord(sourceFile, sha, null, tempFile);
        return true;
    }

    private static void refreshJRELibrarySources(final IPackageFragmentRoot pkgRoot) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    String sha = HashUtils.sha1Hash((File)SourceAttachUtil.getBinFile(pkgRoot));
                    String[] files = SourceBindingUtil.getSourceFileBySha(sha);
                    IPackageFragmentRoot[] roots = pkgRoot.getJavaProject().getAllPackageFragmentRoots();
                    int i = 0;
                    while (i < roots.length) {
                        List<String> paths;
                        IPackageFragmentRoot element = roots[i];
                        if (!element.equals(pkgRoot) && (paths = Arrays.asList(element.getPath().segments())).contains("jre")) {
                            SourceAttachUtil.refreshLibrarySources(element, files);
                        }
                        ++i;
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    private static void refreshEclipseLibrarySources(final IPackageFragmentRoot pkgRoot, final List<String> plugins) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    String sha = HashUtils.sha1Hash((File)SourceAttachUtil.getBinFile(pkgRoot));
                    String[] files = SourceBindingUtil.getSourceFileBySha(sha);
                    IPackageFragmentRoot[] roots = pkgRoot.getJavaProject().getAllPackageFragmentRoots();
                    int i = 0;
                    while (i < roots.length) {
                        String fileName;
                        IPackageFragmentRoot element = roots[i];
                        if (!element.equals(pkgRoot) && plugins.contains((fileName = element.getPath().lastSegment()).split("_")[0])) {
                            SourceAttachUtil.refreshLibrarySources(element, files);
                        }
                        ++i;
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        };
        thread.start();
    }

    public static void updateSourceAttachStatus(IPackageFragmentRoot root) {
        try {
            IClasspathEntry entry = JavaModelUtil.getClasspathEntry((IPackageFragmentRoot)root);
            IPath containerPath = null;
            if (entry.getEntryKind() == 5) {
                containerPath = entry.getPath();
            }
            String[] changedAttributes = new String[]{"sourcepath", "source_encoding"};
            BuildPathSupport.modifyClasspathEntry(null, (IClasspathEntry)entry, (String[])changedAttributes, (IJavaProject)root.getJavaProject(), (IPath)containerPath, (entry.getReferencingEntry() != null ? 1 : 0) != 0, (IProgressMonitor)new NullProgressMonitor());
            if (root instanceof PackageFragmentRoot) {
                Object rootInfo = ((PackageFragmentRoot)root).getElementInfo();
                ReflectionUtils.setFieldValue((Object)rootInfo, (String)"sourceMapper", null);
            }
        }
        catch (Exception e) {
            Logger.debug((Throwable)e);
        }
    }

    public static boolean isSourceCodeFor(String src, String bin) {
        boolean result = false;
        try {
            String zipEntryName;
            ArrayList<String> binList = new ArrayList<String>();
            ZipFile zf = new ZipFile(bin);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                zipEntryName = entries.nextElement().getName();
                binList.add(zipEntryName);
            }
            zf.close();
            zf = new ZipFile(src);
            entries = zf.entries();
            while (entries.hasMoreElements()) {
                zipEntryName = entries.nextElement().getName();
                String fileBaseName = FilenameUtils.getBaseName((String)zipEntryName);
                String fileExt = FilenameUtils.getExtension((String)zipEntryName);
                if ("java".equals(fileExt) && fileBaseName != null) {
                    for (String zipEntryName2 : binList) {
                        String fileBaseName2 = FilenameUtils.getBaseName((String)zipEntryName2);
                        String fileExt2 = FilenameUtils.getExtension((String)zipEntryName2);
                        if (!"class".equals(fileExt2) || !fileBaseName.equals(fileBaseName2)) continue;
                        result = true;
                        zf.close();
                        return result;
                    }
                }
                binList.add(zipEntryName);
            }
            zf.close();
        }
        catch (Exception e) {
            Logger.debug((Throwable)e);
        }
        return result;
    }

    public static boolean isMavenLibrary(IPackageFragmentRoot library) {
        try {
            IClasspathEntry entry = JavaModelUtil.getClasspathEntry((IPackageFragmentRoot)library);
            return entry.getPath().toString().indexOf("MAVEN2_CLASSPATH_CONTAINER") != -1;
        }
        catch (Exception e) {
            Logger.debug((Throwable)e);
            return false;
        }
    }

    public static boolean enableMavenDownload() {
        try {
            Class<?> clazz = Class.forName("org.eclipse.m2e.jdt.IClasspathManager");
            Class[] parameterTypes = new Class[]{IPackageFragmentRoot.class, Boolean.TYPE, Boolean.TYPE};
            if (clazz.getMethod("scheduleDownload", parameterTypes) != null) {
                return true;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.debug((String)"Class org.eclipse.m2e.jdt.IClasspathManager not found.", null);
        }
        catch (NoSuchMethodException ex) {
            Logger.debug((String)"Method scheduleDownload not found.", null);
        }
        catch (Exception e) {
            Logger.debug((Throwable)e);
        }
        return false;
    }

    public static boolean needDownloadSource(List<?> selection) {
        IPackageFragmentRoot root = null;
        int i = 0;
        while (i < selection.size()) {
            IPackageFragmentRoot packRoot = null;
            Object obj = selection.get(i);
            if (obj instanceof IPackageFragment) {
                IPackageFragment packageFragment = (IPackageFragment)obj;
                packRoot = (IPackageFragmentRoot)packageFragment.getParent();
            } else if (obj instanceof IClassFile) {
                IClassFile classFile = (IClassFile)obj;
                packRoot = (IPackageFragmentRoot)classFile.getParent().getParent();
            } else if (obj instanceof IPackageFragmentRoot) {
                packRoot = (IPackageFragmentRoot)obj;
            } else {
                return false;
            }
            if (root == null) {
                root = packRoot;
            } else if (root != packRoot) {
                return false;
            }
            ++i;
        }
        try {
            if (root != null && root.getSourceAttachmentPath() != null && root.getSourceAttachmentPath().toFile().exists() && !root.getPath().toFile().equals(root.getSourceAttachmentPath().toFile())) {
                return false;
            }
        }
        catch (JavaModelException e) {
            Logger.debug((Throwable)e);
        }
        return true;
    }
}

