/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.source.attach.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmRevision;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.manager.BasicScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.accurev.AccuRevScmProvider;
import org.apache.maven.scm.provider.bazaar.BazaarScmProvider;
import org.apache.maven.scm.provider.clearcase.ClearCaseScmProvider;
import org.apache.maven.scm.provider.cvslib.cvsexe.CvsExeScmProvider;
import org.apache.maven.scm.provider.cvslib.cvsjava.CvsJavaScmProvider;
import org.apache.maven.scm.provider.git.jgit.JGitScmProvider;
import org.apache.maven.scm.provider.hg.HgScmProvider;
import org.apache.maven.scm.provider.jazz.JazzScmProvider;
import org.apache.maven.scm.provider.local.LocalScmProvider;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.starteam.StarteamScmProvider;
import org.apache.maven.scm.provider.svn.svnexe.SvnExeScmProvider;
import org.apache.maven.scm.provider.synergy.SynergyScmProvider;
import org.apache.maven.scm.provider.vss.VssScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Zip;
import org.sf.feeling.decompiler.util.HashUtils;
import org.sf.feeling.decompiler.util.Logger;

public class UrlDownloader {
    public String download(String url) throws Exception {
        String result = StringUtils.startsWith((String)url, (String)"scm:") ? this.downloadFromScm(url) : (new File(url).exists() ? url : this.downloadFromUrl(url));
        return result;
    }

    private String downloadFromScm(String url) throws Exception {
        if (url.indexOf("cvs:pserver:") != -1 && url.indexOf("@") == -1) {
            url = url.replace("cvs:pserver:", "cvs:pserver:anonymous:@");
        }
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File checkoutDirectory = new File(tmpDir, "source_" + HashUtils.md5Hash((String)url));
        File file = new File(tmpDir, "source_" + HashUtils.md5Hash((String)url) + ".zip");
        if (!file.exists()) {
            block29: {
                if (!checkoutDirectory.exists() || checkoutDirectory.list().length == 0 || checkoutDirectory.list().length == 1 && checkoutDirectory.list()[0].startsWith(".")) {
                    ScmTag scmVersion;
                    String fragment;
                    String scmUrl;
                    BasicScmManager scmManager = new BasicScmManager();
                    scmManager.setScmProvider("accurev", (ScmProvider)new AccuRevScmProvider());
                    scmManager.setScmProvider("bazaar", (ScmProvider)new BazaarScmProvider());
                    scmManager.setScmProvider("clearcase", (ScmProvider)new ClearCaseScmProvider());
                    scmManager.setScmProvider("hg", (ScmProvider)new HgScmProvider());
                    scmManager.setScmProvider("local", (ScmProvider)new LocalScmProvider());
                    scmManager.setScmProvider("perforce", (ScmProvider)new PerforceScmProvider());
                    scmManager.setScmProvider("cvs_native", (ScmProvider)new CvsExeScmProvider());
                    scmManager.setScmProvider("cvs", (ScmProvider)new CvsJavaScmProvider());
                    scmManager.setScmProvider("git", (ScmProvider)new JGitScmProvider());
                    scmManager.setScmProvider("svn", (ScmProvider)new SvnExeScmProvider());
                    scmManager.setScmProvider("starteam", (ScmProvider)new StarteamScmProvider());
                    scmManager.setScmProvider("synergy", (ScmProvider)new SynergyScmProvider());
                    scmManager.setScmProvider("vss", (ScmProvider)new VssScmProvider());
                    scmManager.setScmProvider("jazz", (ScmProvider)new JazzScmProvider());
                    if (url.indexOf(35) != -1) {
                        scmUrl = StringUtils.trimToEmpty((String)url.substring(0, url.indexOf(35)));
                        fragment = StringUtils.trimToEmpty((String)url.substring(url.indexOf(35) + 1));
                        if (fragment.indexOf(61) != -1) {
                            String[] versionTypeAndVersion = StringUtils.split((String)fragment, (char)'=');
                            String version = StringUtils.trim((String)versionTypeAndVersion[1]);
                            String type = StringUtils.trim((String)versionTypeAndVersion[0]);
                            if ("tag".equals(type)) {
                                scmVersion = new ScmTag(version);
                            } else if ("branch".equals(type)) {
                                scmVersion = new ScmBranch(version);
                            } else if ("revision".equals(type)) {
                                scmVersion = new ScmRevision(version);
                            } else {
                                if (!"commitId".equals(type)) {
                                    throw new IllegalArgumentException("'" + type + "' version type isn't known.");
                                }
                                scmVersion = new ScmRevision(version);
                            }
                        } else {
                            scmVersion = new ScmTag(fragment);
                        }
                    } else if (url.indexOf(59) != -1) {
                        scmUrl = StringUtils.trimToEmpty((String)url.substring(0, url.indexOf(59)));
                        fragment = StringUtils.trimToEmpty((String)url.substring(url.indexOf(59) + 1));
                        scmVersion = null;
                        if (fragment.indexOf(61) != -1) {
                            String[] properties;
                            String[] array = properties = StringUtils.split((String)fragment, (char)';');
                            int length = properties.length;
                            int i = 0;
                            while (i < length) {
                                String property = array[i];
                                String[] versionTypeAndVersion2 = StringUtils.split((String)property, (char)'=');
                                String version2 = StringUtils.strip((String)versionTypeAndVersion2[1], (String)" \"");
                                String type2 = StringUtils.trim((String)versionTypeAndVersion2[0]);
                                if ("tag".equals(type2)) {
                                    scmVersion = new ScmTag(version2);
                                    break;
                                }
                                if ("branch".equals(type2)) {
                                    scmVersion = new ScmBranch(version2);
                                    break;
                                }
                                if ("revision".equals(type2)) {
                                    scmVersion = new ScmRevision(version2);
                                    break;
                                }
                                if ("commitId".equals(type2)) {
                                    scmVersion = new ScmRevision(version2);
                                    break;
                                }
                                ++i;
                            }
                        } else {
                            scmVersion = new ScmTag(fragment);
                        }
                    } else {
                        scmUrl = url;
                        scmVersion = null;
                    }
                    if (!checkoutDirectory.exists()) {
                        checkoutDirectory.mkdir();
                    }
                    ScmRepository repository = scmManager.makeScmRepository(scmUrl);
                    try {
                        scmManager.checkOut(repository, new ScmFileSet(checkoutDirectory), scmVersion);
                    }
                    catch (Exception e) {
                        Logger.debug((Throwable)e);
                        if (!checkoutDirectory.exists()) break block29;
                        FileUtils.deleteDirectory((File)checkoutDirectory);
                    }
                }
            }
            if (checkoutDirectory.exists() && checkoutDirectory.list().length > 0) {
                this.zipFolder(checkoutDirectory, file);
                FileUtils.deleteDirectory((File)checkoutDirectory);
            }
        }
        String result = null;
        if (file.exists()) {
            result = file.getAbsolutePath();
        }
        return result;
    }

    public void zipFolder(File srcFolder, File destZipFile) {
        Zip zipper = new Zip();
        zipper.setLevel(1);
        zipper.setDestFile(destZipFile);
        zipper.setBasedir(srcFolder);
        zipper.setIncludes("**/*.java");
        zipper.setTaskName("zip");
        zipper.setTaskType("zip");
        zipper.setProject(new Project());
        zipper.setOwningTarget(new Target());
        zipper.execute();
    }

    public void delete(File folder) {
        Delete delete = new Delete();
        delete.setDir(folder);
        delete.setTaskName("delete");
        delete.setTaskType("delete");
        delete.setProject(new Project());
        delete.setOwningTarget(new Target());
        delete.execute();
    }

    private String downloadFromUrl(String url) throws IOException {
        File file = File.createTempFile("source", ".tmp");
        InputStream is = null;
        FileOutputStream os = null;
        try {
            try {
                URLConnection conn = new URL(url).openConnection();
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(5000);
                is = this.openConnectionCheckRedirects(conn);
                os = FileUtils.openOutputStream((File)file);
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            catch (Exception ex) {
                IOUtils.closeQuietly(os);
                file.delete();
                String string = file.getAbsolutePath();
                IOUtils.closeQuietly(os);
                IOUtils.closeQuietly(is);
                return string;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(os);
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)os);
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
        IOUtils.closeQuietly((InputStream)is);
        String result = file.getAbsolutePath();
        return result;
    }

    private InputStream openConnectionCheckRedirects(URLConnection c) throws IOException {
        boolean redir;
        int redirects = 0;
        InputStream in = null;
        do {
            HttpURLConnection http;
            int stat;
            if (c instanceof HttpURLConnection) {
                ((HttpURLConnection)c).setInstanceFollowRedirects(false);
                c.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7");
            }
            in = c.getInputStream();
            redir = false;
            if (!(c instanceof HttpURLConnection) || (stat = (http = (HttpURLConnection)c).getResponseCode()) < 300 || stat > 307 || stat == 306 || stat == 304) continue;
            URL base = http.getURL();
            String loc = http.getHeaderField("Location");
            URL target = null;
            if (loc != null) {
                target = new URL(base, loc);
            }
            http.disconnect();
            if (target == null || !target.getProtocol().equals("http") && !target.getProtocol().equals("https") || redirects >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            redir = true;
            c = target.openConnection();
            c.setConnectTimeout(5000);
            c.setReadTimeout(5000);
            ++redirects;
        } while (redir);
        return in;
    }
}

