/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.validation.datasource.impl;

import com.kms.katalon.validation.datasource.adapter.IFilterSurveysDataSource;
import com.kms.katalon.validation.exception.DataSourceException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.Properties;

public class FilterSurveyFileDataSource
implements IFilterSurveysDataSource {
    private Connection conn;
    private Properties properties;

    public FilterSurveyFileDataSource(Connection conn, Properties properties) {
        this.conn = conn;
        this.properties = properties;
    }

    @Override
    public boolean isAlreadyShownBefore(String surveyId) throws DataSourceException {
        return Boolean.valueOf(this.properties.getProperty(surveyId, "false"));
    }

    @Override
    public boolean executeQuery(String query) throws DataSourceException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Statement statement = this.conn.createStatement();){
                ResultSet results = statement.executeQuery(query);
                results.next();
                int columnCount = results.getMetaData().getColumnCount();
                int i = 1;
                while (i <= columnCount) {
                    Object valueObj = results.getObject(i);
                    if (valueObj instanceof Boolean) {
                        return results.getObject(i, Boolean.class);
                    }
                    ++i;
                }
                throw new DataSourceException("No boolean value returned by query !");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLSyntaxErrorException sQLSyntaxErrorException) {
            return false;
        }
        catch (SQLException e) {
            throw new DataSourceException(e);
        }
    }
}

