/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.validation.datasource.impl;

import com.kms.katalon.validation.datasource.adapter.IInsertEventIntoDatabaseDataSource;
import com.kms.katalon.validation.exception.DataSourceException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class InsertEventIntoDatabaseDataSource
implements IInsertEventIntoDatabaseDataSource {
    private static final String ID = "ID";
    private static final String EVENT_NAME = "EVENTNAME";
    private static final String SCHEMA = "APP";
    private Connection conn;

    public InsertEventIntoDatabaseDataSource(Connection conn) {
        this.conn = conn;
    }

    @Override
    public Map<String, Object> getEventPropertiesAsMap(Object[] properties) throws DataSourceException {
        HashMap<String, Object> propertiesAsMap = new HashMap<String, Object>();
        if (properties != null) {
            int i = 0;
            while (i < properties.length - 1) {
                String key = (String)properties[i];
                Object value = properties[i + 1];
                if (value instanceof Character) {
                    propertiesAsMap.put(key, value);
                } else if (value instanceof String) {
                    propertiesAsMap.put(key, value);
                } else if (value instanceof Number) {
                    propertiesAsMap.put(key, value);
                } else if (value instanceof Boolean) {
                    propertiesAsMap.put(key, value);
                } else if (value instanceof LocalDate) {
                    propertiesAsMap.put(key, Date.valueOf((LocalDate)value));
                }
                i += 2;
            }
        }
        return propertiesAsMap;
    }

    @Override
    public boolean checkIfSchemaExists(String eventName) throws DataSourceException {
        try {
            DatabaseMetaData metaData = this.conn.getMetaData();
            ResultSet tables = metaData.getTables(null, SCHEMA, eventName.toUpperCase(), new String[]{"TABLE"});
            boolean tableExists = tables.next();
            return tableExists;
        }
        catch (SQLException e) {
            throw new DataSourceException(e);
        }
    }

    @Override
    public Set<String> createSchemaForEvent(Map<String, Object> propertiesMap) throws DataSourceException {
        String tableName = String.valueOf(propertiesMap.get(EVENT_NAME));
        String createSchemaQuery = QueryUtil.getCreateSchemaQuery(propertiesMap, tableName);
        String createIndexQuery = QueryUtil.getCreateIndexQuery(tableName);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Statement statement = this.conn.createStatement();){
                statement.execute(createSchemaQuery);
                statement.execute(createIndexQuery);
                return this.getExistingSchema(tableName);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DataSourceException(e);
        }
    }

    @Override
    public Set<String> getExistingSchema(String tableName) throws DataSourceException {
        HashSet<String> schemaColumns = new HashSet<String>();
        try {
            ResultSet results = this.conn.getMetaData().getColumns(null, null, tableName.toUpperCase(), null);
            while (results.next()) {
                String columnName = results.getString("COLUMN_NAME");
                schemaColumns.add(columnName);
            }
        }
        catch (SQLException e) {
            throw new DataSourceException(e);
        }
        return schemaColumns;
    }

    @Override
    public Map<String, Object> insertEventIntoSchema(Map<String, Object> propertiesMap) throws DataSourceException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Statement statement = this.conn.createStatement();){
                String insertQuery = "";
                String tableName = String.valueOf(propertiesMap.get(EVENT_NAME));
                HashMap<String, Object> savedProperties = new HashMap<String, Object>();
                insertQuery = QueryUtil.getInsertValueQuery(propertiesMap);
                String id = (String)propertiesMap.getOrDefault(ID, "");
                statement.executeUpdate(insertQuery);
                ResultSet results = statement.executeQuery(QueryUtil.getSelectWithIdQuery(tableName, id));
                results.next();
                int columnCount = results.getMetaData().getColumnCount();
                int i = 1;
                while (i <= columnCount) {
                    String key = results.getMetaData().getColumnName(i);
                    Object value = this.getValueWithType(results, i);
                    savedProperties.put(key, value);
                    ++i;
                }
                return savedProperties;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DataSourceException(e);
        }
    }

    @Override
    public Set<String> insertNewColumnsIntoSchema(String eventName, Map<String, Object> newProperties) throws DataSourceException {
        HashSet<String> newInsertedColumns = new HashSet<String>();
        for (Map.Entry<String, Object> entry : newProperties.entrySet()) {
            String insertNewColumnQuery = QueryUtil.getAddColumnQuery(entry, eventName);
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (Statement statement = this.conn.createStatement();){
                    statement.execute(insertNewColumnQuery);
                    newInsertedColumns.addAll(this.getExistingSchema(eventName));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DataSourceException(e);
            }
        }
        return newInsertedColumns;
    }

    private Object getValueWithType(ResultSet results, int indexInResults) throws SQLException {
        Object value = results.getObject(indexInResults);
        if (value instanceof Character) {
            value = results.getObject(indexInResults, Character.class);
        } else if (value instanceof String) {
            value = results.getObject(indexInResults, String.class);
        } else if (value instanceof Number) {
            value = results.getObject(indexInResults, Number.class);
        } else if (value instanceof Boolean) {
            value = results.getObject(indexInResults, Boolean.class);
        } else if (value instanceof Date) {
            value = results.getObject(indexInResults, Date.class);
        }
        return value;
    }

    @Override
    public Map<String, Object> addIdentifyingAttributes(String eventName, Map<String, Object> propertiesMap) {
        HashMap<String, Object> clonedMap = new HashMap<String, Object>(propertiesMap);
        clonedMap.put(ID, UUID.randomUUID().toString());
        clonedMap.put("CREATEDAT", Date.valueOf(LocalDate.now()));
        clonedMap.put(EVENT_NAME, eventName);
        return clonedMap;
    }

    private static class QueryUtil {
        private QueryUtil() {
        }

        private static String getInsertValueIntoTableQuery(String tableName, String columnName, String values) {
            return "insert into " + tableName + columnName + " values" + values;
        }

        public static String getSelectWithIdQuery(String tableName, String id) {
            return "select * from " + tableName + " where ID='" + id + "'";
        }

        public static String getCreateIndexQuery(String tableName) {
            return "CREATE INDEX id_index on " + tableName + " (ID)";
        }

        public static String getCreateSchemaQuery(Map<String, Object> propertiesMap, String tableName) {
            return "CREATE TABLE " + tableName + "(" + QueryUtil.getSchemaColumnsForCreateSchemaQuery(propertiesMap) + ")";
        }

        public static String getAddColumnQuery(Map.Entry<String, Object> entry, String tableName) {
            return "ALTER TABLE " + tableName + " ADD " + QueryUtil.getSchemaColumnsForInsertColumnQuery(entry);
        }

        public static String getSchemaColumnsForCreateSchemaQuery(Map<String, Object> propertiesMap) {
            String result = "";
            for (Map.Entry<String, Object> entry : propertiesMap.entrySet()) {
                String columnName = entry.getKey();
                String columnType = QueryUtil.getSchemaColumnType(entry.getValue());
                result = String.valueOf(result) + columnName + " " + columnType + ", ";
            }
            result = String.valueOf(result) + " PRIMARY KEY (ID)";
            return result;
        }

        public static String getSchemaColumnsForInsertColumnQuery(Map.Entry<String, Object> entry) {
            String result = "";
            String columnName = entry.getKey();
            String columnType = QueryUtil.getSchemaColumnType(entry.getValue());
            result = String.valueOf(result) + columnName + " " + columnType;
            return result;
        }

        private static String getSchemaColumnType(Object value) {
            if (value instanceof Character) {
                return "VARCHAR(1)";
            }
            if (value instanceof String) {
                return "VARCHAR(255)";
            }
            if (value instanceof Number) {
                return "INT";
            }
            if (value instanceof Boolean) {
                return "BOOLEAN";
            }
            if (value instanceof Date) {
                return "DATE";
            }
            return "VARCHAR(255)";
        }

        public static String getInsertValueQuery(Map<String, Object> propertiesMap) {
            String tableName = String.valueOf(propertiesMap.get(InsertEventIntoDatabaseDataSource.EVENT_NAME));
            String columnName = "(";
            String values = "(";
            for (Map.Entry<String, Object> entry : propertiesMap.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                columnName = String.valueOf(columnName) + key + ", ";
                values = value instanceof Character || value instanceof String ? String.valueOf(values) + "'" + value + "', " : (value instanceof Date ? String.valueOf(values) + "'" + value + "', " : String.valueOf(values) + value + ", ");
            }
            columnName = columnName.replaceAll(", $", "");
            columnName = String.valueOf(columnName) + ")";
            values = values.replaceAll(", $", "");
            values = String.valueOf(values) + ")";
            String insertValueIntoTable = QueryUtil.getInsertValueIntoTableQuery(tableName, columnName, values);
            return insertValueIntoTable;
        }
    }
}

