/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.validation.usecase.impl;

import com.kms.katalon.validation.datasource.adapter.IFilterSurveysDataSource;
import com.kms.katalon.validation.domain.IValidationSurvey;
import com.kms.katalon.validation.exception.DataSourceException;
import com.kms.katalon.validation.exception.UseCaseException;
import com.kms.katalon.validation.usecase.adapter.IFilterSurveysUseCase;
import com.kms.katalon.validation.usecase.adapter.input.FilterSurveysUseCaseInput;
import com.kms.katalon.validation.usecase.adapter.output.FilterSurveysUseCaseOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class FilterSurveysUseCase
implements IFilterSurveysUseCase {
    private IFilterSurveysDataSource datasource;

    public FilterSurveysUseCase(IFilterSurveysDataSource datasource) {
        this.datasource = datasource;
    }

    @Override
    public FilterSurveysUseCaseOutput filterSurveys(FilterSurveysUseCaseInput input) throws UseCaseException {
        List<IValidationSurvey> surveys = input.getSurveys();
        String triggerEvent = input.getEventName();
        String errorMessage = "";
        if (triggerEvent == null || triggerEvent.equals("")) {
            throw new UseCaseException("Trigger event cannot be null or empty");
        }
        if (surveys == null || surveys.isEmpty()) {
            return new FilterSurveysUseCaseOutput(new ArrayList<IValidationSurvey>(), "No input surveys, returned an empty list", true, 0, 0);
        }
        ArrayList<IValidationSurvey> filteredSurveys = new ArrayList<IValidationSurvey>();
        for (IValidationSurvey survey : surveys) {
            try {
                Optional<String> optionalTriggerQuery = survey.getOptionalTriggerQuery();
                if (!triggerEvent.equals(survey.getTriggerEventName()) || this.datasource.isAlreadyShownBefore(survey.getSurveyId()) || optionalTriggerQuery.isPresent() && !this.datasource.executeQuery(optionalTriggerQuery.get())) continue;
                filteredSurveys.add(survey);
            }
            catch (DataSourceException e) {
                errorMessage = e.getMessage();
                break;
            }
        }
        if (!errorMessage.equals("")) {
            return new FilterSurveysUseCaseOutput(new ArrayList<IValidationSurvey>(), errorMessage, false, surveys.size(), 0);
        }
        return new FilterSurveysUseCaseOutput(filteredSurveys, "Successfully filtered surveys", true, surveys.size(), filteredSurveys.size());
    }
}

