/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.validation.usecase.impl;

import com.kms.katalon.validation.datasource.adapter.IGetSpecificationFileDataSource;
import com.kms.katalon.validation.exception.DataSourceException;
import com.kms.katalon.validation.exception.UseCaseException;
import com.kms.katalon.validation.usecase.adapter.IGetSpecificationFileUseCase;
import com.kms.katalon.validation.usecase.adapter.input.GetSpecificationFileInput;
import com.kms.katalon.validation.usecase.adapter.output.GetSpecificationFileOutput;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class GetSpecificationFileUseCase
implements IGetSpecificationFileUseCase {
    private IGetSpecificationFileDataSource dataSource;

    public GetSpecificationFileUseCase(IGetSpecificationFileDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public GetSpecificationFileOutput getSpecificationFile(GetSpecificationFileInput input) throws UseCaseException {
        String url = input.getUrl();
        String fileLocation = input.getFileLocation();
        String authToken = input.getAuthToken();
        String errorMessage = "";
        if (StringUtils.isEmpty((CharSequence)url)) {
            throw new UseCaseException("URL is empty");
        }
        if (fileLocation == null || fileLocation.isEmpty()) {
            throw new UseCaseException("File location is empty");
        }
        try {
            File specificationFile = this.dataSource.getSpecificationFile(url, authToken, fileLocation);
            if (specificationFile == null) {
                throw new UseCaseException("File was not created successfully!");
            }
            if (!specificationFile.getAbsolutePath().equals(fileLocation)) {
                throw new UseCaseException("File is not at specified location !");
            }
            return new GetSpecificationFileOutput(specificationFile);
        }
        catch (DataSourceException e) {
            errorMessage = e.getMessage();
            return new GetSpecificationFileOutput(errorMessage);
        }
    }
}

