/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.validation.usecase.impl;

import com.kms.katalon.validation.datasource.adapter.IInsertEventIntoDatabaseDataSource;
import com.kms.katalon.validation.exception.DataSourceException;
import com.kms.katalon.validation.exception.UseCaseException;
import com.kms.katalon.validation.usecase.adapter.IInsertEventIntoDatabaseUseCase;
import com.kms.katalon.validation.usecase.adapter.input.InsertEventIntoDatabaseInput;
import com.kms.katalon.validation.usecase.adapter.output.InsertEventIntoDatabaseOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class InsertEventIntoDatabaseUseCase
implements IInsertEventIntoDatabaseUseCase {
    private IInsertEventIntoDatabaseDataSource dataSource;

    public InsertEventIntoDatabaseUseCase(IInsertEventIntoDatabaseDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public InsertEventIntoDatabaseOutput insertEvent(InsertEventIntoDatabaseInput input) throws UseCaseException {
        String eventName = input.getEventName();
        Object[] properties = input.getProperties();
        String errorMessage = "";
        if (eventName == null || eventName.equals("")) {
            throw new UseCaseException("Event name cannot be null or empty");
        }
        try {
            Map<String, Object> insertedPropertiesMap;
            Map<String, Object> propertiesMap = new HashMap<String, Object>(this.dataSource.getEventPropertiesAsMap(properties));
            propertiesMap = this.dataSource.addIdentifyingAttributes(eventName, propertiesMap);
            Set<String> eventColumns = propertiesMap.keySet();
            if (!this.dataSource.checkIfSchemaExists(eventName)) {
                Set<String> createdColumns = this.dataSource.createSchemaForEvent(propertiesMap);
                if (!this.equalIgnoreCase(createdColumns, eventColumns)) {
                    throw new UseCaseException("Created schema does not have all the specified columns !");
                }
            } else {
                Set<String> createdColumns;
                Map<String, Object> newColumns = this.getNewColumns(eventName, propertiesMap);
                if (newColumns.size() > 0 && !this.equalIgnoreCase(createdColumns = this.dataSource.insertNewColumnsIntoSchema(eventName, newColumns), eventColumns)) {
                    throw new UseCaseException("Cannot create new columns for schema");
                }
            }
            if (!this.containIgnoreCase((insertedPropertiesMap = this.dataSource.insertEventIntoSchema(propertiesMap)).keySet(), eventColumns)) {
                throw new UseCaseException("Inserted event does not have all the specified properties !");
            }
            return new InsertEventIntoDatabaseOutput(true, "Successfully inserted event into database");
        }
        catch (DataSourceException e) {
            errorMessage = e.getMessage();
        }
        catch (Exception e) {
            throw new UseCaseException(e.getMessage());
        }
        return new InsertEventIntoDatabaseOutput(false, errorMessage);
    }

    private Map<String, Object> getNewColumns(String eventName, Map<String, Object> propertiesMap) throws DataSourceException {
        Set<String> schemaColumns = this.dataSource.getExistingSchema(eventName);
        TreeMap<String, Object> newProperties = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        newProperties.putAll(propertiesMap);
        for (String schemaColumn : schemaColumns) {
            newProperties.remove(schemaColumn);
        }
        return newProperties;
    }

    private boolean equalIgnoreCase(Set<String> keySet1, Set<String> keySet2) {
        return keySet1.stream().map(key -> key.toLowerCase()).collect(Collectors.toSet()).equals(keySet2.stream().map(key -> key.toLowerCase()).collect(Collectors.toSet()));
    }

    private boolean containIgnoreCase(Set<String> keySet1, Set<String> keySet2) {
        return keySet1.stream().map(key -> key.toLowerCase()).collect(Collectors.toSet()).containsAll(keySet2.stream().map(key -> key.toLowerCase()).collect(Collectors.toSet()));
    }
}

