/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.about.dialog;

import com.kms.katalon.application.KatalonApplicationActivator;
import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.VersionInfo;
import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.composer.components.ComponentBundleActivator;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.FontUtil;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.core.model.KatalonEdition;
import com.kms.katalon.core.util.ApplicationEdition;
import com.kms.katalon.integration.analytics.constants.IntegrationAnalyticsMessages;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiException;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.license.models.LicenseType;
import com.kms.katalon.logging.LogUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.about.AboutBundleGroupData;
import org.eclipse.ui.internal.about.InstallationDialog;
import org.eclipse.ui.services.IServiceLocator;

public class KatalonAboutDialog
extends TrayDialog {
    private String productName;
    private Image logo;
    protected static final String VERSION_UPDATE = "KatalonVersionUpdate";
    private static final String KATALON_STUDIO = "Katalon Studio";
    private static final String KATALON_STUDIO_ENTERPRISE = "Katalon Studio Enterprise";
    private boolean isTrial = false;
    private boolean isKSE = false;
    private boolean isLatestVersion = true;
    private String latestVersion;
    private String expirationDate;
    private Button btnInstalltionDetails;
    private Button btnOk;
    private Label lblNotice;
    private Label notice;
    private Label expiration;
    private KatalonEdition edition;
    private static LicenseType licenseType;

    public KatalonAboutDialog(Shell parentShell) {
        super(parentShell);
        licenseType = ActivationInfoCollector.getLicenseType();
        this.edition = ApplicationEdition.get();
        this.expirationDate = ActivationInfoCollector.getExpirationDate();
        this.productName = this.getProductName();
        IBundleGroupProvider[] providers = Platform.getBundleGroupProviders();
        if (providers != null) {
            LinkedList<AboutBundleGroupData> groups = new LinkedList<AboutBundleGroupData>();
            int i = 0;
            while (i < providers.length) {
                IBundleGroup[] bundleGroups = providers[i].getBundleGroups();
                int j = 0;
                while (j < bundleGroups.length) {
                    groups.add(new AboutBundleGroupData(bundleGroups[j]));
                    ++j;
                }
                ++i;
            }
        }
    }

    private String getProductName() {
        switch (this.edition) {
            case ENTERPRISE: {
                this.logo = ImageManager.getImage((String)"about/KSE_logo_200px.png");
                this.isTrial = licenseType == LicenseType.TRIAL;
                this.isKSE = true;
                return KATALON_STUDIO_ENTERPRISE;
            }
            case FREE: {
                this.logo = ImageManager.getImage((String)"about/KS_logo_200px.png");
                return KATALON_STUDIO;
            }
        }
        return "";
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected void buttonPressed(int buttonId) {
    }

    public boolean close() {
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(NLS.bind((String)WorkbenchMessages.AboutDialog_shellTitle, (Object)this.productName));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.ui.about_dialog_context");
    }

    private String getExpirationDate() {
        try {
            if (this.productName.equals(KATALON_STUDIO_ENTERPRISE)) {
                if (ActivationInfoCollector.isLicenseOffline()) {
                    return ActivationInfoCollector.getExpirationDate();
                }
                TestOpsService testOpsService = TestOpsService.getInstance();
                Date expDate = null;
                if (!this.isTrial) {
                    Long orgId = ApplicationInfo.getOrganization().getId();
                    expDate = testOpsService.getExpirationOnline(orgId);
                } else if (this.isTrial) {
                    expDate = testOpsService.getUser().getTrialExpirationDate();
                }
                SimpleDateFormat formatter = new SimpleDateFormat("MMMMM dd, yyyy HH:mm");
                return formatter.format(expDate);
            }
        }
        catch (AnalyticsApiException e) {
            try {
                String message = KatalonApplicationActivator.getFeatureActivator().getTestOpsMessage(e.getMessage());
                LogUtil.logError((String)MessageFormat.format(IntegrationAnalyticsMessages.MSG_ERROR_WITH_REASON, message));
            }
            catch (Exception exception) {
                LogUtil.logError((Throwable)e);
            }
        }
        return StringConstants.About_MSG_CANNOT_GET_EXPIRATION_DATE;
    }

    private void updateExpirationDate() {
        Thread getExpiration = new Thread(() -> {
            this.expirationDate = this.getExpirationDate();
            UISynchronizeService.asyncExec(() -> {
                if (this.expirationDate.equals(StringConstants.About_MSG_CANNOT_GET_EXPIRATION_DATE)) {
                    this.expiration.setForeground(ColorUtil.getTextErrorColor());
                    ControlUtils.setFontStyle((Control)this.expiration, (int)2, (int)10);
                } else {
                    this.expiration.setForeground(ColorUtil.getDefaultTextColor());
                    ControlUtils.setFontStyle((Control)this.expiration, (int)0, (int)10);
                }
                this.expiration.setText(this.expirationDate);
            });
        });
        getExpiration.start();
    }

    private void updateVersionInfo() {
        Thread checkLastestVersion = new Thread(() -> {
            VersionInfo lastestVersion = VersionUtil.getLatestVersion();
            if (VersionUtil.isNewer((String)lastestVersion.getVersion(), (String)VersionUtil.getCurrentVersion().getVersion())) {
                this.isLatestVersion = false;
                this.latestVersion = lastestVersion.getVersion();
            } else {
                this.isLatestVersion = true;
                this.latestVersion = MessageConstants.HAND_MSG_UP_TO_DATE;
            }
            UISynchronizeService.asyncExec(() -> {
                if (this.notice == null || this.notice.isDisposed()) {
                    return;
                }
                this.notice.setForeground(ColorUtil.getDefaultTextColor());
                this.notice.setText(this.latestVersion);
                ControlUtils.setFontStyle((Control)this.notice, (int)2, (int)10);
                if (!this.isLatestVersion) {
                    this.lblNotice.setText(MessageConstants.NEW_VERSION_AVAIABLE);
                    ControlUtils.setFontStyle((Control)this.notice, (int)0, (int)10);
                }
            });
        });
        checkLastestVersion.start();
    }

    protected Control createDialogArea(Composite parent) {
        ComponentUtil.appendGridLayout((Composite)parent, (int)2, (boolean)false);
        ComponentUtil.setMargin((Composite)parent, (int)50, (int)50, (int)0);
        parent.setBackgroundImage(this.getBackground());
        parent.setBackgroundMode(1);
        ComponentBuilder.label((Composite)parent, (int)0x40000000).image(this.logo).margin(10).middle().build();
        Composite contentComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)1, (int)0x40000000).middle().build();
        Composite titleComposite = (Composite)ComponentBuilder.gridContainer((Composite)contentComposite, (int)2, (int)0x40000000).colSpan(2).build();
        ComponentBuilder.label((Composite)titleComposite).text(this.productName).font(FontUtil.build((int)17, (int)1)).build();
        Label lblTrial = (Label)ComponentBuilder.label((Composite)titleComposite, (int)1024).font(FontUtil.build((int)10, (int)2)).build();
        if (this.isTrial) {
            lblTrial.setText(StringConstants.ABOUT_LBL_TRIAL);
        }
        Composite infoComposite = (Composite)ComponentBuilder.gridContainer((Composite)contentComposite, (int)2, (int)0x40000000).gridHorizontalSpacing(50).marginTop(10).build();
        Font labelFont = FontUtil.build((int)10, (int)1);
        Font infoFont = FontUtil.build((int)10);
        ComponentBuilder.label((Composite)infoComposite).text(StringConstants.ABOUT_LBL_VERSION).font(labelFont).build();
        ComponentBuilder.label((Composite)infoComposite).text(VersionUtil.getCurrentVersion().getVersion()).font(infoFont).build();
        ComponentBuilder.label((Composite)infoComposite).text(StringConstants.ABOUT_LBL_BUILD).font(labelFont).build();
        ComponentBuilder.label((Composite)infoComposite).text(Integer.toString(VersionUtil.getCurrentVersion().getBuildNumber())).font(infoFont).build();
        if (this.isKSE) {
            ComponentBuilder.label((Composite)infoComposite).text(StringConstants.ABOUT_LBL_EXPIRATION_DATE).font(labelFont).build();
            this.expiration = (Label)ComponentBuilder.label((Composite)infoComposite).text(StringConstants.About_MSG_CHECKING_EXPIRATION_DATE).color(ColorUtil.getTextRunningColor()).build();
            this.updateExpirationDate();
        }
        this.lblNotice = (Label)ComponentBuilder.label((Composite)infoComposite).font(labelFont).build();
        this.notice = (Label)ComponentBuilder.label((Composite)infoComposite).text(StringConstants.ABOUT_MSG_CHECKING_VERSION).color(ColorUtil.getTextRunningColor()).build();
        this.updateVersionInfo();
        ComponentBuilder.label((Composite)infoComposite).text(StringConstants.ABOUT_LBL_COPYRIGHT).font(labelFont).build();
        ComponentBuilder.link((Composite)infoComposite).linkTo(DocumentationMessageConstants.KATALON_HOME_PAGE).font(infoFont).build();
        Composite buttonBarComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2, (int)0x40000000).backgroundMode(2).colSpan(2).right().marginTop(50).marginBottom(0).build();
        this.btnInstalltionDetails = (Button)ComponentBuilder.button((Composite)buttonBarComposite).text(StringConstants.ABOUT_BTN_INSTALLATION_DETAILS).font(labelFont).fill().minWidth(200).minHeight(40).build();
        this.btnOk = (Button)ComponentBuilder.button((Composite)buttonBarComposite).text(StringConstants.ABOUT_BTN_OK).font(labelFont).fill().minWidth(100).minHeight(40).build();
        this.addListener();
        parent.pack();
        ComponentUtil.stretchBackground((Control)parent);
        return parent;
    }

    private void addListener() {
        this.btnInstalltionDetails.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BusyIndicator.showWhile((Display)KatalonAboutDialog.this.getShell().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        InstallationDialog dialog = new InstallationDialog(KatalonAboutDialog.this.getShell(), (IServiceLocator)workbenchWindow);
                        dialog.setModalParent((Dialog)KatalonAboutDialog.this);
                        dialog.open();
                    }
                });
            }
        });
        this.btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BusyIndicator.showWhile((Display)KatalonAboutDialog.this.getShell().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        KatalonAboutDialog.this.close();
                    }
                });
            }
        });
    }

    private Image getBackground() {
        if (ComponentBundleActivator.isDarkTheme((Display)this.getShell().getDisplay())) {
            return ImageManager.getImage((String)"about/background_dark.png");
        }
        return ImageManager.getImage((String)"about/background_light.png");
    }
}

