/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.dialog;

import com.kms.katalon.activation.dialog.ActivationCloseConfirmationDialog;
import com.kms.katalon.activation.dialog.AuthenRequestOptions;
import com.kms.katalon.activation.dialog.BaseModernDialog;
import com.kms.katalon.activation.dialog.ProxySettiingsDialog;
import com.kms.katalon.composer.components.controls.TextField;
import com.kms.katalon.composer.components.impl.overlay.OverlayShell;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.ImageUtil;
import com.kms.katalon.composer.helpers.SSOController;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.core.model.KatalonEdition;
import com.kms.katalon.core.util.ApplicationEdition;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.tracking.service.Trackings;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public abstract class BaseModernActivationDialog
extends BaseModernDialog {
    private final int SOCIAL_BUTTON_SIZE = 40;
    private final int SOCIAL_BUTTON_IMAGE_SIZE = 20;
    private final int LOGIN_GLOBE_ICON_SIZE = 24;
    private final int ERROR_ICON_SIZE = 40;
    private TextField usernameInput;
    private TextField passwordInput;
    private Canvas licenseServerLoginBtn;
    private Canvas offlineLicenseLoginInBtn;
    private Link statusLabel;
    private Link troubleshootLink;
    protected AuthenRequestOptions options;
    private boolean isBlocking = false;
    private Shell realParentShell;
    private Set<Control> inputAndButtons = new HashSet<Control>();
    private Label errorIcon;
    private Composite messageContentComposite;
    private SSOController.TokenGrabbedListener tokenGrabbedListener = token -> this.handleSSOTokenGrabbed(token);
    private SSOController.CodeGrabbedListener codeGrabbedListener = code -> this.handleSSOCodeGrabbed(code);
    private SSOController.TokenErrorListener tokenErrorListener = error -> this.handleSSOTokenError(error);
    private SSOController ssoController;

    public String getUsername() {
        return StringUtils.trim((String)this.usernameInput.getText());
    }

    public String getPassword() {
        return this.passwordInput.getText();
    }

    public BaseModernActivationDialog(Shell parentShell, AuthenRequestOptions options) {
        super(BaseModernActivationDialog.initBackdrop(parentShell));
        this.realParentShell = parentShell;
        this.options = options != null ? options : new AuthenRequestOptions();
        this.ssoController = SSOController.getInstance();
    }

    protected static Shell initBackdrop(Shell parentShell) {
        if (SystemUtils.IS_OS_LINUX) {
            return parentShell;
        }
        OverlayShell backdrop = new OverlayShell((Control)parentShell, 32768);
        backdrop.setBackground(ColorUtil.themeColor((String)"#fff", (String)"#000"));
        backdrop.setAlpha(150);
        backdrop.open();
        return backdrop.getShell();
    }

    @Override
    protected Point getInitialSize() {
        return this.options.isSimpleMode() ? new Point(470, -1) : super.getInitialSize();
    }

    @Override
    public String getDialogTitle() {
        return this.options.isSimpleMode() ? "Katalon account" : "";
    }

    @Override
    protected boolean useButtonBar() {
        return !this.options.isSimpleMode();
    }

    protected void renderSocialButton(SSOController.SocialButton button, Composite parent) {
        Image icon = null;
        try {
            icon = ImageUtil.loadImage((String)button.image);
        }
        catch (Exception exception) {
            LogUtil.logInfo((String)"> Failed to load icon");
        }
        ComponentBuilder.canvas((Composite)parent).text(button.name).color(parent.getForeground()).image(icon, 16384).imageSize(this.applyZoom(20), this.applyZoom(20)).secondaryButton().autoHeight(40).fontSize(12).bold().addTo(this.inputAndButtons).enable(!this.isBlocking).fillHorizontal().onClick(event -> {
            UISynchronizeService.asyncExec(() -> Trackings.trackLoginDialogAction((String)("sign-in-" + socialButton.idpId)));
            if (this.isOnline()) {
                this.handleSocialLoginClicked(socialButton.uri);
            } else {
                this.setErrorMessage("Please check your internet connection and try again.");
            }
        }).build();
    }

    @Override
    protected void createContent(Composite container) {
        Composite header = (Composite)ComponentBuilder.gridContainer((Composite)container).marginBottom(ComponentUtil.applyZoom((int)16)).fillHorizontal().build();
        ComponentBuilder.label((Composite)header).text(ApplicationEdition.get().equals((Object)KatalonEdition.ENTERPRISE) ? MessageConstants.ENTERPRISE_LOGIN_DIALOG_TITLE : MessageConstants.FREE_LOGIN_DIALOG_TITLE).fontSize(18).bold().textCenter().fillHorizontal().build();
        this.getShell().pack();
        String universalLoginUrl = this.ssoController.safeGenerateLoginUrl();
        Composite loginButtonsGroup = (Composite)ComponentBuilder.gridContainer((Composite)container).gridSpacing(this.applyZoom(6)).fillHorizontal().build();
        ComponentBuilder.canvas((Composite)loginButtonsGroup).text("Log in from Browser").image("login_globe.png", 16384).imageSize(this.applyZoom(24), this.applyZoom(24)).applyPrimaryButtonStyle3WithCustomDisableColors(ColorUtil.getTextWhiteColor(), ColorUtil.getColor((String)"#2236E5"), ColorUtil.getColor((String)"#2133D1")).autoHeight(40).fontSize(14).bold().addTo(this.inputAndButtons).fillHorizontal().onClick(event -> {
            UISynchronizeService.asyncExec(() -> Trackings.trackLoginDialogAction((String)"sign-in-browser"));
            if (this.isOnline()) {
                this.handleSocialLoginClicked(universalLoginUrl);
            } else {
                this.setErrorMessage("Please check your internet connection and try again.");
            }
        }).build();
        this.createMessageContent(loginButtonsGroup);
        this.ssoController.offCodeGrabbed(this.codeGrabbedListener);
        this.ssoController.onCodeGrabbed(this.codeGrabbedListener);
        this.ssoController.offTokenGrabbed(this.tokenGrabbedListener);
        this.ssoController.onTokenGrabbed(this.tokenGrabbedListener);
        this.ssoController.offTokenError(this.tokenErrorListener);
        this.ssoController.onTokenError(this.tokenErrorListener);
        if (KatalonEdition.FREE != ApplicationEdition.get()) {
            Composite orWrapper = (Composite)ComponentBuilder.gridContainer((Composite)loginButtonsGroup, (int)3).marginVertical(this.applyZoom(10)).gridSpacing(0).fillHorizontal().build();
            ComponentBuilder.separator((Composite)orWrapper).gridSpacing(0).build();
            ComponentBuilder.label((Composite)orWrapper).text("or log in with").gridSpacing(0).color(ColorUtil.getColor((String)"#919299")).fontSize(12).marginBottom(4).textCenter().fillHorizontal().build();
            ComponentBuilder.separator((Composite)orWrapper).gridSpacing(0).build();
            Composite buttonBar = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)2, (boolean)true).fillHorizontal().marginTop(this.options.isSimpleMode() ? this.applyZoom(10) : 0).marginBottom(this.applyZoom(10)).gridSpacing(this.applyZoom(10)).build();
            Color secondaryButtonDisabledColor = ColorUtil.themeColor((Color)ColorUtil.getColor((String)"#18181A"), (Color)ColorUtil.getTextWhiteColor());
            Color secondaryButtonDisabledBackgroundColor = ColorUtil.themeColor((Color)ColorUtil.getWhiteBackgroundColor(), (Color)ColorUtil.getColor((String)"#525658"));
            this.licenseServerLoginBtn = (Canvas)ComponentBuilder.canvas((Composite)buttonBar).text("License server").submitButton().applySecondaryButtonStyleWithCustomDisabledColor(secondaryButtonDisabledColor, secondaryButtonDisabledBackgroundColor).bold().fontSize(14).autoHeight(45).addTo(this.inputAndButtons).onClick(event -> {
                UISynchronizeService.asyncExec(() -> Trackings.trackLoginDialogAction((String)"sign-in"));
                this.handleSignInWithLicenseServer();
            }).fillHorizontal().build();
            this.offlineLicenseLoginInBtn = (Canvas)ComponentBuilder.canvas((Composite)buttonBar).text("Offline license").submitButton().applySecondaryButtonStyleWithCustomDisabledColor(secondaryButtonDisabledColor, secondaryButtonDisabledBackgroundColor).bold().fontSize(14).autoHeight(45).addTo(this.inputAndButtons).onClick(event -> {
                UISynchronizeService.asyncExec(() -> Trackings.trackLoginDialogAction((String)"offline-activation"));
                this.handleOfflineActivation();
            }).fillHorizontal().build();
        } else {
            ComponentBuilder.gridContainer((Composite)loginButtonsGroup).marginVertical(this.applyZoom(3)).gridSpacing(0).fillHorizontal().build();
        }
    }

    @Override
    protected void createButtons(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent).marginBottom(this.applyZoom(4)).fillHorizontal().center().color(ColorUtil.GRAY_BADGE_COLOR).build();
        Composite wrapper1 = (Composite)ComponentBuilder.gridContainer((Composite)container).fillHorizontal().left().build();
        ComponentBuilder.label((Composite)wrapper1, (int)4).linkButtonWithCustomDisabledColor(ColorUtil.themeColor((Color)ColorUtil.getTextBlackColor(), (Color)ColorUtil.getTextWhiteColor())).text("Proxy settings").fontSize(10).cursorPointer().onClick(event -> {
            UISynchronizeService.asyncExec(() -> Trackings.trackLoginDialogAction((String)"proxy-settings"));
            new ProxySettiingsDialog(this.getShell()).open();
        }).addTo(this.inputAndButtons).build();
    }

    private void createMessageContent(Composite parent) {
        this.messageContentComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2).width(this.getInitialSize().x).center().marginTop(this.applyZoom(4)).hide().build();
        this.errorIcon = (Label)ComponentBuilder.label((Composite)this.messageContentComposite).image("error_icon.png", 128).imageSize(this.applyZoom(40), this.applyZoom(40)).hide().build();
        Composite statusComposite = (Composite)ComponentBuilder.gridContainer((Composite)this.messageContentComposite).fillHorizontal().marginLeft(this.applyZoom(8)).build();
        this.statusLabel = (Link)ComponentBuilder.link((Composite)statusComposite, (int)64).color(ColorUtil.getTextErrorColor()).fontSize(10).fillHorizontal().center().hide().build();
        this.troubleshootLink = (Link)ComponentBuilder.link((Composite)statusComposite).linkButtonText("Troubleshoot").fontSize(10).onSelection(event -> {
            UISynchronizeService.asyncExec(() -> {
                String email = StringUtils.trim((String)this.usernameInput.getText());
                String errorMessage = this.statusLabel.getText();
                Trackings.trackLoginDialogAction((String)"troubleshoot");
                Trackings.trackTroubleshootFailedActivation((String)email, (String)errorMessage);
            });
            ComponentUtil.triggerLink((String)DocumentationMessageConstants.TROUBLESHOOT_ACTIVATION);
        }).fillHorizontal().hide().build();
    }

    public void setMessage(String message) {
        if (this.statusLabel.isDisposed()) {
            return;
        }
        ComponentUtil.show((Control)this.messageContentComposite);
        ComponentUtil.hide((Control)this.errorIcon);
        ComponentUtil.hide((Control)this.troubleshootLink);
        ComponentUtil.show((Control)this.statusLabel);
        ComponentUtil.showSuccess((Control)this.statusLabel, (String)ComponentUtil.autoWrapLinks((String)message), (boolean)true);
        this.messageContentComposite.getBounds().width = this.container.getBounds().width;
        this.getShell().pack();
    }

    public void setErrorMessage(String message) {
        if (this.statusLabel.isDisposed()) {
            return;
        }
        ComponentUtil.show((Control)this.messageContentComposite);
        ComponentUtil.show((Control)this.errorIcon);
        ComponentUtil.show((Control)this.statusLabel);
        ComponentUtil.show((Control)this.troubleshootLink);
        ComponentUtil.showError((Control)this.statusLabel, (String)ComponentUtil.autoWrapLinks((String)message), (boolean)true);
        this.getShell().pack();
    }

    public void clearMessage() {
        if (this.statusLabel.isDisposed()) {
            return;
        }
        ComponentUtil.hide((Control)this.messageContentComposite);
        ComponentUtil.hide((Control)this.statusLabel);
        ComponentUtil.hide((Control)this.errorIcon);
        ComponentUtil.setText((Widget)this.statusLabel, (String)"");
        this.getShell().pack();
    }

    public void blockUI() {
        this.blockUI(true);
    }

    public void blockUI(boolean blocked) {
        this.isBlocking = blocked;
        if (Objects.nonNull(this.licenseServerLoginBtn) && this.licenseServerLoginBtn.isDisposed() || Objects.nonNull(this.offlineLicenseLoginInBtn) && this.offlineLicenseLoginInBtn.isDisposed()) {
            return;
        }
        boolean enabled = !blocked;
        this.inputAndButtons.forEach(controlI -> {
            if (controlI instanceof Canvas) {
                ComponentUtil.setEnabledButton((Control)controlI, (boolean)enabled);
            } else {
                controlI.setEnabled(enabled);
            }
        });
    }

    private boolean isOnline() {
        try {
            URL url = new URL(this.ssoController.getSSOServer());
            URLConnection connection = url.openConnection();
            connection.connect();
            connection.getInputStream().close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    protected boolean canHandleShellCloseEvent() {
        return true;
    }

    @Override
    protected void handleShellCloseEvent() {
        if (this.options.isSimpleMode()) {
            super.handleShellCloseEvent();
            return;
        }
        ActivationCloseConfirmationDialog confirmDialog = new ActivationCloseConfirmationDialog(this.getShell());
        int result = confirmDialog.open();
        if (result == 0) {
            return;
        }
        super.handleShellCloseEvent();
    }

    @Override
    public boolean close() {
        this.ssoController.offCodeGrabbed(this.codeGrabbedListener);
        this.ssoController.offTokenGrabbed(this.tokenGrabbedListener);
        this.ssoController.offTokenError(this.tokenErrorListener);
        if (!SystemUtils.IS_OS_LINUX) {
            this.getParentShell().close();
            this.realParentShell.forceActive();
        }
        return super.close();
    }

    protected abstract void handleSignIn();

    protected abstract void handleOfflineActivation();

    protected abstract void handleSocialLoginClicked(String var1);

    protected abstract void handleSSOCodeGrabbed(String var1);

    protected abstract void handleSSOTokenGrabbed(String var1);

    protected abstract void handleSSOTokenError(Exception var1);

    protected abstract void handleSignInWithLicenseServer();
}

