/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.dialog;

import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.impl.helpers.DialogBuilder;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.project.constants.ComposerProjectMessageConstants;
import com.kms.katalon.composer.project.handlers.GitHandler;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.integration.analytics.entity.GitRepositoryEntity;
import org.apache.commons.lang.StringUtils;
import org.eclipse.egit.core.credentials.UserPasswordCredentials;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GitLoginDialog
extends AbstractDialog {
    private Text username;
    private Text personalAccessToken;
    private UserPasswordCredentials credentials;
    private char defaultEchoChar = (char)8226;
    private Button btnSaveAuthentication;
    private boolean saveAuthentication = false;
    private GitRepositoryEntity gitRepository;
    private boolean displayUrl;

    public GitLoginDialog(Shell parentShell, GitRepositoryEntity gitRepository) {
        this(parentShell, gitRepository, false);
    }

    public GitLoginDialog(Shell parentShell, GitRepositoryEntity gitRepository, boolean displayUrl) {
        super(parentShell);
        this.gitRepository = gitRepository;
        this.displayUrl = displayUrl;
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout glContainer = new GridLayout();
        glContainer.verticalSpacing = 5;
        container.setLayout((Layout)glContainer);
        Composite msgComposite = new Composite(container, 0);
        msgComposite.setLayout((Layout)new GridLayout(1, false));
        msgComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Composite contentComposite = new Composite(container, 0);
        GridLayout glContent = new GridLayout(2, false);
        glContent.verticalSpacing = 10;
        contentComposite.setLayout((Layout)glContent);
        GridData gdText = new GridData(4, 0x1000000, true, false);
        gdText.widthHint = 300;
        if (this.displayUrl && !StringUtils.isEmpty((String)this.gitRepository.getRepository())) {
            Label msgLabel = new Label(msgComposite, 0);
            msgLabel.setText(ComposerProjectMessageConstants.HAND_ERROR_MSG_GIT_PRIVATE);
            Label repoUrlLabel = new Label(contentComposite, 0);
            repoUrlLabel.setText(ComposerProjectMessageConstants.VIEW_LBL_GIT_REPO_URL);
            Text repoUrl = new Text(contentComposite, 2056);
            repoUrl.setLayoutData((Object)gdText);
            repoUrl.setText(this.gitRepository.getRepository());
        }
        Label userLabel = new Label(contentComposite, 0);
        userLabel.setText(ComposerProjectMessageConstants.VIEW_LBL_USERNAME);
        this.username = new Text(contentComposite, 2048);
        this.username.setLayoutData((Object)gdText);
        Label passwordLabel = new Label(contentComposite, 0);
        passwordLabel.setText(ComposerProjectMessageConstants.VIEW_LBL_PERSONAL_ACCESS_TOKEN);
        this.personalAccessToken = new Text(contentComposite, 2048);
        this.personalAccessToken.setLayoutData((Object)gdText);
        this.personalAccessToken.setEchoChar(this.defaultEchoChar);
        new Label(contentComposite, 0);
        Composite permissionComposite = new Composite(contentComposite, 0);
        permissionComposite.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(permissionComposite, 0);
        label.setText(ComposerProjectMessageConstants.PERSONAL_ACCESS_TOKEN_RECOMMENDATION);
        ControlUtils.setFontStyle((Control)label, (int)2, (int)-1);
        new Label(contentComposite, 0);
        this.btnSaveAuthentication = new Button(contentComposite, 32);
        GridData gdWebServiceProjectType = new GridData(4, 4, true, false, 1, 1);
        this.btnSaveAuthentication.setLayoutData((Object)gdWebServiceProjectType);
        this.btnSaveAuthentication.setSelection(this.saveAuthentication);
        this.btnSaveAuthentication.setText(ComposerProjectMessageConstants.VIEW_LBL_SAVE_AUTHENTICATION);
        return container;
    }

    public String getDialogTitle() {
        return MessageConstants.GIT_LOGIN_DIALOG;
    }

    protected void setInput() {
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, MessageConstants.BTN_LOGIN, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public UserPasswordCredentials getCredentials() {
        return this.credentials;
    }

    public boolean isSaveAuthentication() {
        return this.saveAuthentication;
    }

    protected void okPressed() {
        this.credentials = new UserPasswordCredentials(StringUtils.defaultIfBlank((String)this.username.getText(), (String)" "), this.personalAccessToken.getText());
        GitHandler.storeGitInfo((String)this.credentials.getUser(), (String)this.credentials.getPassword(), (boolean)this.isSaveAuthentication());
        if (this.gitRepository != null && StringUtils.isNotEmpty((String)this.gitRepository.getRepository())) {
            GitHandler.setGitPermission((UserPasswordCredentials)this.credentials, (String)this.gitRepository.getRepository());
        } else {
            new DialogBuilder().error().message(MessageConstants.MSG_EMPTY_GIT_REPO).title(GlobalMessageConstants.ERROR_TITLE).button(buttonBuilder -> buttonBuilder.text(GlobalMessageConstants.OK).onClick(event -> ((Button)event.widget).getShell().close()).right().autoWidth(80)).build().open();
        }
        super.okPressed();
    }

    protected void registerControlModifyListeners() {
        this.btnSaveAuthentication.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitLoginDialog.this.saveAuthentication = GitLoginDialog.this.btnSaveAuthentication.getSelection();
            }
        });
    }
}

