/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.dialog;

import com.kms.katalon.activation.dialog.AuthenRequestOptions;
import com.kms.katalon.activation.dialog.BaseModernActivationDialog;
import com.kms.katalon.activation.dialog.LicenseServerDialog;
import com.kms.katalon.activation.dialog.OfflineActivationDialog;
import com.kms.katalon.activation.dialog.OrgSelectionDialog;
import com.kms.katalon.activation.dialog.WarningLicenseDialog;
import com.kms.katalon.activation.dialog.WarningUpgradeEditionDialog;
import com.kms.katalon.application.KatalonApplicationActivator;
import com.kms.katalon.application.constants.ApplicationMessageConstants;
import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.LoginMethod;
import com.kms.katalon.application.utils.MachineUtil;
import com.kms.katalon.application.utils.Organization;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.helpers.SSOController;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.core.util.Strings;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.integration.analytics.AnalyticsOrganization;
import com.kms.katalon.feature.TestOpsMessageError;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiException;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.license.models.AuthenticationInfo;
import com.kms.katalon.license.models.License;
import com.kms.katalon.license.models.LicenseResource;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.tracking.service.Trackings;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ModernActivationDialog
extends BaseModernActivationDialog {
    public static final Pattern ERROR_MESSAGE_REGEX = Pattern.compile(".*JsonSyntaxException.*");
    private int retryCount = 0;
    public static final int ACTIVATION_RETRY_LIMIT = 3;
    public static final int ACTIVATION_WAIT_TIME_BASE = 2;
    public static final int ACTIVATION_RETRY_STATUS_CODE_FROM = 500;
    public static final int ACTIVATION_RETRY_STATUS_CODE_TO = 599;
    private static final String CUSTOM_ERROR = "Katalon TestOps server is temporarily unavailable. Please try again later.";
    private final String machineId = MachineUtil.getMachineId();
    private LoginMethod loginMethod;
    private LicenseResource licenseResource;
    private License license;
    private List<AnalyticsOrganization> organizations = new ArrayList<AnalyticsOrganization>();
    private List<AnalyticsOrganization> KSEOrgs;
    private String adminServer = ApplicationInfo.getDefaultTestOpsAdminServer();
    private TestOpsService testOpsService = TestOpsService.getInstance();

    public List<AnalyticsOrganization> getKSEOrgs() {
        return this.KSEOrgs;
    }

    public ModernActivationDialog(Shell parentShell) {
        this(parentShell, null);
    }

    public ModernActivationDialog(Shell parentShell, AuthenRequestOptions options) {
        super(parentShell, options);
        this.init();
    }

    protected void init() {
        Executors.newFixedThreadPool(1).submit(() -> {
            try {
                this.testOpsService.revokeAndClearAllTokens();
            }
            catch (AnalyticsApiException error) {
                LogUtil.logError((Throwable)error);
            }
            ApplicationInfo.clearActivationCode();
            ApplicationInfo.clearAuthenticationInfo();
            ApplicationInfo.clearAuthenticationType();
            ApplicationInfo.clearAuthenticationSubDomain();
            ApplicationInfo.clearOrg();
            ApplicationInfo.clearLoginMethod();
            this.resetServerURLs();
        });
    }

    @Override
    protected void handleOfflineActivation() {
        this.getShell().setVisible(false);
        OfflineActivationDialog offlineActivationDialog = new OfflineActivationDialog(this.getParentShell());
        if (offlineActivationDialog.open() == 0) {
            this.okPressed();
        } else {
            this.getShell().setVisible(true);
            this.getShell().forceActive();
        }
    }

    @Override
    protected void handleSignInWithLicenseServer() {
        this.getShell().setVisible(false);
        LicenseServerDialog licenseServerDialog = new LicenseServerDialog(this.getParentShell());
        if (licenseServerDialog.open() == 0) {
            this.okPressed();
        } else {
            this.getShell().setVisible(true);
            this.getShell().forceActive();
        }
    }

    @Override
    protected void handleSocialLoginClicked(String loginUrl) {
        this.clearMessage();
        ComponentUtil.triggerLink((String)loginUrl);
    }

    private void resetServerURLs() {
        ApplicationInfo.setAdminServer((String)this.adminServer);
        this.testOpsService.setAdminServer(this.adminServer);
        String testOpsServer = ApplicationInfo.getDefaultTestOpsServer();
        ApplicationInfo.setTestOpsServer((String)testOpsServer);
        this.testOpsService.setTestOpsServer(testOpsServer);
        String katOneServer = (String)Strings.firstNonBlank((CharSequence[])new String[]{System.getProperty("katOneServerUrl"), "https://api.katalon.com"});
        this.testOpsService.setKatOneServer(katOneServer);
    }

    @Override
    protected void handleSSOTokenError(Exception error) {
        UISynchronizeService.asyncExec(() -> Trackings.trackSSOEvent((String)"exchange-token-error", (String)error.getMessage()));
        UISynchronizeService.syncExec(() -> {
            if (ERROR_MESSAGE_REGEX.matcher(error.getMessage()).matches() || error.getMessage().contains("503")) {
                this.setErrorMessage(CUSTOM_ERROR);
            } else {
                this.setErrorMessage(error.getMessage());
            }
            this.blockUI(false);
        });
    }

    @Override
    protected void handleSSOCodeGrabbed(String code) {
        UISynchronizeService.asyncExec(() -> Trackings.trackSSOEvent((String)"code-grabbed"));
        UISynchronizeService.syncExec(() -> {
            this.setMessage("Processing your login...");
            this.blockUI();
        });
    }

    @Override
    protected void handleSSOTokenGrabbed(String token) {
        UISynchronizeService.asyncExec(() -> Trackings.trackSSOEvent((String)"token-grabbed"));
        this.loginMethod = LoginMethod.SSO;
        this.handleSignIn();
    }

    public void handleFailedSignIn() {
        try {
            SSOController.getInstance().rollbackFailedSSOLogin();
        }
        catch (AnalyticsApiException error) {
            LogUtil.logError((Throwable)error);
        }
    }

    @Override
    protected void handleSignIn() {
        this.testOpsService.setAdminServer(this.adminServer);
        this.retryCount = 0;
        Executors.newFixedThreadPool(1).submit(() -> {
            UISynchronizeService.syncExec(() -> {
                this.blockUI();
                this.setMessage(MessageConstants.ActivationDialogV2_MSG_LOGIN);
            });
            boolean isServerError = false;
            StringBuilder errorMessage = new StringBuilder();
            StringBuilder testConnectionStatusCode = new StringBuilder();
            do {
                try {
                    String statusCode;
                    int statusCodeInt;
                    if (this.retryCount > 0) {
                        long waitTime = (long)Math.pow(2.0, this.retryCount - 1);
                        TimeUnit.SECONDS.sleep(waitTime);
                        isServerError = false;
                        errorMessage.setLength(0);
                        testConnectionStatusCode.setLength(0);
                    }
                    boolean testConnection = KatalonApplicationActivator.getFeatureActivator().testConnection(this.adminServer, testConnectionStatusCode);
                    if (StringUtils.isNotEmpty((CharSequence)testConnectionStatusCode) && 500 <= (statusCodeInt = Integer.parseInt(statusCode = testConnectionStatusCode.toString())) && statusCodeInt <= 599) {
                        isServerError = true;
                        errorMessage.append(MessageConstants.ActivationDialogV2_MSG_TESTOP_UNAVAILABLE);
                        ActivationInfoCollector.sendTrackingForActivate(null, (String)this.machineId, (boolean)false, (StringBuilder)errorMessage, (boolean)false, (Integer)this.retryCount, (LoginMethod)this.loginMethod);
                        int retryingWaitTimeInfo = (int)Math.pow(2.0, this.retryCount);
                        ++this.retryCount;
                        if (this.retryCount <= 3) {
                            UISynchronizeService.syncExec(() -> {
                                this.blockUI();
                                this.setErrorMessage(MessageFormat.format(MessageConstants.ActivationDialogV2_MSG_RETRYING, retryingWaitTimeInfo));
                            });
                        }
                    }
                    if (!testConnection && !isServerError) {
                        UISynchronizeService.syncExec(() -> {
                            this.setErrorMessage(MessageConstants.ActivationDialogV2_MSG_CANNOT_CONNECT_TESTOPS);
                            this.blockUI(false);
                        });
                        return;
                    }
                }
                catch (Exception ex) {
                    LogUtil.logError((Throwable)ex);
                }
            } while (isServerError && this.retryCount <= 3);
            if (isServerError || this.retryCount > 3) {
                UISynchronizeService.syncExec(() -> {
                    this.blockUI(false);
                    this.setErrorMessage(MessageConstants.ActivationDialogV2_MSG_SERVER_ERROR);
                });
            } else {
                TestOpsMessageError testOpsErrorMessage = new TestOpsMessageError();
                LogUtil.logInfo((String)MessageConstants.ActivationDialogV2_LOG_ACTIVATING);
                this.licenseResource = ActivationInfoCollector.activate((AuthenticationInfo)ApplicationInfo.getAuthenticationInfo(), null, (String)this.machineId, (TestOpsMessageError)testOpsErrorMessage);
                try {
                    if (this.licenseResource != null) {
                        this.license = this.licenseResource.getLicense();
                        if (this.license != null) {
                            if (ApplicationInfo.isPlatformStudio()) {
                                ApplicationInfo.setTestOpsServer((String)this.license.getTestopsUrl());
                            }
                            if (this.license.getOrganizationId() != null) {
                                LogUtil.logInfo((String)MessageConstants.ActivationDialogV2_LOG_RETRIEVE_ORG);
                                String org = ActivationInfoCollector.getOrganization((long)this.license.getOrganizationId());
                                LogUtil.logInfo((String)MessageConstants.ActivationDialogV2_LOG_SAVING_ORG);
                                this.save(org);
                            } else {
                                LogUtil.logInfo((String)MessageConstants.ActivationDialogV2_LOG_FETCH_ORG);
                                this.checkOrganizationAndSave();
                            }
                            ApplicationInfo.setLoginMethod((LoginMethod)this.loginMethod);
                            ActivationInfoCollector.sendTrackingToKatalonWebsiteForActivatedSuccess((String)this.machineId);
                            String noticeMessage = this.licenseResource.getNoticeMessage();
                            String noticeCode = this.licenseResource.getNoticeCode();
                            if (noticeMessage != null) {
                                if (noticeCode == null || noticeCode.equals("WARNING_MESSAGE")) {
                                    UISynchronizeService.syncExec(() -> {
                                        int n = new WarningLicenseDialog(Display.getCurrent().getActiveShell(), noticeMessage).open();
                                    });
                                } else if (noticeCode.equals("WARNING_UPGRADE_EDITION")) {
                                    UISynchronizeService.syncExec(() -> {
                                        int n = new WarningUpgradeEditionDialog(Display.getCurrent().getActiveShell(), noticeMessage).open();
                                    });
                                }
                            }
                        } else {
                            LogUtil.logError((String)MessageFormat.format(MessageConstants.ActivationDialogV2_LOG_ERROR_GET_LICENSE, testOpsErrorMessage.getMessage()));
                            UISynchronizeService.syncExec(() -> {
                                this.blockUI(false);
                                this.setErrorMessage(testOpsErrorMessage.getMessage());
                            });
                            ActivationInfoCollector.sendTrackingForActivate(null, (String)this.machineId, (boolean)false, (StringBuilder)new StringBuilder(testOpsErrorMessage.getMessage()), (boolean)false, (Integer)this.retryCount, (LoginMethod)this.loginMethod);
                        }
                    } else {
                        LogUtil.logError((String)MessageFormat.format(MessageConstants.ActivationDialogV2_LOG_ERROR_CREDENTIALS, testOpsErrorMessage.getMessage()));
                        UISynchronizeService.syncExec(() -> {
                            this.blockUI(false);
                            this.setErrorMessage(testOpsErrorMessage.getMessage());
                        });
                        ActivationInfoCollector.sendTrackingForActivate(null, (String)this.machineId, (boolean)false, (StringBuilder)new StringBuilder(testOpsErrorMessage.getMessage()), (boolean)false, (Integer)this.retryCount, (LoginMethod)this.loginMethod);
                    }
                }
                catch (Exception error) {
                    LogUtil.logError((Throwable)error);
                    UISynchronizeService.syncExec(() -> {
                        this.setErrorMessage(MessageConstants.ActivationDialogV2_LBL_ERROR_ORGANIZATION);
                        this.blockUI(false);
                    });
                    ActivationInfoCollector.sendTrackingForActivate(null, (String)this.machineId, (boolean)false, (StringBuilder)new StringBuilder().append(error), (boolean)false, (Integer)this.retryCount, (LoginMethod)this.loginMethod);
                    this.handleFailedSignIn();
                }
            }
        });
    }

    private void save(int index) {
        License finalLicense = this.options.shouldKeepLicense() ? null : this.license;
        AnalyticsOrganization organization = this.organizations.get(index);
        Executors.newFixedThreadPool(1).submit(() -> {
            UISynchronizeService.syncExec(() -> this.setMessage(MessageConstants.ActivationDialogV2_MSG_GETTING_FEATURE));
            try {
                ApplicationInfo.setAdminServer((String)this.adminServer);
                ActivationInfoCollector.markActivated((AuthenticationInfo)this.testOpsService.getCombinedToken(), (String)JsonUtil.toJson((Object)organization), (License)finalLicense);
                UISynchronizeService.syncExec(() -> this.okPressed());
                String message = this.licenseResource.getMessage();
                StringBuilder errorMessage = new StringBuilder();
                if (!StringUtils.isEmpty((CharSequence)message)) {
                    errorMessage.append(message);
                    UISynchronizeService.syncExec(() -> {
                        WarningLicenseDialog warningLicenseDialog = new WarningLicenseDialog(Display.getCurrent().getActiveShell(), message);
                        warningLicenseDialog.open();
                    });
                }
                ActivationInfoCollector.sendTrackingForActivate((String)ApplicationContext.getInstance().getUserId(), (String)this.machineId, (boolean)true, (StringBuilder)errorMessage, (boolean)false, (Integer)this.retryCount, (LoginMethod)this.loginMethod);
            }
            catch (Exception e) {
                UISynchronizeService.syncExec(() -> this.blockUI(false));
                LogUtil.logError((Throwable)e, (String)ApplicationMessageConstants.ACTIVATION_COLLECT_FAIL_MESSAGE);
                ActivationInfoCollector.sendTrackingForActivate((String)ApplicationContext.getInstance().getUserId(), (String)this.machineId, (boolean)false, (StringBuilder)new StringBuilder().append(e), (boolean)false, (Integer)this.retryCount, (LoginMethod)this.loginMethod);
                this.handleFailedSignIn();
            }
        });
    }

    private void save(String org) {
        String machineId = MachineUtil.getMachineId();
        License finalLicense = this.options.shouldKeepLicense() ? null : this.license;
        Executors.newFixedThreadPool(1).submit(() -> {
            UISynchronizeService.syncExec(() -> this.setMessage(MessageConstants.ActivationDialogV2_MSG_GETTING_FEATURE));
            try {
                ApplicationInfo.setAdminServer((String)this.adminServer);
                ActivationInfoCollector.markActivated((AuthenticationInfo)this.testOpsService.getCombinedToken(), (String)org, (License)finalLicense);
                UISynchronizeService.syncExec(() -> this.okPressed());
                ActivationInfoCollector.sendTrackingForActivate((String)ApplicationContext.getInstance().getUserId(), (String)machineId, (boolean)true, (StringBuilder)new StringBuilder(), (boolean)false, (Integer)this.retryCount, (LoginMethod)this.loginMethod);
            }
            catch (Exception e) {
                UISynchronizeService.syncExec(() -> this.blockUI(false));
                LogUtil.logError((Throwable)e, (String)ApplicationMessageConstants.ACTIVATION_COLLECT_FAIL_MESSAGE);
                ActivationInfoCollector.sendTrackingForActivate((String)ApplicationContext.getInstance().getUserId(), (String)machineId, (boolean)false, (StringBuilder)new StringBuilder().append(e), (boolean)false, (Integer)this.retryCount, (LoginMethod)this.loginMethod);
                this.handleFailedSignIn();
            }
        });
    }

    private static List<String> getOrganizationNames(List<AnalyticsOrganization> organizations) {
        List<String> names = organizations.stream().map(organization -> organization.getName()).collect(Collectors.toList());
        return names;
    }

    private void checkOrganizationAndSave() {
        Executors.newFixedThreadPool(1).submit(() -> {
            UISynchronizeService.syncExec(() -> this.setMessage(MessageConstants.ActivationDialogV2_MSG_GETTING_ORGANIZATION));
            try {
                LogUtil.logInfo((String)"Fetching organizations using token...");
                this.organizations = this.testOpsService.getOrganizations();
                LogUtil.logInfo((String)(String.valueOf(this.organizations.size()) + " organization(s) fetched"));
                if (!StringUtils.equalsIgnoreCase((CharSequence)ApplicationInfo.getAuthenticationType(), (CharSequence)"saml")) {
                    this.organizations = this.organizations.stream().filter(organization -> !organization.isSamlSSO()).collect(Collectors.toList());
                }
                if (this.options.shouldKeepOrganization()) {
                    Organization currentOrganization = ApplicationInfo.getOrganization();
                    AnalyticsOrganization existingOrg = this.findExistingOrganization(this.organizations, currentOrganization);
                    if (existingOrg != null) {
                        this.save(this.organizations.indexOf(existingOrg));
                    } else {
                        UISynchronizeService.syncExec(() -> {
                            this.setErrorMessage(String.format(MessageConstants.MSG_ERROR_NOT_BELONG_ORG, currentOrganization.getId()));
                            this.blockUI(false);
                        });
                        this.handleFailedSignIn();
                    }
                    return;
                }
                switch (this.organizations.size()) {
                    case 0: {
                        AnalyticsOrganization organizationDefault = this.testOpsService.createDefaultOrganization();
                        this.organizations.add(organizationDefault);
                        this.save(0);
                        break;
                    }
                    case 1: {
                        this.save(0);
                        break;
                    }
                    default: {
                        UISynchronizeService.syncExec(() -> {
                            this.clearMessage();
                            this.getShell().setVisible(false);
                            OrgSelectionDialog orgSelectionDialog = new OrgSelectionDialog(this.getParentShell(), ModernActivationDialog.getOrganizationNames(this.organizations), this.getDefaultOrganizationIndex());
                            if (orgSelectionDialog.open() == 0) {
                                this.save(orgSelectionDialog.getSelectedOrgIndex());
                            } else {
                                this.getShell().setVisible(true);
                                this.getShell().forceActive();
                                this.blockUI(false);
                            }
                        });
                        break;
                    }
                }
            }
            catch (Exception e) {
                ActivationInfoCollector.sendTrackingForActivate((String)this.getUsername(), (String)this.machineId, (boolean)false, (StringBuilder)new StringBuilder().append(e), (boolean)false, (Integer)this.retryCount, (LoginMethod)this.loginMethod);
                LogUtil.logError((Throwable)e);
                UISynchronizeService.syncExec(() -> {
                    this.clearMessage();
                    MessageDialog dialog = new MessageDialog(Display.getCurrent().getActiveShell(), MessageConstants.ActivationDialogV2_LBL_ERROR, null, MessageConstants.ActivationDialogV2_LBL_ERROR_ORGANIZATION, 1, new String[]{"OK"}, 0);
                    if (dialog.open() == 0) {
                        this.blockUI(false);
                    }
                });
                this.handleFailedSignIn();
            }
        });
    }

    private int getDefaultOrganizationIndex() {
        int i = 0;
        while (i < this.organizations.size()) {
            AnalyticsOrganization organization = this.organizations.get(i);
            if ("USER".equals(organization.getRole())) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private AnalyticsOrganization findExistingOrganization(List<AnalyticsOrganization> orgs, Organization currentOrganization) {
        if (currentOrganization == null) {
            return null;
        }
        return orgs.stream().filter(orgI -> orgI.getId().equals(currentOrganization.getId())).findFirst().orElse(null);
    }
}

