/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.dialog;

import com.katalon.platform.api.network.ApplicationProxyPreference;
import com.kms.katalon.activation.dialog.BaseModernDialog;
import com.kms.katalon.application.utils.ApplicationProxyUtil;
import com.kms.katalon.composer.components.controls.SimpleComboBox;
import com.kms.katalon.composer.components.controls.SimpleTextField;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.core.network.ProxyInformation;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ProxySettiingsDialog
extends BaseModernDialog {
    private static final int MAX_PORT_VALUE = 65535;
    private Composite optionsGroup;
    private SimpleComboBox serverTypeInput;
    private SimpleTextField addressInput;
    private SimpleTextField portInput;
    private Button authCheckBox;
    private SimpleTextField usernameInput;
    private SimpleTextField passwordInput;

    public ProxySettiingsDialog(Shell parentShell) {
        super(parentShell);
    }

    @Override
    protected Point getInitialSize() {
        return new Point(500, -1);
    }

    @Override
    public String getDialogTitle() {
        return "Authentication Proxy Configurations";
    }

    @Override
    protected void createContent(Composite container) {
        Composite container2 = (Composite)ComponentBuilder.gridContainer((Composite)container).gridSpacing(this.applyZoom(10)).fillHorizontal().onSubmit(event -> this.okPressed()).build();
        this.optionsGroup = (Composite)ComponentBuilder.gridContainer((Composite)container2).gridSpacing(this.applyZoom(5)).fillHorizontal().onOptionChange((control, option) -> this.handleProxyOptionChange((ApplicationProxyPreference.ProxyOption)option)).build();
        ComponentBuilder.radio((Composite)this.optionsGroup).data((Object)ApplicationProxyPreference.ProxyOption.NO_PROXY).text("No proxy").fillHorizontal().build();
        ComponentBuilder.radio((Composite)this.optionsGroup).data((Object)ApplicationProxyPreference.ProxyOption.USE_SYSTEM).text("Use system proxy configuration").fillHorizontal().build();
        ComponentBuilder.radio((Composite)this.optionsGroup).data((Object)ApplicationProxyPreference.ProxyOption.MANUAL_CONFIG).text("Manual proxy configuration").fillHorizontal().build();
        Composite serverInfoContainer = (Composite)ComponentBuilder.gridContainer((Composite)container2).groupIndent().fillHorizontal().build();
        this.serverTypeInput = (SimpleComboBox)ComponentBuilder.simpleComboBox((Composite)serverInfoContainer, (int)0x800808).placeholder("Proxy server type").options(new String[]{"HTTP", "HTTPS", "SOCKS"}).select().fillHorizontal().build();
        Composite hostContainer = (Composite)ComponentBuilder.gridContainer((Composite)serverInfoContainer, (int)4, (boolean)true).fillHorizontal().build();
        this.addressInput = (SimpleTextField)ComponentBuilder.simpleTextField((Composite)hostContainer).placeholder("Address").colSpan(3).fillHorizontal().build();
        this.portInput = (SimpleTextField)ComponentBuilder.simpleTextField((Composite)hostContainer).placeholder("Port").fillHorizontal().build();
        this.portInput.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String text = ProxySettiingsDialog.this.portInput.getText();
                String newText = String.valueOf(text.substring(0, e.start)) + e.text + text.substring(e.end);
                if (StringUtils.isEmpty((CharSequence)newText)) {
                    e.doit = true;
                    return;
                }
                try {
                    int val = Integer.parseInt(newText);
                    e.doit = val >= 0 && val <= 65535;
                }
                catch (NumberFormatException numberFormatException) {
                    e.doit = false;
                }
            }
        });
        Composite authContainer = (Composite)ComponentBuilder.gridContainer((Composite)container2).groupIndent().marginBottom(this.applyZoom(10)).fillHorizontal().build();
        this.authCheckBox = (Button)ComponentBuilder.checkBox((Composite)authContainer).text("Proxy server requires authentication").onSelection(event -> {
            boolean checked = this.authCheckBox.getSelection();
            this.usernameInput.setEnabled(checked);
            this.passwordInput.setEnabled(checked);
        }).build();
        Composite credentialContainer = (Composite)ComponentBuilder.gridContainer((Composite)authContainer).groupIndent().fillHorizontal().build();
        this.usernameInput = (SimpleTextField)ComponentBuilder.simpleTextField((Composite)credentialContainer).placeholder("Username").fillHorizontal().build();
        this.passwordInput = (SimpleTextField)ComponentBuilder.simpleTextField((Composite)credentialContainer, (int)16384).placeholder("Password").fillHorizontal().build();
    }

    private void handleProxyOptionChange(ApplicationProxyPreference.ProxyOption proxyOption) {
        boolean isManual = proxyOption == ApplicationProxyPreference.ProxyOption.MANUAL_CONFIG;
        this.serverTypeInput.setEnabled(isManual);
        this.addressInput.setEnabled(isManual);
        this.portInput.setEnabled(isManual);
        this.authCheckBox.setEnabled(isManual);
        boolean useAuth = this.authCheckBox.getSelection();
        this.usernameInput.setEnabled(isManual && useAuth);
        this.passwordInput.setEnabled(isManual && useAuth);
    }

    @Override
    protected void setInput() {
        this.loadProxySettings();
    }

    private void loadProxySettings() {
        ProxyInformation proxyInfo = ApplicationProxyUtil.getAuthProxyInformation();
        ApplicationProxyPreference.ProxyOption proxyOption = ApplicationProxyPreference.ProxyOption.valueOf((String)proxyInfo.getProxyOption());
        ComponentUtil.setRadioOption((Composite)this.optionsGroup, (Object)proxyOption);
        ComponentUtil.select((Widget)this.serverTypeInput, (String)proxyInfo.getProxyServerType());
        this.addressInput.setText(proxyInfo.getProxyServerAddress());
        this.portInput.setText(String.valueOf(proxyInfo.getProxyServerPort()));
        if (StringUtils.isNotEmpty((CharSequence)proxyInfo.getUsername()) && StringUtils.isNotBlank((CharSequence)proxyInfo.getPassword())) {
            this.authCheckBox.setSelection(true);
        }
        this.usernameInput.setText(proxyInfo.getUsername());
        this.passwordInput.setText(proxyInfo.getPassword());
        this.handleProxyOptionChange(proxyOption);
    }

    @Override
    protected boolean useButtonBar() {
        return true;
    }

    @Override
    protected void createButtons(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2).marginBottom(ComponentUtil.applyZoom((int)5)).fillHorizontal().build();
        Composite leftPart = (Composite)ComponentBuilder.gridContainer((Composite)container).fillHorizontal().build();
        ComponentBuilder.label((Composite)leftPart, (int)4).linkButton().text("Learn more").fontSize(10).onClick(event -> ComponentUtil.triggerLink((String)DocumentationMessageConstants.AUTHENTICATION_PROXY)).build();
        Composite rightPart = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)2, (boolean)true).gridSpacing(this.applyZoom(10)).fillHorizontal().right().build();
        ComponentBuilder.canvas((Composite)rightPart).text("Cancel").secondaryButton().autoSizeLG(100).fontSize(12).fillHorizontal().onClick(event -> this.cancelPressed()).build();
        ComponentBuilder.canvas((Composite)rightPart).text("OK").primaryButton3().autoSizeLG(100).fontSize(12).fillHorizontal().onClick(event -> this.okPressed()).build();
    }

    protected void okPressed() {
        ProxyInformation proxyInfo = new ProxyInformation();
        proxyInfo.setProxyOption(((ApplicationProxyPreference.ProxyOption)this.optionsGroup.getData()).toString());
        proxyInfo.setProxyServerType(StringUtils.trim((String)this.serverTypeInput.getText()));
        proxyInfo.setProxyServerAddress(StringUtils.trim((String)this.addressInput.getText()));
        String portValue = StringUtils.trim((String)this.portInput.getText());
        proxyInfo.setProxyServerPort(StringUtils.isEmpty((CharSequence)portValue) ? String.valueOf(0) : portValue);
        boolean useAuth = this.authCheckBox.getSelection();
        proxyInfo.setUsername(useAuth ? StringUtils.trim((String)this.usernameInput.getText()) : "");
        proxyInfo.setPassword(useAuth ? StringUtils.trim((String)this.passwordInput.getText()) : "");
        proxyInfo.setExceptionList("");
        try {
            ApplicationProxyUtil.saveAuthProxyInformation((ProxyInformation)proxyInfo);
            super.okPressed();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)StringConstants.ERROR_TITLE, (String)StringConstants.PREF_MSG_UNABLE_TO_SAVE_PROXY_CONFIG);
        }
        super.okPressed();
    }
}

