/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.activation.dialog.IdleTimeoutDialog;
import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.handlers.DeactivateHandler;
import com.kms.katalon.composer.handlers.OrganizationHandler;
import com.kms.katalon.core.util.Debouncer;
import com.kms.katalon.core.util.TimeUtil;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.integration.analytics.entity.AnalyticsOrganizationSetting;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import java.util.Timer;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class IdleTimeoutHandler {
    @Inject
    IEventBroker eventBroker;
    private final long MILISECONDS_PER_MINUTE = 60000L;
    private final long CHECK_LAUNCHER_RUNNING_INTERVAL = 1000L;
    private final long TIMEOUT_POPUP_CLASSIFY_THRESHOLD = 60L;
    private IdleTimeoutDialog idleTimeoutDialog;
    private Debouncer<String> idleDebouncer;
    private Timer checkLauncherTimer;
    private Timer deactivateTimer;
    private Long maxContinuousIdleSessions;
    private Listener userInteractListener = new Listener(){

        public void handleEvent(org.eclipse.swt.widgets.Event event) {
            IdleTimeoutHandler.this.resetIdleTimer();
        }
    };
    private static IdleTimeoutHandler instance;

    public static IdleTimeoutHandler getInstance() {
        return instance;
    }

    @PostConstruct
    private void registerEventHandler() {
        instance = this;
        this.eventBroker.subscribe("ACTIVATION/CHECKED", new EventHandler(){

            public void handleEvent(Event event) {
                if (ActivationInfoCollector.isLicenseOffline()) {
                    return;
                }
                AnalyticsOrganizationSetting organizationSetting = IdleTimeoutHandler.this.fetchAnalyticsOrganizationSetting();
                if (organizationSetting == null || !organizationSetting.isKseIdleTimeoutEnabled()) {
                    return;
                }
                IdleTimeoutHandler.this.maxContinuousIdleSessions = organizationSetting.getMaxContinuousIdleSessions();
                Long idleTimeout = organizationSetting.getKseIdleTimeout() * 60000L;
                Long showWarningPopupTimeout = idleTimeout >= 3600000L ? Long.valueOf(idleTimeout - 900000L) : Long.valueOf(Math.round((double)idleTimeout.longValue() / 4.0 * 3.0));
                long closePopupTimeout = idleTimeout - showWarningPopupTimeout;
                IdleTimeoutHandler.this.idleDebouncer = new Debouncer(key -> {
                    IdleTimeoutHandler.this.showIdleTimeoutWarningDialog(closePopupTimeout);
                    IdleTimeoutHandler.this.runDeactivateTimer(closePopupTimeout);
                }, showWarningPopupTimeout.longValue());
                IdleTimeoutHandler.this.resetIdleTimer();
                IdleTimeoutHandler.this.registerInteractionListeners();
                IdleTimeoutHandler.this.checkLauncherTimer = TimeUtil.setInterval(timer -> {
                    if (LauncherManager.getInstance().isAnyLauncherRunning()) {
                        IdleTimeoutHandler.this.resetIdleTimer();
                    }
                }, (long)1000L);
            }
        });
        this.eventBroker.subscribe("ACTIVATION/DEACTIVATED", new EventHandler(){

            public void handleEvent(Event event) {
                IdleTimeoutHandler.this.stopCountingDown();
            }
        });
    }

    private AnalyticsOrganizationSetting fetchAnalyticsOrganizationSetting() {
        try {
            Long organizationId = OrganizationHandler.getOrganizationId();
            AnalyticsOrganizationSetting organizationSetting = TestOpsService.getInstance().getOrganiztionSetting(organizationId.longValue());
            return organizationSetting;
        }
        catch (Exception exception) {
            LoggerSingleton.logError((Throwable)exception);
            return null;
        }
    }

    private void showIdleTimeoutWarningDialog(long popupTimeout) {
        if (this.idleTimeoutDialog != null && this.idleTimeoutDialog.isOpened()) {
            return;
        }
        new Thread(() -> UISynchronizeService.syncExec(() -> {
            this.idleTimeoutDialog = new IdleTimeoutDialog(Display.getCurrent().getActiveShell(), popupTimeout, this.maxContinuousIdleSessions);
            int code = this.idleTimeoutDialog.open();
            if (code == 0) {
                this.resetIdleTimer();
                this.turnOffDeactivateTimer();
                this.reduceMaxContinuousIdleSesssion();
                return;
            }
            if (code == 1) {
                return;
            }
            this.stopCountingDown();
            if (code == 16) {
                new DeactivateHandler().execute();
            }
        })).start();
    }

    private void runDeactivateTimer(long popupTimeout) {
        this.deactivateTimer = TimeUtil.setTimeout(() -> UISynchronizeService.syncExec(() -> {
            if (this.idleTimeoutDialog != null && this.idleTimeoutDialog.isOpened()) {
                this.idleTimeoutDialog.close();
            }
            new DeactivateHandler().execute();
        }), (long)popupTimeout);
    }

    private void resetIdleTimer() {
        if (this.idleDebouncer != null && !this.idleDebouncer.isStopped()) {
            this.idleDebouncer.call((Object)"IdleTimeCountDownKey");
        }
    }

    private void turnOffDeactivateTimer() {
        if (this.deactivateTimer != null) {
            this.deactivateTimer.cancel();
        }
    }

    private void reduceMaxContinuousIdleSesssion() {
        if (this.maxContinuousIdleSessions > 0L) {
            this.maxContinuousIdleSessions = this.maxContinuousIdleSessions - 1L;
        }
    }

    public void stopCountingDown() {
        this.unregisterInteractionListeners();
        if (this.idleDebouncer != null) {
            this.idleDebouncer.terminate();
        }
        if (this.checkLauncherTimer != null) {
            this.checkLauncherTimer.cancel();
        }
        if (this.idleTimeoutDialog != null && this.idleTimeoutDialog.isOpened()) {
            this.idleTimeoutDialog.forceClose();
        }
        this.turnOffDeactivateTimer();
    }

    private void registerInteractionListeners() {
        this.unregisterInteractionListeners();
        Display.getCurrent().addFilter(5, this.userInteractListener);
        Display.getCurrent().addFilter(3, this.userInteractListener);
        Display.getCurrent().addFilter(1, this.userInteractListener);
    }

    private void unregisterInteractionListeners() {
        Display.getCurrent().removeFilter(5, this.userInteractListener);
        Display.getCurrent().removeFilter(3, this.userInteractListener);
        Display.getCurrent().removeFilter(1, this.userInteractListener);
    }

    static /* synthetic */ void access$0(IdleTimeoutHandler idleTimeoutHandler, long l) {
        idleTimeoutHandler.showIdleTimeoutWarningDialog(l);
    }

    static /* synthetic */ void access$1(IdleTimeoutHandler idleTimeoutHandler, long l) {
        idleTimeoutHandler.runDeactivateTimer(l);
    }
}

