/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.project.constants.StringConstants;
import com.kms.katalon.composer.util.groovy.GroovyGuiUtil;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebElementSelectorMethod;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import com.kms.katalon.selenium.ide.SeleniumIdeFormatter;
import com.kms.katalon.selenium.ide.SeleniumIdeParser;
import com.kms.katalon.selenium.ide.model.Command;
import com.kms.katalon.selenium.ide.model.TestCase;
import com.kms.katalon.selenium.ide.model.TestSuite;
import com.kms.katalon.selenium.ide.util.ParsedResult;
import com.kms.katalon.tracking.service.Trackings;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ImportSeleniumIdeHandler {
    private IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();
    private static final String COMMON_FOLDER_NAME = "Common";
    private static final String IMPORTED_FOLDER_NAME = "Imported from Selenium IDE Scripts";
    @Inject
    private IEventBroker eventBroker;
    private FolderTreeEntity testSuiteTreeRoot;
    private FolderTreeEntity testCaseTreeRoot;
    private FolderTreeEntity objectRepositoryTreeRoot;

    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null && !LauncherManager.getInstance().isAnyLauncherRunning();
    }

    @Execute
    public void execute(@Named(value="activeShell") @Named(value="activeShell") Shell shell) {
        block9: {
            if (this.featureService.canUse(KSEFeature.IMPORT_SELENIUM_IDE_V3)) {
                Trackings.trackClickImportSeleniumIde();
                try {
                    TestCase testCase;
                    File selectedFile;
                    FileDialog fileDialog = new FileDialog(shell, 131072);
                    fileDialog.setText(StringConstants.HAND_IMPORT_SELENIUM_IDE);
                    fileDialog.setFilterPath(Platform.getLocation().toString());
                    String selectedFilePath = fileDialog.open();
                    if (selectedFilePath == null || selectedFilePath.length() <= 0 || !(selectedFile = new File(selectedFilePath)).exists()) break block9;
                    if (SeleniumIdeParser.getInstance().isSeleniumIdeV3File(selectedFile)) {
                        ParsedResult result = SeleniumIdeParser.getInstance().parseSeleniumIdeV3File(selectedFile);
                        this.createTests(result);
                        Trackings.trackImportSeleniumIdeResult((int)result.getTestCases().size(), (int)result.getTestSuites().size());
                    } else if (SeleniumIdeParser.getInstance().isTestSuiteFile(selectedFile)) {
                        TestSuite testSuite = SeleniumIdeParser.getInstance().parseTestSuite(selectedFile);
                        this.createTestSuite(testSuite);
                    } else if (SeleniumIdeParser.getInstance().isTestCaseFile(selectedFile) && (testCase = SeleniumIdeParser.getInstance().parseTestCase(selectedFile)) != null) {
                        this.createTestObjects(null, Arrays.asList(testCase));
                        FolderEntity importTestCaseFolder = this.getOrCreateFolder(IMPORTED_FOLDER_NAME, this.testCaseTreeRoot.getObject());
                        this.createTestCaseEntity(testCase, importTestCaseFolder);
                    }
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR, (String)MessageConstants.HAND_IMPORT_SELENIUM_IDE_MSG_ERROR);
                    LoggerSingleton.logError((Throwable)e);
                }
            } else {
                KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.IMPORT_SELENIUM_IDE_V3);
            }
        }
    }

    private void createTests(ParsedResult result) throws Exception {
        HashMap<String, String> createdTestCaseIds = new HashMap<String, String>();
        if (!result.getTestCases().isEmpty()) {
            FolderEntity testCaseParentFolderEntity = this.newGetOrCreateFolder(IMPORTED_FOLDER_NAME, this.testCaseTreeRoot.getObject());
            for (TestCase tc : result.getTestCases()) {
                this.createTestCase(tc, testCaseParentFolderEntity, result.getMonoSuiteTests(), createdTestCaseIds);
            }
        }
        if (!result.getTestSuites().isEmpty()) {
            FolderEntity testSuiteParentFolderEntity = this.newGetOrCreateFolder(IMPORTED_FOLDER_NAME, this.testSuiteTreeRoot.getObject());
            for (TestSuite ts : result.getTestSuites()) {
                this.createTestSuite(ts, testSuiteParentFolderEntity, createdTestCaseIds);
            }
        }
    }

    private void createTestCase(TestCase testCase, FolderEntity importTestCaseFolder, Map<String, String> monoSuiteTests, Map<String, String> createdTestCaseIds) throws Exception {
        String id = testCase.getId();
        if (monoSuiteTests.get(id) != null) {
            importTestCaseFolder = this.getOrCreateFolder(monoSuiteTests.get(id), importTestCaseFolder);
        }
        TestCaseEntity testCaseEntity = this.createTestCaseEntity(testCase, importTestCaseFolder);
        createdTestCaseIds.put(id, testCaseEntity.getIdForDisplay());
    }

    private void createTestSuite(TestSuite testSuite, FolderEntity testSuiteParentFolderEntity, Map<String, String> createdTestCaseIds) throws Exception {
        TestSuiteController tsController = TestSuiteController.getInstance();
        TestSuiteEntity testSuiteEntity = tsController.newTestSuiteWithoutSave(testSuiteParentFolderEntity, testSuite.getName());
        if (!testSuite.getTests().isEmpty()) {
            ArrayList testSuiteTestCaseLinks = new ArrayList();
            testSuite.getTests().forEach(id -> {
                TestSuiteTestCaseLink testSuiteTestCaseLink = new TestSuiteTestCaseLink();
                testSuiteTestCaseLink.setTestCaseId((String)createdTestCaseIds.get(id));
                testSuiteTestCaseLinks.add(testSuiteTestCaseLink);
            });
            testSuiteEntity.setTestSuiteTestCaseLinks(testSuiteTestCaseLinks);
        }
        tsController.saveNewTestSuite(testSuiteEntity);
        this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)this.testSuiteTreeRoot);
        try {
            this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)TreeEntityUtil.getTestSuiteTreeEntity((TestSuiteEntity)testSuiteEntity, (ProjectEntity)testSuiteEntity.getProject()));
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        this.eventBroker.post("TESTSUITE/OPEN", (Object)testSuiteEntity);
    }

    private void createTestSuite(TestSuite testSuite) throws Exception {
        if (testSuite == null) {
            return;
        }
        TestSuiteController tsController = TestSuiteController.getInstance();
        FolderEntity testSuiteParentFolderEntity = this.getOrCreateFolder(IMPORTED_FOLDER_NAME, this.testSuiteTreeRoot.getObject());
        TestSuiteEntity testSuiteEntity = tsController.newTestSuiteWithoutSave(testSuiteParentFolderEntity, testSuite.getName());
        testSuiteEntity = tsController.saveNewTestSuite(testSuiteEntity);
        this.createTestCases(testSuiteEntity, testSuite.getTestCases());
        this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)this.testSuiteTreeRoot);
        this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)new TestSuiteTreeEntity(testSuiteEntity, (ITreeEntity)this.testSuiteTreeRoot));
        this.eventBroker.post("TESTSUITE/OPEN", (Object)testSuiteEntity);
    }

    private void createTestCases(TestSuiteEntity testSuiteEntity, List<TestCase> testCases) throws Exception {
        FolderEntity importTestCaseFolder = this.createImportTestCaseFolderEntity(testSuiteEntity.getName());
        if (!testCases.isEmpty()) {
            this.createTestObjects(testSuiteEntity.getName(), testCases);
            ArrayList<TestSuiteTestCaseLink> testSuiteTestCaseLinks = new ArrayList<TestSuiteTestCaseLink>();
            for (TestCase testCase : testCases) {
                TestCaseEntity testCaseEntity = this.createTestCaseEntity(testCase, importTestCaseFolder);
                TestSuiteTestCaseLink testSuiteTestCaseLink = new TestSuiteTestCaseLink();
                testSuiteTestCaseLink.setTestCaseId(testCaseEntity.getIdForDisplay());
                testSuiteTestCaseLinks.add(testSuiteTestCaseLink);
            }
            TestSuiteController tsController = TestSuiteController.getInstance();
            testSuiteEntity.setTestSuiteTestCaseLinks(testSuiteTestCaseLinks);
            tsController.updateTestSuite(testSuiteEntity);
            this.eventBroker.send("TESTSUITE/OPEN", (Object)testSuiteEntity);
        }
    }

    private void createTestObjects(String parentFolderName, List<TestCase> testCases) throws Exception {
        Map<String, Set<String>> testObjectNameMap = this.parseTestObjectNameMap(testCases);
        Set<String> retains = this.retainAllTestObjects(testObjectNameMap);
        if (retains.size() > 0) {
            String commonFolderName = COMMON_FOLDER_NAME;
            FolderEntity commonFolderEntity = this.createImportTestObjectFolderEntity(parentFolderName, commonFolderName);
            for (String t : retains) {
                this.createTestObject(commonFolderEntity, t);
            }
        }
        for (Map.Entry<String, Set<String>> entry : testObjectNameMap.entrySet()) {
            String key = entry.getKey();
            Set<String> value = entry.getValue();
            if (value.size() <= 0) continue;
            FolderEntity folderEntity = this.createImportTestObjectFolderEntity(parentFolderName, key);
            for (String l : value) {
                boolean has = false;
                for (String r : retains) {
                    if (!l.equalsIgnoreCase(r)) continue;
                    has = true;
                    break;
                }
                if (has) continue;
                this.createTestObject(folderEntity, l);
            }
        }
    }

    private Set<String> retainAllTestObjects(Map<String, Set<String>> map) {
        HashSet<String> ret = new HashSet<String>();
        if (map.size() > 1) {
            for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
                Set<String> retains = this.retainTestObjects(entry, map);
                ret.addAll(retains);
            }
        }
        return ret;
    }

    private Set<String> retainTestObjects(Map.Entry<String, Set<String>> item, Map<String, Set<String>> map) {
        HashSet<String> ret = new HashSet<String>();
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            Set<String> value;
            if (entry.getKey().equalsIgnoreCase(item.getKey()) || (value = entry.getValue()) == null) continue;
            HashSet origin = new HashSet(item.getValue());
            origin.retainAll(value);
            ret.addAll(origin);
        }
        return ret;
    }

    private FolderEntity createImportTestCaseFolderEntity(String testCaseFolderName) throws Exception {
        FolderEntity parentFolderEntity = this.getOrCreateFolder(IMPORTED_FOLDER_NAME, this.testCaseTreeRoot.getObject());
        return FolderController.getInstance().addNewFolder(parentFolderEntity, testCaseFolderName);
    }

    private FolderEntity createImportTestObjectFolderEntity(String testSuiteFolderName, String testObjectFolderName) throws Exception {
        FolderEntity parentFolderEntity = this.getOrCreateFolder(IMPORTED_FOLDER_NAME, this.objectRepositoryTreeRoot.getObject());
        FolderEntity testSuiteFolderEntity = null;
        testSuiteFolderEntity = StringUtils.isNotBlank((CharSequence)testSuiteFolderName) ? this.getOrCreateFolder(testSuiteFolderName, parentFolderEntity) : parentFolderEntity;
        return FolderController.getInstance().addNewFolder(testSuiteFolderEntity, testObjectFolderName);
    }

    private TestCaseEntity createTestCaseEntity(TestCase testCase, FolderEntity importTestCaseFolder) throws Exception {
        SeleniumIdeFormatter.getInstance().setEmail(ApplicationInfo.getAppProperty((String)"email"));
        TestCaseController tcController = TestCaseController.getInstance();
        TestCaseEntity testCaseEntity = tcController.newTestCaseWithoutSave(importTestCaseFolder, testCase.getName());
        testCaseEntity = tcController.saveNewTestCase(testCaseEntity);
        String scriptContent = SeleniumIdeFormatter.getInstance().format(testCase);
        GroovyGuiUtil.addContentToTestCase((TestCaseEntity)testCaseEntity, (String)scriptContent);
        this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)this.testCaseTreeRoot);
        this.eventBroker.send("EXPLORER/REFRESH_SELECTED_ITEM", (Object)this.testCaseTreeRoot);
        this.eventBroker.send("EXPLORER/SET_SELECTED_ITEM", (Object)new TestCaseTreeEntity(testCaseEntity, (ITreeEntity)this.testCaseTreeRoot));
        return testCaseEntity;
    }

    private Map<String, Set<String>> parseTestObjectNameMap(List<TestCase> testCases) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (TestCase testCase : testCases) {
            HashSet<String> testObjects = new HashSet<String>();
            for (Command command : testCase.getCommands()) {
                testObjects.add(command.getTarget());
            }
            map.put(testCase.getName(), testObjects);
        }
        return map;
    }

    private WebElementEntity createTestObject(FolderEntity parentFolderEntity, String target) throws Exception {
        ObjectRepositoryController toController = ObjectRepositoryController.getInstance();
        String testObjectName = SeleniumIdeParser.getInstance().parseTestObjectName(target);
        String locator = SeleniumIdeParser.getInstance().parseLocator(target);
        WebElementEntity webElement = null;
        if (StringUtils.isNotBlank((CharSequence)locator) && (webElement = this.getWebElementByName(testObjectName, parentFolderEntity)) == null) {
            webElement = toController.newTestObjectWithoutSave(parentFolderEntity, testObjectName);
            webElement.setSelectorMethod(WebElementSelectorMethod.XPATH);
            webElement.setSelectorValue(WebElementSelectorMethod.XPATH, locator);
            webElement = toController.saveNewTestObject(webElement);
        }
        return webElement;
    }

    private WebElementEntity getWebElementByName(String name, FolderEntity folderEntity) throws Exception {
        List files = FolderController.getInstance().getChildren(folderEntity);
        for (FileEntity entity : files) {
            WebElementEntity webElement;
            if (!(entity instanceof WebElementEntity) || !(webElement = (WebElementEntity)entity).getName().equalsIgnoreCase(name)) continue;
            return webElement;
        }
        return null;
    }

    @Inject
    @Optional
    private void catchTestSuiteFolderTreeEntitiesRoot(@UIEventTopic(value="EXPLORER/RELOAD_INPUT") List<Object> treeEntities) {
        try {
            this.testSuiteTreeRoot = this.getFolderTreeEntity(FolderEntity.FolderType.TESTSUITE, treeEntities);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Inject
    @Optional
    private void catchTestCaseTreeEntitiesRoot(@UIEventTopic(value="EXPLORER/RELOAD_INPUT") List<Object> treeEntities) {
        try {
            this.testCaseTreeRoot = this.getFolderTreeEntity(FolderEntity.FolderType.TESTCASE, treeEntities);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Inject
    @Optional
    private void execute(@UIEventTopic(value="TESTSUITE/NEW") Object eventData) {
        if (!this.canExecute()) {
            return;
        }
        this.execute(Display.getCurrent().getActiveShell());
    }

    @Inject
    @Optional
    private void catchObjectTreeEntitiesRoot(@UIEventTopic(value="EXPLORER/RELOAD_INPUT") List<Object> treeEntities) {
        try {
            this.objectRepositoryTreeRoot = this.getFolderTreeEntity(FolderEntity.FolderType.WEBELEMENT, treeEntities);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private FolderTreeEntity getFolderTreeEntity(FolderEntity.FolderType folderType, List<Object> treeEntities) throws Exception {
        for (Object o : treeEntities) {
            Object entityObject = ((ITreeEntity)o).getObject();
            if (!(entityObject instanceof FolderEntity)) {
                return null;
            }
            FolderEntity folder = (FolderEntity)entityObject;
            if (folder.getFolderType() != folderType) continue;
            return (FolderTreeEntity)o;
        }
        return null;
    }

    private FolderEntity getOrCreateFolder(String folderName, FolderEntity parentFolder) throws Exception {
        List folders = FolderController.getInstance().getChildFolders(parentFolder);
        for (FolderEntity folder : folders) {
            if (!folder.getName().equalsIgnoreCase(folderName)) continue;
            return folder;
        }
        return FolderController.getInstance().addNewFolder(parentFolder, folderName);
    }

    private FolderEntity newGetOrCreateFolder(String folderName, FolderEntity parentFolder) throws Exception {
        String newName = folderName;
        List folders = FolderController.getInstance().getChildFolders(parentFolder);
        ArrayList folderNames = new ArrayList();
        folders.forEach(f -> {
            boolean bl = folderNames.add(f.getName());
        });
        if (folderNames.contains(newName.toLowerCase())) {
            int i = 1;
            while (folderNames.contains(newName.toLowerCase())) {
                newName = String.valueOf(folderName) + " (" + i + ")";
                ++i;
            }
        }
        return FolderController.getInstance().addNewFolder(parentFolder, newName);
    }
}

