/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.katalon.platform.internal.api.PluginInstaller;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.constants.GlobalStringConstants;
import java.io.File;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class InstallPluginHandler {
    private static final String[] FILTER_NAMES = new String[]{"Jar file (*.jar)"};
    private static final String[] FILTER_EXTS = new String[]{"*.jar"};
    private static String pluginPath = "";
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private PluginInstaller pluginInstaller;

    @CanExecute
    public boolean canExecute() {
        return StringUtils.isEmpty((CharSequence)pluginPath);
    }

    @Execute
    public void loadPlugin() throws BundleException {
        Shell activeShell = Display.getCurrent().getActiveShell();
        FileDialog dialog = new FileDialog(activeShell);
        dialog.setFilterNames(FILTER_NAMES);
        dialog.setFilterExtensions(FILTER_EXTS);
        String filePath = dialog.open();
        if (StringUtils.isNotEmpty((CharSequence)filePath)) {
            try {
                Bundle bundle = this.pluginInstaller.installPlugin(InternalPlatform.getDefault().getBundleContext(), new File(filePath).toURI().toString());
                if (bundle != null && bundle.getSymbolicName().equals("com.katalon.katalon-studio-jira-plugin")) {
                    this.eventBroker.post("PLUGIN/JIRA_INSTALLED", null);
                }
                MessageDialog.openInformation((Shell)activeShell, (String)GlobalStringConstants.INFO, (String)"Plugin successfully installed");
                pluginPath = filePath;
            }
            catch (BundleException e) {
                MessageDialog.openError((Shell)activeShell, (String)GlobalStringConstants.ERROR, (String)"Unable to install plugin");
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    public static String getPluginPath() {
        return pluginPath;
    }

    public static void resetPluginPath() {
        pluginPath = "";
    }
}

