/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.activation.dialog.ChooseTestingTypeForGenericProjectDialog;
import com.kms.katalon.activation.dialog.SaveProjectBeforeCloningBDDSampleDialog;
import com.kms.katalon.addons.QuickStartController;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.composer.helpers.KatalonPartHelper;
import com.kms.katalon.composer.helpers.PartBuilder;
import com.kms.katalon.composer.helpers.PartHelper;
import com.kms.katalon.composer.parts.QuickStartPart;
import com.kms.katalon.composer.tour.QuickStartTourType;
import com.kms.katalon.constants.ImageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import com.kms.katalon.entity.project.QuickStartProjectType;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.util.ComposerActivationInfoCollector;
import com.kms.katalon.util.TourUtil;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class OpenQuickStartPageHandler {
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    private static final String QUICK_START_PART_URI = PartHelper.getURI(QuickStartPart.class);

    @Execute
    public void execute(QuickStartTourType quickStartTourType) {
        MPartStack editorPartStack = KatalonPartHelper.getEditorPartStack();
        if (editorPartStack == null) {
            return;
        }
        MPart quickStartPart = PartHelper.findPart("com.kms.katalon.part.quickStart");
        PartHelper.hidePart(quickStartPart);
        if (quickStartPart == null) {
            quickStartPart = PartBuilder.create(editorPartStack).id("com.kms.katalon.part.quickStart").label("Studio Walkthrough").icon(ImageConstants.URI_IMG_WELCOME).contributionURI(QUICK_START_PART_URI).closeable(true).build();
        }
        quickStartPart.setContainerData(quickStartTourType.toString());
        if (this.getProjectType() == ProjectType.GENERIC) {
            EventBrokerSingleton.getInstance().getEventBroker().send("START_PAGE/RELOAD", null);
        }
        PartHelper.showPart(quickStartPart);
    }

    @Execute
    public void execute(QuickStartProjectType quickStartProjectType) {
        QuickStartTourType chosenTourType = QuickStartController.getProjectTourType(quickStartProjectType);
        this.execute(chosenTourType);
    }

    @Execute
    public void execute(EPartService partService) {
        QuickStartProjectType chosenTestingType = this.whichTestingTypeUserUse();
        if (chosenTestingType == null) {
            return;
        }
        boolean cloneSuccess = true;
        if (chosenTestingType == QuickStartProjectType.BDD) {
            int agreeCloneBDDSample = new SaveProjectBeforeCloningBDDSampleDialog(null).open();
            switch (agreeCloneBDDSample) {
                case 1: {
                    boolean isSaved = partService.saveAll(true);
                    TourUtil.setIsUsingBDDSampleProject(true);
                    if (isSaved) break;
                    return;
                }
                case 0: {
                    return;
                }
                default: {
                    return;
                }
            }
            try {
                cloneSuccess = ComposerActivationInfoCollector.quickCreateFirstBDDSampleProject();
            }
            catch (Exception e) {
                LogUtil.logError((Throwable)e);
            }
        }
        if (cloneSuccess) {
            this.execute(chosenTestingType);
            return;
        }
    }

    private QuickStartProjectType whichTestingTypeUserUse() {
        ProjectType currentProjectType = this.getProjectType();
        switch (currentProjectType) {
            case GENERIC: {
                ChooseTestingTypeForGenericProjectDialog dialog = new ChooseTestingTypeForGenericProjectDialog(ShellManager.getMainShell());
                if (dialog.open() == 1) {
                    return dialog.getChosenTestingType();
                }
                return null;
            }
            case WEBUI: {
                return QuickStartProjectType.WEBUI;
            }
            case WEBSERVICE: {
                return QuickStartProjectType.API;
            }
            case MOBILE: {
                return QuickStartProjectType.MOBILE;
            }
            case DESKTOP: {
                return QuickStartProjectType.DESKTOP;
            }
        }
        return QuickStartProjectType.WEBUI;
    }

    private ProjectType getProjectType() {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            return ProjectType.WEBUI;
        }
        return project.getType();
    }

    @Inject
    @Optional
    private void handleOpenAPIQuickStartGenericDialogOpen(@UIEventTopic(value="API/OPEN_QUICK_START_GENERIC_DIALOG") Object object) {
        MPartStack stack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
        if (stack == null) {
            return;
        }
        if (!(object instanceof QuickStartTourType)) {
            return;
        }
        QuickStartTourType chosenTourType = (QuickStartTourType)((Object)object);
        this.execute(chosenTourType);
    }
}

