/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.tutorial.TutorialPart;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.framework.FrameworkUtil;

public class OpenTutorialPartHandler {
    private static final String KATALON_BUNDLE_URI = "bundleclass://" + FrameworkUtil.getBundle(OpenTutorialPartHandler.class).getSymbolicName() + "/";
    private static final String TUTORIAL_PART_URI = String.valueOf(KATALON_BUNDLE_URI) + TutorialPart.class.getName();
    private static final String ICON_URI = "platform:/plugin/" + FrameworkUtil.getBundle(ImageManager.class).getSymbolicName() + "/icons/tutorial/tutorial_part.png";
    @Inject
    protected static MApplication application;
    @Inject
    protected static EModelService modelService;
    @Inject
    protected static EPartService partService;
    @Inject
    protected static IEventBroker eventBroker;

    @Execute
    public void execute(@Named(value="com.kms.katalon.commandparameter.projectType") @Named(value="com.kms.katalon.commandparameter.projectType") String rawProjectType, @Named(value="com.kms.katalon.commandparameter.autoOpenFirstIncompleteTutorial") @Named(value="com.kms.katalon.commandparameter.autoOpenFirstIncompleteTutorial") String autoOpenFirstIncompleteTutorial) {
        boolean shouldShowOverview = StringUtils.isBlank((CharSequence)autoOpenFirstIncompleteTutorial) || Boolean.valueOf(autoOpenFirstIncompleteTutorial) == false;
        ProjectType projectType = StringUtils.isNotBlank((CharSequence)rawProjectType) ? ProjectType.valueOf((String)rawProjectType) : null;
        projectType = projectType != null ? projectType : this.getHandlerProjectType();
        this.execute(projectType, shouldShowOverview);
    }

    protected ProjectType getHandlerProjectType() {
        ProjectEntity curProject = ProjectController.getInstance().getCurrentProject();
        return curProject != null ? curProject.getType() : null;
    }

    public void execute(ProjectType projectType, boolean shouldShowOverview) {
        String partId;
        MPart mPart;
        if (ProjectController.getInstance().getCurrentProject() == null) {
            return;
        }
        MPartStack stack = (MPartStack)modelService.find("com.kms.katalon.partstack.tutorial", (MUIElement)application);
        if (stack == null) {
            return;
        }
        if (!stack.isVisible()) {
            stack.setVisible(true);
        }
        if ((mPart = (MPart)modelService.find(partId = this.getPartId(), (MUIElement)stack)) != null) {
            stack.getChildren().remove(mPart);
            partService.hidePart(mPart, true);
        }
        mPart = (MPart)modelService.createModelElement(MPart.class);
        mPart.setElementId(partId);
        mPart.setLabel(StringConstants.PA_TUTORIAL);
        mPart.setIconURI(this.getIconURI());
        mPart.setContributionURI(this.getContributionURI());
        mPart.setCloseable(true);
        stack.getChildren().add(mPart);
        mPart.setVisible(true);
        mPart.setToBeRendered(true);
        partService.activate(mPart, true);
        TutorialPart tutorialPart = (TutorialPart)mPart.getObject();
        tutorialPart.initComponents(projectType, shouldShowOverview);
        stack.setSelectedElement((MUIElement)mPart);
    }

    @CanExecute
    public boolean canExecute() {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        return project != null && !ActivationInfoCollector.isLicenseOffline();
    }

    public void onProjectClosed() {
        MPartStack stack = (MPartStack)modelService.find("com.kms.katalon.partstack.tutorial", (MUIElement)application);
        if (stack == null) {
            return;
        }
        String partId = this.getPartId();
        MPart mPart = (MPart)modelService.find(partId, (MUIElement)stack);
        if (mPart != null) {
            partService.hidePart(mPart);
        }
    }

    private String getPartId() {
        return "com.kms.katalon.part.tutorial";
    }

    private String getContributionURI() {
        return TUTORIAL_PART_URI;
    }

    private String getIconURI() {
        return ICON_URI;
    }
}

