/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.activation.dialog.WarningReactivateDialog;
import com.kms.katalon.activation.plugin.models.KStoreApiKeyCredentials;
import com.kms.katalon.activation.plugin.models.KStoreClientAuthException;
import com.kms.katalon.activation.plugin.models.KStoreCredentials;
import com.kms.katalon.activation.plugin.models.KStorePlugin;
import com.kms.katalon.activation.plugin.models.Plugin;
import com.kms.katalon.activation.plugin.models.ReloadItem;
import com.kms.katalon.activation.plugin.service.PluginService;
import com.kms.katalon.activation.plugin.util.KStoreCredentialsHelper;
import com.kms.katalon.application.utils.LicenseUtil;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.handlers.RequireAuthorizationHandler;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.plugin.dialog.ReloadPluginsHelpDialog;
import com.kms.katalon.plugin.dialog.ReloadPluginsResultDialog;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.widgets.Display;

public class ReloadPluginsHandler
extends RequireAuthorizationHandler {
    private static final long DIALOG_CLOSED_DELAY_MILLIS = 500L;

    @CanExecute
    public boolean canExecute() {
        return true;
    }

    @Execute
    public void execute() {
        this.reloadPlugins(false);
    }

    public void reloadPlugins(final boolean silentMode) {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        if (!silentMode && currentProject == null) {
            this.openHelpDialog();
            return;
        }
        final List[] resultHolder = new List[1];
        final Job reloadPluginsJob = new Job("Reloading plugins..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    KStoreApiKeyCredentials[] credentials = new KStoreApiKeyCredentials[1];
                    if (PluginService.getInstance().shouldReloadPluginsOnline()) {
                        UISynchronizeService.syncExec(() -> {
                            try {
                                kStoreApiKeyCredentialsArray[0] = ReloadPluginsHandler.getApiKeyCredential(silentMode);
                            }
                            catch (KStoreClientAuthException e) {
                                LoggerSingleton.logError((Throwable)e);
                            }
                        });
                    }
                    if (PluginService.getInstance().shouldReloadPluginsOnlineOnly() && !KStoreCredentialsHelper.isValidCredential((KStoreCredentials)credentials[0])) {
                        LoggerSingleton.logError((String)StringConstants.KStore_ERROR_INVALID_CREDENTAILS);
                        return Status.CANCEL_STATUS;
                    }
                    LoggerSingleton.logInfo((String)"Reloading plugins.");
                    boolean isEnterpriseLicense = LicenseUtil.isNotFreeLicense();
                    resultHolder[0] = PluginService.getInstance().reloadPlugins((KStoreCredentials)credentials[0], monitor, isEnterpriseLicense);
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                    if (StringUtils.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)StringConstants.KStore_ERROR_INVALID_CREDENTAILS)) {
                        return new Status(8, "com.kms.katalon", StringConstants.KStore_ERROR_INVALID_CREDENTAILS, (Throwable)e);
                    }
                    return new Status(silentMode ? 2 : 4, "com.kms.katalon", "Error reloading plugins", (Throwable)new Exception(ExceptionsUtil.getStackTraceForThrowable((Throwable)e)));
                }
                LoggerSingleton.logInfo((String)"Reloaded plugins successfully.");
                return Status.OK_STATUS;
            }
        };
        reloadPluginsJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                EventBrokerSingleton.getInstance().getEventBroker().post("WORKSPACE/PLUGIN_LOADED", null);
                if (StringUtils.containsIgnoreCase((CharSequence)reloadPluginsJob.getResult().getMessage(), (CharSequence)StringConstants.KStore_ERROR_INVALID_CREDENTAILS)) {
                    LoggerSingleton.logError((String)StringConstants.KStore_ERROR_INVALID_CREDENTAILS);
                    Executors.newSingleThreadExecutor().submit(() -> {
                        try {
                            TimeUnit.MILLISECONDS.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                        if (!silentMode) {
                            UISynchronizeService.syncExec(() -> ReloadPluginsHandler.this.openWarningDialog());
                        }
                    });
                    return;
                }
                if (!reloadPluginsJob.getResult().isOK()) {
                    LoggerSingleton.logError((String)"Failed to reload plugins.");
                    return;
                }
                List cfr_ignored_0 = resultHolder[0];
                if (silentMode) {
                    return;
                }
                Executors.newSingleThreadExecutor().submit(() -> {
                    try {
                        TimeUnit.MILLISECONDS.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    UISynchronizeService.syncExec(() -> ReloadPluginsHandler.this.openResultDialog(resultHolder[0]));
                });
            }
        });
        reloadPluginsJob.setUser(silentMode);
        reloadPluginsJob.schedule();
    }

    private boolean checkExpire(List<ReloadItem> reloadItems) {
        return reloadItems.stream().filter(i -> {
            Plugin plugin = i.getPlugin();
            if (plugin.isOnline()) {
                KStorePlugin onlinePlugin = plugin.getOnlinePlugin();
                return onlinePlugin.isExpired() || onlinePlugin.isTrial() && onlinePlugin.getRemainingDay() <= 14;
            }
            return false;
        }).findAny().isPresent();
    }

    private void openWarningDialog() {
        WarningReactivateDialog dialog = new WarningReactivateDialog(Display.getCurrent().getActiveShell(), StringConstants.KStore_MSG_INVALID_CREDENTAILS);
        dialog.open();
    }

    private void openResultDialog(List<ReloadItem> result) {
        ReloadPluginsResultDialog dialog = new ReloadPluginsResultDialog(Display.getCurrent().getActiveShell(), result);
        dialog.open();
    }

    private void openHelpDialog() {
        ReloadPluginsHelpDialog dialog = new ReloadPluginsHelpDialog(Display.getCurrent().getActiveShell());
        dialog.open();
    }

    static /* synthetic */ void access$0(ReloadPluginsHandler reloadPluginsHandler) {
        reloadPluginsHandler.openWarningDialog();
    }

    static /* synthetic */ void access$1(ReloadPluginsHandler reloadPluginsHandler, List list) {
        reloadPluginsHandler.openResultDialog(list);
    }
}

