/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.activation.plugin.models.KStoreApiKeyCredentials;
import com.kms.katalon.activation.plugin.models.KStoreClientAuthException;
import com.kms.katalon.activation.plugin.models.KStoreClientException;
import com.kms.katalon.activation.plugin.models.KStoreCredentials;
import com.kms.katalon.activation.plugin.service.KStoreRestClient;
import com.kms.katalon.activation.plugin.util.KStoreTokenService;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.composer.helpers.AuthenticationController;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiException;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import java.io.IOException;
import java.security.GeneralSecurityException;

public abstract class RequireAuthorizationHandler {
    public static KStoreApiKeyCredentials getApiKeyCredential() throws KStoreClientAuthException {
        return RequireAuthorizationHandler.getApiKeyCredential(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KStoreApiKeyCredentials getApiKeyCredential(boolean silentMode) throws KStoreClientAuthException {
        try {
            TestOpsService testOpsService = TestOpsService.getInstance();
            if (testOpsService.getAdminToken().isEmpty()) {
                if (silentMode || !AuthenticationController.getInstance().requestAuthenOnline(ShellManager.getLastActiveAliveShell())) {
                    return null;
                }
                KStoreApiKeyCredentials credentials = new KStoreApiKeyCredentials();
                credentials.setApiKey(testOpsService.fetchAPIKey());
                KStoreRestClient restClient = new KStoreRestClient((KStoreCredentials)credentials);
                KStoreRestClient.AuthenticationResult authenticateResult = restClient.authenticate();
                if (authenticateResult.isAuthenticated()) {
                    String rawStoreToken = authenticateResult.getToken();
                    KStoreTokenService.getInstance().createNewToken(rawStoreToken);
                }
            }
            String apiKey = testOpsService.fetchAPIKey();
            KStoreApiKeyCredentials credential = new KStoreApiKeyCredentials();
            credential.setApiKey(apiKey);
            return credential;
        }
        catch (KStoreClientException | AnalyticsApiException | IOException | GeneralSecurityException e) {
            throw new KStoreClientAuthException((Exception)e);
        }
    }
}

