/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.helpers;

import com.kms.katalon.activation.dialog.AuthenRequestOptions;
import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.core.event.EventEmitter;
import org.eclipse.swt.widgets.Shell;

public class AuthenticationController {
    private EventEmitter emitter = new EventEmitter();
    private static AuthenticationController instance;

    public static AuthenticationController getInstance() {
        if (instance == null) {
            instance = new AuthenticationController();
        }
        return instance;
    }

    public void onAuthenRequested(AuthenRequestedListener listener) {
        this.emitter.on((Enum)AuthenEventType.AUTHEN_REQUESTED, (EventEmitter.CustomEventListener)listener);
    }

    public void offAuthenRequested(AuthenRequestedListener listener) {
        this.emitter.off((Enum)AuthenEventType.AUTHEN_REQUESTED, (EventEmitter.CustomEventListener)listener);
    }

    public boolean requestAuthen() {
        return this.requestAuthen(null);
    }

    public boolean requestAuthenOnline() {
        return this.requestAuthenOnline(null);
    }

    public boolean requestAuthenOnline(Shell parentShell) {
        AuthenRequestOptions options = new AuthenRequestOptions().simpleMode().keepLicense().keepOrganization().setParentShell(parentShell);
        this.requestAuthen(options);
        return ActivationInfoCollector.isActivated() && !ActivationInfoCollector.isLicenseOffline();
    }

    public boolean requestAuthen(AuthenRequestOptions options) {
        this.emitter.emit((Enum)AuthenEventType.AUTHEN_REQUESTED, (Object)options);
        return ActivationInfoCollector.isActivated();
    }

    private static enum AuthenEventType {
        AUTHEN_REQUESTED;

    }

    public static interface AuthenRequestedListener
    extends EventEmitter.CustomEventListener<AuthenRequestOptions> {
        public void call(AuthenRequestOptions var1);
    }
}

