/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.initializer;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.initializer.ApplicationInitializer;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.IOException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.graphics.FontData;

public class DefaultTextFontInitializer
implements ApplicationInitializer {
    private static final String DF_FONT_ON_WIN = "Consolas";
    private static final String DF_FONT_ON_MAC = "Monaco";
    private static final String FALLBACK_FONT = "Courier New";

    @Override
    public void setup() {
        ScopedPreferenceStore store = PreferenceStoreManager.getPreferenceStore((String)"org.eclipse.ui.workbench");
        if (store.getBoolean("firstTimeSetupCompleted")) {
            return;
        }
        FontDescriptor fontDescriptor = null;
        switch (Platform.getOS()) {
            case "macosx": {
                fontDescriptor = FontDescriptor.createFrom((String)DF_FONT_ON_MAC, (int)11, (int)0);
                break;
            }
            case "win32": {
                fontDescriptor = FontDescriptor.createFrom((String)DF_FONT_ON_WIN, (int)10, (int)0);
            }
        }
        if (fontDescriptor == null) {
            fontDescriptor = FontDescriptor.createFrom((String)FALLBACK_FONT, (int)12, (int)0);
        }
        FontData defaultFont = fontDescriptor.getFontData()[0];
        store.setValue("org.eclipse.jface.textfont", defaultFont.toString());
        store.setValue("firstTimeSetupCompleted", true);
        try {
            store.save();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

