/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.parts;

import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.handlers.ActiveEventLogPartHandler;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class EventLogPart {
    private static final int MAX_LENGTH = 80000;
    @Inject
    private IEventBroker eventBroker;
    private StyledText text;
    boolean isOnTop = false;

    @PostConstruct
    public void createPart(Composite parent, MPart mpart) {
        Composite container = new Composite(parent, 0);
        container.setBackground(ColorUtil.getWhiteBackgroundColor());
        container.setLayout((Layout)new GridLayout());
        this.text = new StyledText(container, 2826);
        this.text.setFont(JFaceResources.getTextFont());
        this.text.setLayoutData((Object)new GridData(1808));
        this.eventBroker.subscribe("KATALON_STUDIO/EVENT_LOG/CLEAR_LOG", new EventHandler(){

            public void handleEvent(Event event) {
                if (EventLogPart.this.text.isDisposed()) {
                    return;
                }
                UISynchronizeService.syncExec(() -> {
                    EventLogPart.this.text.setText("");
                    ActiveEventLogPartHandler.getInstance().clearBufferredStrings();
                });
            }
        });
        this.text.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                EventLogPart.this.safelyPrintLog();
            }
        });
    }

    private void safelyPrintLog() {
        if (this.isNotSafetyToPrint()) {
            return;
        }
        UISynchronizeService.asyncExec(() -> this.printBufferredLog());
    }

    private boolean isNotSafetyToPrint() {
        return this.text == null || this.text.isDisposed();
    }

    private void truncateTextIfReachMaxLength() {
        if (this.text.getText().length() >= 80000) {
            this.text.setText(StringUtils.substring((String)this.text.getText(), (int)(this.text.getText().length() - 80000)));
        }
    }

    private void printBufferredLog() {
        ActiveEventLogPartHandler logHandler = ActiveEventLogPartHandler.getInstance();
        List<ActiveEventLogPartHandler.ColorString> bufferredStrings = logHandler.getBufferredStrings();
        logHandler.clearBufferredStrings();
        if (bufferredStrings.isEmpty()) {
            return;
        }
        Iterator iterator = bufferredStrings.iterator();
        while (iterator.hasNext()) {
            if (this.isNotSafetyToPrint()) {
                return;
            }
            ActiveEventLogPartHandler.ColorString colorString = (ActiveEventLogPartHandler.ColorString)iterator.next();
            StyleRange range = new StyleRange();
            range.start = this.text.getText().length();
            range.length = colorString.getString().length();
            range.foreground = colorString.isError() ? JFaceColors.getErrorText((Display)this.text.getDisplay()) : ColorUtil.getTextColor();
            this.text.append(colorString.getString());
            this.text.setStyleRange(range);
        }
        this.truncateTextIfReachMaxLength();
        this.text.setTopIndex(this.text.getLineCount() - 1);
    }
}

