/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.parts;

import com.kms.katalon.composer.components.impl.util.ResourcesUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class MarkdownPart {
    private boolean shouldSetContent = true;

    @PostConstruct
    public void createComposite(Composite parent, MPart mpart) {
        final File sourceFile = (File)mpart.getObject();
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        final Browser browser = new Browser(container, 0);
        browser.setJavascriptEnabled(true);
        String sourceContent = ResourcesUtil.getFileContent(MarkdownPart.class, (String)"resources/template/markdown_template.html");
        browser.setText(sourceContent);
        browser.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent event) {
                try {
                    if (MarkdownPart.this.shouldSetContent) {
                        MarkdownPart.this.shouldSetContent = false;
                        String content = StringEscapeUtils.escapeEcmaScript((String)FileUtils.readFileToString((File)sourceFile, (Charset)StandardCharsets.UTF_8));
                        browser.evaluate("document.getElementById('content').innerHTML = marked('" + content + "');");
                    }
                }
                catch (IOException e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }

            public void changed(ProgressEvent event) {
            }
        });
    }
}

