/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.parts;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.composer.helpers.PartHelper;
import com.kms.katalon.composer.tour.QuickStartTourType;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.EncodingUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import com.kms.katalon.webserver.WebViewController;
import java.text.MessageFormat;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class QuickStartPart {
    public static final Map<ProjectType, QuickStartTourType> QUICK_START_TYPE_MAP = new EnumMap<ProjectType, QuickStartTourType>(ProjectType.class);
    private Composite mainComposite;
    @Inject
    private IEventBroker eventBroker;

    static {
        QUICK_START_TYPE_MAP.put(ProjectType.WEBUI, QuickStartTourType.WEB_TESTING);
        QUICK_START_TYPE_MAP.put(ProjectType.WEBSERVICE, QuickStartTourType.API_TESTING);
        QUICK_START_TYPE_MAP.put(ProjectType.MOBILE, QuickStartTourType.MOBILE_TESTING);
        QUICK_START_TYPE_MAP.put(ProjectType.DESKTOP, QuickStartTourType.DESKTOP_TESTING);
        QUICK_START_TYPE_MAP.put(ProjectType.GENERIC, QuickStartTourType.WEB_TESTING);
    }

    @PostConstruct
    public void init(Composite parent) {
        this.registerEventListeners(parent);
        this.create(parent);
    }

    private void create(Composite parent) {
        if (!ControlUtil.isDisposed((Widget)this.mainComposite) && this.mainComposite != null) {
            this.mainComposite.dispose();
        }
        WebViewController.getInstance().ensureStarted();
        this.mainComposite = (Composite)ComponentBuilder.fillContainer((Composite)parent).build();
        QuickStartTourType quickStartType = QuickStartPart.getCurrentQuickStartTourType();
        String tourName = quickStartType != null ? quickStartType.name() : "";
        UserProfile curProfile = UserProfileHelper.getCurrentProfile();
        String completedTours = EncodingUtil.encodeURIComponent((Object)curProfile.getCompletedTours());
        String query = MessageFormat.format("tour_type={0}&completed_tours={1}", tourName, completedTours);
        String url = WebViewController.getInstance().getPage("QuickStartPage.html?" + query);
        ComponentBuilder.browser((Composite)this.mainComposite).url(url).defaultBrowserConfig().build();
    }

    public static QuickStartTourType getCurrentQuickStartTourType() {
        String quickStartPartId;
        MPart quickStartPart;
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        if (currentProject == null) {
            return null;
        }
        ProjectType projectType = currentProject.getType();
        if (projectType == ProjectType.GENERIC && (quickStartPart = PartHelper.findPart(quickStartPartId = "com.kms.katalon.part.quickStart")) != null && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{quickStartPart.getContainerData()})) {
            return QuickStartTourType.valueOf(quickStartPart.getContainerData());
        }
        return QUICK_START_TYPE_MAP.get(projectType);
    }

    private void refreshQuickStart(Composite parent, String nextTour) {
        if (!ControlUtil.isDisposed((Widget)this.mainComposite) && this.mainComposite != null) {
            this.mainComposite.dispose();
        }
        WebViewController.getInstance().ensureStarted();
        this.mainComposite = (Composite)ComponentBuilder.fillContainer((Composite)parent).build();
        QuickStartTourType quickStartType = QuickStartPart.getCurrentQuickStartTourType();
        String tourName = quickStartType != null ? quickStartType.name() : "";
        UserProfile curProfile = UserProfileHelper.getCurrentProfile();
        String completedTours = EncodingUtil.encodeURIComponent((Object)curProfile.getCompletedTours());
        String query = MessageFormat.format("tour_type={0}&completed_tours={1}&next_tour={2}", tourName, completedTours, nextTour);
        String url = WebViewController.getInstance().getPage("QuickStartPage.html?" + query);
        ComponentBuilder.browser((Composite)this.mainComposite).url(url).defaultBrowserConfig().build();
    }

    private void registerEventListeners(final Composite parent) {
        this.eventBroker.subscribe("QUICK_START/RELOAD", new EventHandler(){

            public void handleEvent(Event event) {
                UISynchronizeService.asyncExec(() -> {
                    String nextTour = event.getProperty("org.eclipse.e4.data").toString();
                    QuickStartPart.this.refreshQuickStart(parent, nextTour);
                    parent.layout(true, true);
                });
            }
        });
    }
}

