/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.parts;

import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.kms.katalon.composer.components.impl.editors.MarkdownPart;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.impl.util.ResourcesUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.handlers.CheckForUpdatesHandler;
import com.kms.katalon.constants.ImageConstants;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.core.network.HttpClientProxyBuilder;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.forum.KatalonForumTopic;
import com.kms.katalon.forum.KatalonForumTopicDeserializer;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.tracking.service.Trackings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class WelcomeBottomPart
extends Composite {
    private static final Color BACKGROUND_COLOR = ColorUtil.getWhiteBackgroundColor();
    private static final Color GAINSBORO = ColorUtil.getColor((String)"#E7E7E7");
    private static final Color OLIVE_DRAB = ColorUtil.getColor((String)"#5CAE20");
    private static final Color UPGRADE = ColorUtil.getColor((String)"#498F00");
    private Composite upgradeComposite;
    private GridData upgradeGridData;

    public WelcomeBottomPart(Composite parent, int style) {
        super(parent, style);
        this.setLayoutData(new GridData(4, 4, true, true));
        GridLayout gl = new GridLayout(3, true);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.horizontalSpacing = 16;
        this.setLayout((Layout)gl);
        this.createSection(this, StringConstants.WelcomeBottomPart_BEST_PRACTICES, ImageConstants.WelcomeBottomPart_STAR, StringConstants.PA_WELCOME_PART_BEST_PRACTICE, "best_practices");
        this.createMiddleSections();
        this.createSection(this, StringConstants.WelcomeBottomPart_NEW, ImageConstants.WelcomeBottomPart_OVAL, StringConstants.PA_WELCOME_PART_MARKETING, "marketing");
    }

    private List<KatalonForumTopic> fetchForumTopicsForStartPage(Composite parent) {
        try {
            String noti_server_url = StringConstants.KATALON_FORUM_TOPICS_URL;
            URI uri = new URIBuilder().setPath(noti_server_url).build();
            HttpGet httpPost = new HttpGet(uri);
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setHeader("Api-Key", StringConstants.KATALON_FORUM_TOKEN);
            httpPost.setHeader("Api-Username", StringConstants.KATALON_FORUM_USERNAME);
            String responseString = WelcomeBottomPart.executeRequest((HttpUriRequest)httpPost, true);
            Type listType = new TypeToken<ArrayList<KatalonForumTopic>>(){}.getType();
            List katalonForumTopics = (List)new GsonBuilder().registerTypeAdapter(listType, (Object)new KatalonForumTopicDeserializer()).create().fromJson(responseString, listType);
            return katalonForumTopics.stream().filter(a -> a.getTags().contains("start-page")).collect(Collectors.toList());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return Collections.emptyList();
        }
    }

    protected void checkSubclass() {
    }

    private void createMarkdownView(Composite container, final String contentLink, final String area) {
        final Browser browser = new Browser(container, 0);
        browser.setJavascriptEnabled(true);
        String sourceContent = ResourcesUtil.getFileContent(MarkdownPart.class, (String)"resources/template/markdown_template.html");
        browser.setText(sourceContent);
        ControlUtils.recursivelySetColor((Control)browser, (Color)ColorUtil.getTextBlackColor(), (Color)BACKGROUND_COLOR);
        browser.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent event) {
                String content = "";
                try {
                    content = StringEscapeUtils.escapeEcmaScript((String)WelcomeBottomPart.this.getContentFromHTML(contentLink));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                browser.evaluate("document.getElementById('content').innerHTML = marked('" + content + "');");
            }

            public void changed(ProgressEvent event) {
            }
        });
        browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                event.doit = false;
                WelcomeBottomPart.this.openURL(area, event.location);
            }

            public void changed(LocationEvent event) {
            }
        });
    }

    private void openURL(String area, String url) {
        Trackings.trackStartPageLinkClicked((String)area, (String)url);
        Program.launch((String)url);
    }

    private void createForumView(Composite container, final String area) {
        Composite c = new Composite(container, 0);
        c.setLayout((Layout)new GridLayout());
        List<KatalonForumTopic> katalonForumTopicsForStartPage = this.fetchForumTopicsForStartPage(container);
        for (KatalonForumTopic topic : katalonForumTopicsForStartPage) {
            Link linkToTopic = new Link(c, 64);
            GridData gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            linkToTopic.setLayoutData((Object)gd);
            final String link = "https://forum.katalon.com/t/" + topic.getSlug();
            String linkTemplate = "<a href=\"" + link + "\">" + topic.getTitle() + "</a>";
            linkToTopic.setText(linkTemplate);
            linkToTopic.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    WelcomeBottomPart.this.openURL(area, link);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    private String getContentFromHTML(String link) throws MalformedURLException, IOException {
        try (BufferedReader br = null;){
            String inputLine;
            URL url = new URL(link);
            URLConnection conn = url.openConnection();
            br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((inputLine = br.readLine()) != null) {
                sb.append(inputLine).append("\n");
            }
            String string = sb.toString();
            return string;
        }
    }

    private void createMiddleSections() {
        Composite container = new Composite((Composite)this, 0);
        GridData gd = new GridData(4, 4, true, true);
        container.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.verticalSpacing = 10;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        container.setLayout((Layout)gl);
        this.createSection(container, StringConstants.WelcomeBottomPart_RELEASE_HIGHLIGHTS, ImageConstants.WelcomeBottomPart_CHECK, StringConstants.PA_WELCOME_PART_RELEASE_HIGHLIGHT, "releasehighlights");
        this.createSection(container, StringConstants.WelcomeBottomPart_FORUM_TOPICS, ImageConstants.WelcomeBottomPart_FORUM, null, "forum_topics");
    }

    private void createSection(Composite parent, String title, Image icon, String url, final String area) {
        final Composite section = new Composite(parent, 0);
        section.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(GAINSBORO);
                e.gc.drawRoundRectangle(0, 0, section.getBounds().width - 2, section.getBounds().height - 2, 35, 35);
            }
        });
        GridData gd = new GridData(4, 4, true, true);
        section.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 12;
        gl.marginWidth = 15;
        gl.verticalSpacing = 11;
        section.setLayout((Layout)gl);
        Composite top = new Composite(section, 0);
        GridData topGd = new GridData();
        topGd.horizontalAlignment = 4;
        topGd.grabExcessHorizontalSpace = true;
        top.setLayoutData((Object)topGd);
        GridLayout topGl = new GridLayout(2, false);
        topGl.marginHeight = 0;
        topGl.marginWidth = 0;
        top.setLayout((Layout)topGl);
        Composite left = new Composite(top, 0);
        GridLayout leftGl = new GridLayout(2, false);
        left.setLayout((Layout)leftGl);
        Label iconLabel = new Label(left, 0);
        iconLabel.setImage(icon);
        Label titleLabel = new Label(left, 0);
        titleLabel.setText(title.toUpperCase());
        titleLabel.setForeground(OLIVE_DRAB);
        ControlUtils.setFontToBeBold((Control)titleLabel);
        ControlUtils.setFontSize((Control)titleLabel, (int)11);
        if (title == StringConstants.WelcomeBottomPart_BEST_PRACTICES) {
            this.createRatingsView(top);
        }
        Composite middle = new Composite(section, 0);
        middle.setLayoutData((Object)new GridData(4, 4, true, true));
        middle.setLayout((Layout)new FillLayout());
        if (title == StringConstants.WelcomeBottomPart_FORUM_TOPICS) {
            this.createForumView(middle, area);
        } else {
            this.createMarkdownView(middle, url, area);
        }
        if (title == StringConstants.WelcomeBottomPart_RELEASE_HIGHLIGHTS) {
            this.createUpgradeComposite(section);
        }
        MouseAdapter ma = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Trackings.trackStartPageAreaClicked((String)area);
            }
        };
        this.addMouseListener((Control)section, (MouseListener)ma);
    }

    private void addMouseListener(Control c, MouseListener ma) {
        c.addMouseListener(ma);
        if (c instanceof Composite) {
            Control[] controlArray = ((Composite)c).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control cc = controlArray[n2];
                this.addMouseListener(cc, ma);
                ++n2;
            }
        }
    }

    private void createUpgradeComposite(Composite parent) {
        this.upgradeComposite = new Composite(parent, 0);
        this.upgradeGridData = new GridData();
        this.upgradeGridData.horizontalAlignment = 4;
        this.upgradeGridData.grabExcessHorizontalSpace = true;
        this.upgradeComposite.setLayoutData((Object)this.upgradeGridData);
        this.upgradeComposite.setLayout((Layout)new RowLayout());
        ComponentBuilder.label((Composite)this.upgradeComposite).text(StringConstants.WelcomeBottomPart_UPGRADE).fontSize(12).size(66, 24).primaryButton2().border(1, UPGRADE).background(ColorUtil.getWhiteBackgroundColor()).color(ColorUtil.getTextBlackColor()).onClick(event -> {
            Trackings.trackStartPageAreaClicked((String)"releasehighlights_upgrade");
            new CheckForUpdatesHandler().checkForUpdate(false);
        }).build();
    }

    private void createRatingsView(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 3;
        gd.grabExcessHorizontalSpace = true;
        container.setLayoutData((Object)gd);
        RowLayout rl = new RowLayout();
        rl.spacing = 8;
        container.setLayout((Layout)rl);
        final Label like = new Label(container, 0);
        like.setImage(ImageConstants.WelcomeBottomPart_LIKE);
        final Label dislike = new Label(container, 0);
        dislike.setImage(ImageConstants.WelcomeBottomPart_DISLIKE);
        Cursor cursor = new Cursor((Device)this.getDisplay(), 21);
        like.setCursor(cursor);
        dislike.setCursor(cursor);
        like.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                Trackings.trackStartPageAreaClicked((String)"best_practices_thumbsup");
                dislike.setImage(ImageConstants.WelcomeBottomPart_DISLIKE);
                if (like.getImage().equals((Object)ImageConstants.WelcomeBottomPart_LIKE)) {
                    like.setImage(ImageConstants.WelcomeBottomPart_LIKE_CLICKED);
                } else {
                    like.setImage(ImageConstants.WelcomeBottomPart_LIKE);
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        dislike.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                Trackings.trackStartPageAreaClicked((String)"best_practices_thumbsdown");
                like.setImage(ImageConstants.WelcomeBottomPart_LIKE);
                if (dislike.getImage().equals((Object)ImageConstants.WelcomeBottomPart_DISLIKE)) {
                    dislike.setImage(ImageConstants.WelcomeBottomPart_DISLIKE_CLICKED);
                } else {
                    dislike.setImage(ImageConstants.WelcomeBottomPart_DISLIKE);
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    private static String executeRequest(HttpUriRequest httpRequest, boolean isSilent) throws Exception {
        HttpClientProxyBuilder httpClientProxyBuilder = HttpClientProxyBuilder.create((ProxyInformation)ProxyPreferences.getAuthProxyInformation(), (String)httpRequest.getURI().toURL().toString());
        CloseableHttpClient httpClient = httpClientProxyBuilder.getClientBuilder().build();
        HttpResponse httpResponse = httpClient.execute(httpRequest);
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        HttpEntity entity = httpResponse.getEntity();
        String responseString = "";
        if (entity != null) {
            responseString = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
        }
        if (statusCode == 200 || statusCode == 201 || statusCode == 204) {
            return responseString;
        }
        if (!isSilent) {
            LogUtil.logError((String)MessageFormat.format("Katalon notifications, URL: {0}, Status: {1}, Response: {2}", httpRequest.getURI().toString(), statusCode, responseString));
        }
        throw new Exception(responseString);
    }
}

