/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.parts;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.kms.katalon.addons.QuickStartController;
import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.composer.components.impl.control.ScrollableComposite;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.composer.parts.WelcomeLeftPart;
import com.kms.katalon.composer.parts.WelcomeRightPart;
import com.kms.katalon.composer.tour.IntroduceStudioAssistHandler;
import com.kms.katalon.composer.tour.QuickStartTourType;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.EncodingUtil;
import com.kms.katalon.core.util.TimeUtil;
import com.kms.katalon.core.util.internal.Base64;
import com.kms.katalon.core.webservice.common.HttpUtil;
import com.kms.katalon.core.webservice.exception.SendRequestException;
import com.kms.katalon.entity.project.ProjectType;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiException;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.util.TourUtil;
import com.kms.katalon.webserver.WebViewController;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.event.EventHandler;

public class WelcomePart2 {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EPartService partService;
    private MPart part;
    private Composite mainComposite;
    private Browser webview;
    private boolean isOnlineStartPageContent;
    private final String TIMESTAMP_FORMAT = "HH:mm:ss - dd/MM/yyyy";
    private static final long FOUR_WEEKS = 28L;

    @PostConstruct
    public void initialize(Composite parent, MPart part) {
        this.part = part;
        WebViewController.getInstance().ensureStarted();
        this.registerEventListeners(parent);
        if (ActivationInfoCollector.getLicenseType() != null) {
            this.createControls(parent);
        }
    }

    private void showThisPart() {
        IPreferenceStore prefStore = PlatformUI.getPreferenceStore();
        if (!prefStore.contains("general.showHelpAtStartUp")) {
            prefStore.setDefault("general.showHelpAtStartUp", true);
        }
        if (!prefStore.getBoolean("general.showHelpAtStartUp")) {
            this.partService.hidePart(this.part);
        }
    }

    private void registerEventListeners(final Composite parent) {
        this.eventBroker.subscribe("PROJECT/OPENED", new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                WelcomePart2.this.showThisPart();
            }
        });
        this.eventBroker.subscribe("ACTIVATION/WEBVIEW_PAGE", new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                UISynchronizeService.asyncExec(() -> {
                    WelcomePart2.this.createControls(parent);
                    parent.layout(true, true);
                });
            }
        });
        this.eventBroker.subscribe("START_PAGE/RELOAD", new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                if (!WelcomePart2.this.isOnlineStartPageContent) {
                    return;
                }
                UISynchronizeService.asyncExec(() -> {
                    WelcomePart2.this.createControls(parent);
                    parent.layout(true, true);
                });
            }
        });
        this.eventBroker.subscribe("INTRODUCE_STUDIOASSIST", new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                new IntroduceStudioAssistHandler().execute();
            }
        });
    }

    private void createControls(Composite parent) {
        this.createOnlineControls(parent);
        this.setFirstTimeUserLogin();
        TimeUtil.setTimeout(() -> {
            if (!this.checkOnline()) {
                UISynchronizeService.asyncExec(() -> {
                    if (ControlUtil.isDisposed((Widget)this.mainComposite)) {
                        return;
                    }
                    this.mainComposite.dispose();
                    this.createOfflineControls(parent);
                    parent.requestLayout();
                });
            }
        }, (long)1000L);
    }

    private void setFirstTimeUserLogin() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss - dd/MM/yyyy");
        UserProfile curUser = UserProfileHelper.getCurrentProfile();
        String currentDate = dateFormat.format(new Date());
        if (curUser.getFirstTimeActivate() == null) {
            curUser.setFirstTimeActivate(currentDate);
            UserProfileHelper.saveProfile((UserProfile)curUser);
        }
    }

    private boolean checkOnline() {
        try {
            return TestOpsService.getInstance().testAdminConnection();
        }
        catch (AnalyticsApiException analyticsApiException) {
            return false;
        }
    }

    private void createOfflineControls(Composite parent) {
        FillLayout parentLayout = new FillLayout();
        parentLayout.marginHeight = 0;
        parentLayout.marginWidth = 0;
        parent.setLayout((Layout)parentLayout);
        final ScrollableComposite container = new ScrollableComposite(parent, 768);
        if (!ControlUtil.isDisposed((Widget)this.mainComposite) && this.mainComposite != null) {
            this.mainComposite.dispose();
        }
        this.mainComposite = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)2).background(ColorUtil.getCompositeBackgroundColor()).backgroundMode(2).build();
        this.mainComposite.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                Point size = WelcomePart2.this.mainComposite.computeSize(-1, -1);
                if (container.getMinHeight() < size.y) {
                    container.setMinHeight(size.y);
                }
            }
        });
        container.setContent((Control)this.mainComposite);
        container.setMinSize(new Point(900, 1300));
        container.setExpandHorizontal(true);
        container.setExpandVertical(true);
        WelcomeLeftPart leftComposite = new WelcomeLeftPart(this.mainComposite, 0);
        leftComposite.setLayoutData(new GridData(16384, 4, false, true));
        Composite rightComposite = new Composite(this.mainComposite, 0);
        GridLayout glRightComposite = new GridLayout(3, false);
        glRightComposite.marginHeight = 0;
        glRightComposite.marginWidth = 0;
        glRightComposite.marginTop = 40;
        glRightComposite.horizontalSpacing = 0;
        glRightComposite.verticalSpacing = 0;
        rightComposite.setLayout((Layout)glRightComposite);
        rightComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        WelcomePart2.addSpacer(rightComposite);
        WelcomeRightPart startPageContent = new WelcomeRightPart(rightComposite, 0, StringConstants.PA_WELCOME_RIGHT_PART_LINK);
        GridData gdStartPageContent = new GridData(4, 4, true, true);
        gdStartPageContent.minimumWidth = 600;
        startPageContent.setLayoutData(gdStartPageContent);
        WelcomePart2.addSpacer(rightComposite);
        this.isOnlineStartPageContent = false;
    }

    private void createOnlineControls(Composite parent) {
        if (!ControlUtil.isDisposed((Widget)this.mainComposite) && this.mainComposite != null) {
            this.mainComposite.dispose();
        }
        this.mainComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent).build();
        String url = this.getUrlForStartPage();
        this.webview = (Browser)ComponentBuilder.browser((Composite)this.mainComposite).url(url).defaultBrowserConfig().fill().build();
        TimeUtil.setTimeout(() -> this.checkAndShowCreativeStartPage(), (long)3000L);
        this.isOnlineStartPageContent = true;
    }

    private String getUrlForStartPage() {
        UserProfile userProfile = UserProfileHelper.getCurrentProfile();
        int pageId = this.getPageId(userProfile);
        String tourType = QuickStartController.getCurProjectTourType().name();
        String nextTour = TourUtil.getNextTour().name();
        if (ProjectController.getInstance().getCurrentProject() != null && ProjectController.getInstance().getCurrentProject().getType().equals((Object)ProjectType.GENERIC)) {
            tourType = QuickStartTourType.GENERIC_TESTING.name();
            if (!nextTour.equals(QuickStartTourType.TEST_PLANNING.name())) {
                nextTour = QuickStartTourType.GENERIC_TESTING.name();
            }
        }
        String query = MessageFormat.format("?id={0}&tour_type={1}&next_tour={2}", pageId, tourType, nextTour);
        if (this.allowShowStartPageContents()) {
            return WebViewController.getInstance().getPage("StartPage.html" + query);
        }
        return WebViewController.getInstance().getPage("CreativeStartPage.html" + query);
    }

    private int getPageId(UserProfile userProfile) {
        List completedTours;
        int id = 1;
        if (userProfile == null) {
            return id;
        }
        if (userProfile.getCompletedTours().contains(QuickStartTourType.TEST_PLANNING.name())) {
            id = 2;
        }
        if ((completedTours = userProfile.getCompletedTours()).contains(QuickStartTourType.SET_UP_KRE.name()) && completedTours.contains(QuickStartTourType.TEST_CLOUD_TESTING.name()) && completedTours.contains(QuickStartTourType.ANALYZE_TEST_ACTIVITIES.name()) && completedTours.contains(QuickStartTourType.TEST_PLANNING.name())) {
            if (completedTours.contains(QuickStartTourType.CREATE_FIRST_PROJECT.name()) && (completedTours.contains(QuickStartTourType.WEB_TESTING.name()) || completedTours.contains(QuickStartTourType.API_TESTING.name()) || completedTours.contains(QuickStartTourType.MOBILE_TESTING.name()) || completedTours.contains(QuickStartTourType.DESKTOP_TESTING.name()))) {
                id = 3;
            }
            if (completedTours.contains(QuickStartTourType.BDD_TESTING.name()) && completedTours.contains(QuickStartTourType.BDD_TESTING_FEATURE_FILE.name()) && completedTours.contains(QuickStartTourType.BDD_TESTING_STEP_DEFINITION.name()) && completedTours.contains(QuickStartTourType.BDD_TESTING_ADDING_TO_TEST_CASE.name())) {
                id = 3;
            }
        }
        if (userProfile.getFirstTimeActivate() != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss - dd/MM/yyyy");
            String currentDate = dateFormat.format(new Date());
            try {
                long diffInDays = TimeUnit.DAYS.convert(dateFormat.parse(currentDate).getTime() - dateFormat.parse(userProfile.getFirstTimeActivate()).getTime(), TimeUnit.MILLISECONDS);
                if (diffInDays > 28L) {
                    id = 3;
                }
            }
            catch (ParseException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        return id;
    }

    private boolean allowShowStartPageContents() {
        boolean allowShowStartPageContents;
        IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();
        ScopedPreferenceStore prefStore = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon");
        boolean bl = allowShowStartPageContents = prefStore.contains("general.showStartPageContents") ? prefStore.getBoolean("general.showStartPageContents") : true;
        if (featureService.canUse(KSEFeature.CONFIGURE_SHOW_START_PAGE_CONTENTS)) {
            return allowShowStartPageContents;
        }
        return true;
    }

    private void checkAndShowCreativeStartPage() {
        HttpGet request = new HttpGet(StringConstants.PA_WELCOME_PART_SPECIAL_START_PAGE);
        try {
            HttpResponse response = HttpUtil.sendRequest((HttpUriRequest)request);
            String body = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            Type listType = new TypeToken<List<SpecialEvent>>(){}.getType();
            Gson gson = new GsonBuilder().setDateFormat("d-M-yyyy").create();
            List events = (List)gson.fromJson(body, listType);
            List activeEvents = events.stream().filter(event -> {
                Date now = new Date();
                return now.after(event.getStartDate()) && now.before(event.getEndDate());
            }).collect(Collectors.toList());
            if (!activeEvents.isEmpty()) {
                SpecialEvent firstActiveEvent = (SpecialEvent)activeEvents.get(0);
                String encodedContent = Base64.encode((String)firstActiveEvent.getContent());
                String encodedURIContent = EncodingUtil.encodeURIComponent((String)encodedContent);
                if (StringUtils.startsWithIgnoreCase((CharSequence)firstActiveEvent.getContent(), (CharSequence)"http")) {
                    ComponentUtil.preventUrls((Browser)this.webview, (String[])new String[]{".*" + firstActiveEvent.getContent()});
                }
                UISynchronizeService.syncExec(() -> {
                    if (ControlUtil.isDisposed((Widget)this.webview)) {
                        return;
                    }
                    this.webview.setUrl(WebViewController.getInstance().getPage("CreativeStartPage.html?content=" + encodedURIContent));
                });
            }
        }
        catch (SendRequestException | IOException | IllegalArgumentException | org.apache.http.ParseException error) {
            LoggerSingleton.logError((Throwable)error);
        }
    }

    private static void addSpacer(Composite rightComposite) {
        Label spacer = new Label(rightComposite, 0);
        spacer.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    @Focus
    public void setFocus() {
        if (!ControlUtil.isDisposed((Widget)this.mainComposite)) {
            this.mainComposite.forceFocus();
        }
    }

    @PreDestroy
    public void onPartClosed() {
        if (this.mainComposite != null) {
            this.webview.dispose();
            this.mainComposite.dispose();
        }
    }

    private static class SpecialEvent {
        private String title;
        private String content;
        private Date startDate;
        private Date endDate;

        private SpecialEvent() {
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public void setStartDate(Date startDate) {
            this.startDate = startDate;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public void setEndDate(Date endDate) {
            this.endDate = endDate;
        }
    }
}

