/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.preferences;

import com.google.gson.reflect.TypeToken;
import com.kms.katalon.composer.tutorial.TutorialCollection;
import com.kms.katalon.composer.tutorial.TutorialPart;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TutorialPreferenceStore {
    private static final String TUTORIALS_STORED_KEY = "tutorialLists";

    public static TutorialCollection getTutorialCollection(String user) {
        List<TutorialCollection> tutorialCollections = TutorialPreferenceStore.getTutorialCollectionsOfAllUsers();
        return tutorialCollections.stream().filter(l -> l.getUser().equals(user)).findFirst().orElse(null);
    }

    public static void saveTutorialCollection(TutorialCollection tutorialCollection) throws IOException {
        String user = tutorialCollection.getUser();
        if (StringUtils.isBlank((CharSequence)user)) {
            return;
        }
        List<TutorialCollection> collectionList = TutorialPreferenceStore.getTutorialCollectionsOfAllUsers();
        int idx = collectionList.indexOf(tutorialCollection);
        if (idx != -1) {
            collectionList.set(idx, tutorialCollection);
        } else {
            collectionList.add(tutorialCollection);
        }
        TutorialPreferenceStore.getPreferenceStore().setValue(TUTORIALS_STORED_KEY, (String)StringUtils.defaultIfBlank((CharSequence)JsonUtil.toJson(collectionList), (CharSequence)""));
        TutorialPreferenceStore.getPreferenceStore().save();
    }

    private static List<TutorialCollection> getTutorialCollectionsOfAllUsers() {
        String collectionListJson = TutorialPreferenceStore.getPreferenceStore().getString(TUTORIALS_STORED_KEY);
        if (StringUtils.isNotBlank((CharSequence)collectionListJson)) {
            return new ArrayList<TutorialCollection>((Collection)JsonUtil.fromJson((String)collectionListJson, (Type)new TypeToken<List<TutorialCollection>>(){}.getType()));
        }
        return new ArrayList<TutorialCollection>();
    }

    private static ScopedPreferenceStore getPreferenceStore() {
        return PreferenceStoreManager.getPreferenceStore(TutorialPart.class);
    }
}

