/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.quickstart;

import com.kms.katalon.application.userprofile.UserExperienceLevel;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.StyleContext;
import com.kms.katalon.composer.quickstart.BaseQuickStartDialog;
import com.kms.katalon.composer.tour.OpenFirstProjectTourHandler;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.entity.project.QuickStartProjectType;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.collections.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class QuickStartDialogV2
extends BaseQuickStartDialog {
    private List<Pair<?, String>> quickStartProjectTypes = Arrays.asList(QuickStartProjectType.WEBUI, QuickStartProjectType.MOBILE, QuickStartProjectType.API, QuickStartProjectType.DESKTOP, QuickStartProjectType.BDD).stream().map(projectType -> new Pair(projectType, (Object)projectType.getName())).collect(Collectors.toList());
    private UserExperienceLevel userLevel = UserExperienceLevel.FRESHER;
    private QuickStartProjectType projectType = QuickStartProjectType.WEBUI;

    public QuickStartDialogV2(Shell parentShell) {
        super(parentShell);
    }

    @Override
    public String getDialogTitle() {
        return MessageConstants.KATALON_QUICKSTART_DIALOG_TITLE;
    }

    @Override
    protected void createContent(Composite container) {
        Composite contentContainer = (Composite)ComponentBuilder.gridContainer((Composite)container).margin(5, 120, 5).fillHorizontal().gridVerticalSpacing(5).build();
        this.createWelcomeHeader(contentContainer);
        this.createQuickStartQuestions(contentContainer);
        Trackings.trackQuickStartOpen();
    }

    @Override
    protected void createButtons(Composite parent) {
        Composite buttonsCompositeWrapper = (Composite)ComponentBuilder.gridContainer((Composite)parent).fill().build();
        Composite buttonsComposite = (Composite)ComponentBuilder.gridContainer((Composite)buttonsCompositeWrapper, (int)2).right().margin(10).build();
        ComponentBuilder.canvas((Composite)buttonsComposite).text(MessageConstants.BTN_CLOSE_TILE).grayButton().textCenter().autoSizeSM(120).onClick(event -> {
            this.userLevel = UserExperienceLevel.EXPERIENCED;
            this.close();
        }).build();
        this.mainButton = (Canvas)ComponentBuilder.canvas((Composite)buttonsComposite).text(MessageConstants.BTN_CONTINUE).primaryButton().textCenter().autoSizeSM(120).onClick(event -> {
            this.okPressed();
            Trackings.trackQuickStartWelcomeCreateProject((String)this.projectType.name());
        }).build();
    }

    private void createWelcomeHeader(Composite parent) {
        Composite headerContainer = (Composite)ComponentBuilder.gridContainer((Composite)parent).fillHorizontal().marginBottom(ComponentUtil.applyZoom((int)30)).build();
        ComponentBuilder.image((Composite)headerContainer, (String)"quick_start/logo_74.png").applyZoom().center().build();
        ComponentBuilder.label((Composite)headerContainer).text(MessageConstants.KATALON_QUICK_START_MAIN_MESSAGE).fontSize(24).center().marginTop(5).build();
    }

    private void createQuickStartQuestions(Composite parent) {
        StyleContext.setColor((Color)ColorUtil.getColor((String)"#636384"));
        this.createStage(parent);
        StyleContext.prevColor();
    }

    private Composite createStage(Composite parent) {
        Composite stageContainer = (Composite)ComponentBuilder.gridContainer((Composite)parent).fillHorizontal().marginBottom(ComponentUtil.applyZoom((int)40)).build();
        this.createQuickStartQuestion(stageContainer, QuestionBuilder.create(MessageConstants.QUICK_START_PROJECT_TYPE_QUESTION, this.quickStartProjectTypes).onChange((control, option) -> {
            this.projectType = (QuickStartProjectType)option;
        }).align(0x1000000).defaultValue(this.projectType).build());
        return stageContainer;
    }

    private void createQuickStartQuestion(Composite parent, Question question) {
        Composite questContainer = (Composite)ComponentBuilder.gridContainer((Composite)parent).align(question.align == 0x1000000 ? 4 : 16384).marginTop(30).build();
        ComponentBuilder.label((Composite)questContainer).text(question.question).bold().align(question.align).build();
        Composite optionsGroup = (Composite)ComponentBuilder.gridContainer((Composite)questContainer, (int)question.numCols).gridHorizontalSpacing(30).gridVerticalSpacing(5).marginTop(20).marginLeft(20).fillHorizontal().align(question.align).build();
        question.answers.forEach(option -> {
            Button btnOption = (Button)ComponentBuilder.button((Composite)optionsGroup, (int)question.buttonType).text((String)option.getRight()).data(option.getLeft()).onOptionChange(question.onChange).build();
            btnOption.setSelection(question.defaultValue != null && option.getLeft() == question.defaultValue);
        });
    }

    public UserExperienceLevel getUserLevel() {
        return this.userLevel;
    }

    public QuickStartProjectType getProjectType() {
        return this.projectType;
    }

    private void triggerOpenFirstProjectTour() {
        new OpenFirstProjectTourHandler().execute();
    }

    @Override
    protected boolean isClosable() {
        return false;
    }

    @Override
    protected boolean isResizable() {
        return false;
    }

    @Override
    protected boolean shouldReopen() {
        return false;
    }

    private static class Question {
        private String question;
        private List<Pair<?, String>> answers;
        private int numCols;
        private int align;
        private int buttonType;
        private Object defaultValue;
        private ComponentEventUtil.OptionChangeHandler onChange;

        public Question(String question, List<Pair<?, String>> answers) {
            this.question = question;
            this.answers = answers;
            this.numCols = answers.size();
            this.align = 16384;
            this.defaultValue = null;
            this.buttonType = 16;
        }
    }

    private static class QuestionBuilder {
        private Question question;

        public QuestionBuilder(String question, List<Pair<?, String>> answers) {
            this.question = new Question(question, answers);
        }

        public static QuestionBuilder create(String question, List<Pair<?, String>> answers) {
            return new QuestionBuilder(question, answers);
        }

        public QuestionBuilder onChange(ComponentEventUtil.OptionChangeHandler onChange) {
            this.question.onChange = onChange;
            return this;
        }

        public QuestionBuilder align(int align) {
            this.question.align = align;
            return this;
        }

        public QuestionBuilder defaultValue(Object defaultValue) {
            this.question.defaultValue = defaultValue;
            return this;
        }

        public Question build() {
            return this.question;
        }
    }
}

