/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.quickstart;

import com.kms.katalon.application.userprofile.UserExperienceLevel;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.StyleContext;
import com.kms.katalon.composer.quickstart.BaseQuickStartDialog;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.entity.project.QuickStartProjectType;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.Question;
import com.kms.katalon.util.QuestionBuilder;
import com.kms.katalon.util.collections.Pair;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class QuickStartPlatformDialog
extends BaseQuickStartDialog {
    private List<Pair<?, String>> questOptions = Arrays.asList(QuickStartProjectType.WEBUI, QuickStartProjectType.MOBILE, QuickStartProjectType.API, QuickStartProjectType.DESKTOP).stream().map(projectType -> new Pair(projectType, (Object)projectType.getName())).collect(Collectors.toList());
    private QuickStartProjectType projectType;

    public QuickStartPlatformDialog(Shell parentShell) {
        super(parentShell);
    }

    @Override
    public String getDialogTitle() {
        return MessageConstants.KATALON_QUICK_START;
    }

    @Override
    protected String getMainButtonText() {
        return MessageConstants.GET_STARTED;
    }

    @Override
    protected void createContent(Composite container) {
        Composite contentContainer = (Composite)ComponentBuilder.gridContainer((Composite)container).margin(5, 120, 5).fillHorizontal().gridVerticalSpacing(5).build();
        this.createWelcomeHeader(contentContainer);
        this.createQuickStartQuestions(contentContainer);
        Trackings.trackQuickStartOpen();
    }

    @Override
    protected void adjustLayout() {
        this.handleSelectionChange();
        super.adjustLayout();
    }

    private void createWelcomeHeader(Composite parent) {
        Composite headerContainer = (Composite)ComponentBuilder.gridContainer((Composite)parent).fillHorizontal().build();
        ComponentBuilder.image((Composite)headerContainer, (String)"quick_start/logo_74.png").applyZoom().center().build();
        ComponentBuilder.label((Composite)headerContainer).text(MessageConstants.TEST_GENERATION_IDE).fontSize(24).center().marginTop(5).build();
        ComponentBuilder.label((Composite)headerContainer).text(MessageConstants.KATALON_TESTING_PLATFORM).fontSize(18).color(ColorUtil.getColor((String)"#636384")).center().build();
    }

    private void createQuickStartQuestions(Composite parent) {
        StyleContext.setColor((Color)ColorUtil.getColor((String)"#636384"));
        this.createStage1(parent);
        StyleContext.prevColor();
    }

    private Composite createStage1(Composite parent) {
        Composite stageContainer = (Composite)ComponentBuilder.gridContainer((Composite)parent).margin(30, 60, 10).fillHorizontal().build();
        this.createQuickStartQuestion(stageContainer, QuestionBuilder.create(MessageConstants.QUICK_START_PLATFORM_QUESTION, this.questOptions).align(0x1000000).onChange((control, option) -> {
            this.projectType = (QuickStartProjectType)option;
            this.handleSelectionChange();
        }).build());
        return stageContainer;
    }

    private void createQuickStartQuestion(Composite parent, Question question) {
        Composite questContainer = (Composite)ComponentBuilder.gridContainer((Composite)parent).align(question.getAlign() == 0x1000000 ? 4 : 16384).marginTop(20).build();
        ComponentBuilder.label((Composite)questContainer).text(question.getQuestion()).bold().align(question.getAlign()).build();
        Composite optionsGroup = (Composite)ComponentBuilder.gridContainer((Composite)questContainer, (int)question.getNumCols()).gridHorizontalSpacing(30).gridVerticalSpacing(5).marginTop(20).marginLeft(20).fillHorizontal().align(question.getAlign()).build();
        question.getAnswers().forEach(option -> {
            Button btnOption = (Button)ComponentBuilder.button((Composite)optionsGroup, (int)question.getButtonType()).text((String)option.getRight()).data(option.getLeft()).onOptionChange(question.getOnChange()).build();
            btnOption.setSelection(question.getDefaultValue() != null && option.getLeft() == question.getDefaultValue());
        });
    }

    private void handleSelectionChange() {
        boolean isValidInput = this.projectType != null;
        ComponentUtil.setEnabledButton((Control)this.mainButton, (boolean)isValidInput);
    }

    public QuickStartProjectType getProjectType() {
        return this.projectType;
    }

    public UserExperienceLevel getUserLevel() {
        return UserExperienceLevel.FRESHER;
    }

    protected void okPressed() {
        Trackings.trackQuickStartWelcome2((String)this.projectType.name(), (String)"", (String)String.join((CharSequence)",", new HashSet()));
        Trackings.trackQuickStartWelcome3();
        super.okPressed();
    }

    @Override
    protected boolean isClosable() {
        return false;
    }

    @Override
    protected boolean isResizable() {
        return false;
    }

    @Override
    protected boolean shouldReopen() {
        return false;
    }
}

