/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.quickstart;

import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.quickstart.BaseQuickStartDialog;
import com.kms.katalon.tracking.service.Trackings;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class QuickSurveyLeavingRecordDialog
extends BaseQuickStartDialog {
    private final int CONTENT_WIDTH = 500;
    private final int OTHER_ANSWER_INPUT_HEIGHT = 50;
    private boolean isActionButtonClicked = false;
    private String answer;
    private String otherAnswer;
    private Text txtOtherAnswer;

    public QuickSurveyLeavingRecordDialog(Shell parentShell) {
        super(parentShell);
    }

    @Override
    public String getDialogTitle() {
        return "Could you leave us a comment?";
    }

    @Override
    protected void createContent(Composite container) {
        Composite body = (Composite)ComponentBuilder.gridContainer((Composite)container).margin(30).gridVerticalSpacing(10).build();
        this.createSurvey(body);
    }

    private void createSurvey(Composite parent) {
        Composite surveyComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)1).build();
        String confirmQuestion = "We would appreciate if you could tell us the reason why you stop the recording:";
        ComponentBuilder.label((Composite)surveyComposite).text(confirmQuestion).autoWidth(500).gridVerticalSpacing(5).build();
        Listener handleOptionChange = event -> {
            this.answer = ((Button)event.widget).getText();
            this.txtOtherAnswer.setEnabled(this.answer == "Other");
        };
        this.createOption(surveyComposite, "I don't know what to do, it looks confusing", handleOptionChange);
        this.createOption(surveyComposite, "I know how to record tests, but want to do something else", handleOptionChange);
        this.createOption(surveyComposite, "I have done my recording, but don't want to save it", handleOptionChange);
        this.createOption(surveyComposite, "Other", handleOptionChange);
        this.txtOtherAnswer = (Text)ComponentBuilder.text((Composite)surveyComposite, (int)2114).fill().onChange(event -> {
            this.otherAnswer = ((Text)event.widget).getText();
        }).border().autoHeight(50).build();
    }

    private void createOption(Composite parent, String text, Listener onClick) {
        ComponentBuilder.radio((Composite)parent).left().text(text).onClick(onClick).build();
    }

    @Override
    protected void createButtons(Composite parent) {
        Composite buttonsCompositeWrapper = (Composite)ComponentBuilder.gridContainer((Composite)parent).fill().build();
        Composite buttonsComposite = (Composite)ComponentBuilder.gridContainer((Composite)buttonsCompositeWrapper, (int)2).right().margin(10).build();
        ComponentBuilder.canvas((Composite)buttonsComposite).text("Close").grayButton().autoSizeSM(80).onClick(event -> {
            this.isActionButtonClicked = true;
            Trackings.trackQuickRecordSurveyClose();
            this.cancelPressed();
        }).build();
        ComponentBuilder.canvas((Composite)buttonsComposite).text("Send").primaryButton().autoSizeSM(80).onClick(event -> {
            this.isActionButtonClicked = true;
            Trackings.trackQuickRecordSurveySend((String)this.answer, (String)this.otherAnswer);
            this.okPressed();
        }).build();
    }

    @Override
    public boolean close() {
        if (!this.isActionButtonClicked) {
            Trackings.trackQuickRecordSurveyClose();
            this.setReturnCode(0);
        }
        return super.close();
    }

    @Override
    protected boolean isClosable() {
        return true;
    }
}

