/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.toolbar;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.PartServiceSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ImageUtil;
import java.net.MalformedURLException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class PerspectiveSwitcher {
    private static final String ECLIPSE_MAIN_TOOLBAR_ID = "org.eclipse.ui.main.toolbar";
    @Inject
    IEventBroker eventBroker;
    @Inject
    EModelService modelService;
    @Inject
    private MWindow window;
    @Inject
    private EPartService partService;
    @Inject
    private MApplication application;
    private MToolControl perspectiveToolControl;
    private ToolBar toolbar;
    private EventHandler selectionHandler = new EventHandler(){

        public void handleEvent(Event event) {
            MWindow switcherWin;
            if (PerspectiveSwitcher.this.toolbar.isDisposed()) {
                return;
            }
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (PerspectiveSwitcher.this.perspectiveToolControl == null || !(changedElement instanceof MPerspectiveStack)) {
                return;
            }
            MWindow perspWin = PerspectiveSwitcher.this.modelService.getTopLevelWindowFor(changedElement);
            if (perspWin != (switcherWin = PerspectiveSwitcher.this.modelService.getTopLevelWindowFor((MUIElement)PerspectiveSwitcher.this.perspectiveToolControl))) {
                return;
            }
            MPerspectiveStack perspStack = (MPerspectiveStack)changedElement;
            if (!perspStack.isToBeRendered()) {
                return;
            }
            MPerspective selElement = (MPerspective)perspStack.getSelectedElement();
            ToolItem[] toolItemArray = PerspectiveSwitcher.this.toolbar.getItems();
            int n = toolItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                ToolItem ti;
                ti.setSelection((ti = toolItemArray[n2]).getData() == selElement);
                ++n2;
            }
        }
    };

    private void registerEvent() {
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*", this.selectionHandler);
    }

    private void addPerspectiveItem(MPerspective perspective) {
        ToolItem tltmNewItem = new ToolItem(this.toolbar, 32);
        tltmNewItem.setToolTipText(perspective.getTooltip());
        tltmNewItem.setText(perspective.getLabel());
        try {
            tltmNewItem.setImage(ImageUtil.loadImage((String)perspective.getIconURI()));
        }
        catch (MalformedURLException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        tltmNewItem.setData((Object)perspective);
        tltmNewItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolItem selectedItem = (ToolItem)e.getSource();
                if (!selectedItem.getSelection()) {
                    selectedItem.setSelection(true);
                    return;
                }
                PerspectiveSwitcher.this.activePerspective(selectedItem);
            }
        });
    }

    private void activePerspective(ToolItem toolItem) {
        ToolItem[] toolItemArray = this.toolbar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem childItem = toolItemArray[n2];
            childItem.setSelection(childItem.equals(toolItem));
            ++n2;
        }
        MPerspective perspective = (MPerspective)toolItem.getData();
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.find("com.kms.katalon.composer.perspectiveStack", (MUIElement)this.window);
        if (perspectiveStack == null) {
            return;
        }
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MTrimBar toolControl = (MTrimBar)this.find(ECLIPSE_MAIN_TOOLBAR_ID, (MUIElement)this.application);
        if (toolControl != null) {
            toolControl.getChildren().removeAll(toolControl.getPendingCleanup());
        }
        if ("com.kms.katalon.composer.perspective.keyword".equals(perspective.getElementId())) {
            this.eventBroker.post("EXPLORER/RELOAD_DATA", (Object)false);
            return;
        }
        if ("org.eclipse.debug.ui.DebugPerspective".equals(perspective.getElementId())) {
            this.reopenPartsIfClosed(perspective);
        }
    }

    public void reopenPartsIfClosed(MPerspective perspective) {
        this.showPart("org.eclipse.debug.ui.DebugView", perspective);
        this.showPart("org.eclipse.debug.ui.VariableView", perspective);
        this.showPart("org.eclipse.debug.ui.BreakpointView", perspective);
        this.showPart("org.eclipse.debug.ui.ExpressionView", perspective);
        MPlaceholder consolePlaceholder = (MPlaceholder)this.find("org.eclipse.ui.console.ConsoleView", (MUIElement)perspective);
        if (consolePlaceholder != null && !consolePlaceholder.isToBeRendered()) {
            this.partService.showPart(consolePlaceholder.getElementId(), EPartService.PartState.ACTIVATE);
        }
    }

    private void showPart(String partId, MPerspective perspective) {
        MPart part = (MPart)this.find(partId, (MUIElement)perspective);
        if (part != null && part.getCurSharedRef() != null && !part.getCurSharedRef().isToBeRendered()) {
            this.partService.showPart(part.getElementId(), EPartService.PartState.ACTIVATE);
        }
    }

    @PostConstruct
    void createWidget(Composite parent, MToolControl toolControl) {
        PartServiceSingleton.getInstance().setPartService(this.partService);
        this.application.getContext().set(EPartService.class, (Object)this.partService);
        this.perspectiveToolControl = toolControl;
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(container, 514);
        GridData gdLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdLabel.heightHint = 24;
        label.setLayoutData((Object)gdLabel);
        this.toolbar = new ToolBar(container, 0x820000);
        this.toolbar.setForeground(ColorUtil.getToolBarForegroundColor());
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.find("com.kms.katalon.composer.perspectiveStack", (MUIElement)this.window);
        if (perspectiveStack == null) {
            return;
        }
        for (MPerspective perspective : perspectiveStack.getChildren()) {
            if (!perspective.isToBeRendered()) continue;
            this.addPerspectiveItem(perspective);
        }
        this.initialPerspectiveSelection();
        this.registerEvent();
    }

    private void initialPerspectiveSelection() {
        MPerspective activePerspective = this.modelService.getActivePerspective(this.window);
        if (activePerspective == null) {
            this.toolbar.getItems()[0].setSelection(true);
            return;
        }
        ToolItem[] toolItemArray = this.toolbar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item = toolItemArray[n2];
            item.setSelection(item.getText().equals(activePerspective.getLabel()));
            ++n2;
        }
    }

    public ToolBar getToolbar() {
        return this.toolbar;
    }

    public <T> T find(String elementId, MUIElement where) {
        return (T)this.modelService.find(elementId, where);
    }
}

