/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.tour;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.composer.components.impl.editors.MirrorEditor;
import com.kms.katalon.composer.components.impl.overlay.HighlightOverlay;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentDataUtil;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentFinder;
import com.kms.katalon.composer.components.util.ComponentSelector;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.composer.components.util.UITimeUtil;
import com.kms.katalon.composer.handlers.OpenQuickStartOverviewHandler;
import com.kms.katalon.composer.helpers.KatalonPartHelper;
import com.kms.katalon.composer.helpers.PartHelper;
import com.kms.katalon.composer.tour.GeneralTourStep;
import com.kms.katalon.composer.tour.KatalonTour;
import com.kms.katalon.composer.tour.QuickStartTourType;
import com.kms.katalon.composer.tour.StepInfo;
import com.kms.katalon.composer.tour.TourAction;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.util.ObjectUtil;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.TourEventBroker;
import java.text.MessageFormat;
import java.util.Timer;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class APITestingTourHandler {
    private HighlightOverlay mainOverlay;
    private static final String SAMPLE_SWAGGER_FILE = "https://petstore.swagger.io/v2/swagger.json";
    private static final String HTTP_HEADER = "HTTP Header";
    private static final String HTTP_BODY = "HTTP Body";
    private static final String SAMPLE_REQUEST_NAME = "addPet";
    private static final String IMPORT_SWAGGER_DIALOG_TITLE = "Import Swagger (2.0 only)";
    private String customRequestName;
    private String testCaseName;
    private String testObjectId;
    private HighlightOverlay importRequestsOverlay;
    private HighlightOverlay newRequestOverlay;
    private HighlightOverlay newTestCaseOverlay;
    private Composite requestEditor;
    private Composite testCaseEditor;
    private Composite scriptView;
    private Combo requestTypeCombo;
    private CCombo requestMethodCCombo;
    private CCombo authorizationTypeCCombo;
    private Composite headerTabContent;
    private Composite bodyTabContent;
    private ToolItem testRequestButton;
    private Composite responsePart;
    private Timer waitForRunMenuTimer;

    @Execute
    public void execute() {
        UISynchronizeService.asyncExec(() -> {
            KatalonTour tour = new KatalonTour(QuickStartTourType.API_TESTING);
            String firstName = ApplicationContext.getInstance().getUserFirstName();
            firstName = StringUtils.isNotBlank((CharSequence)firstName) ? MessageFormat.format(" {0}", firstName) : "";
            this.addStep1CreateAnApiManually(tour, "create-request", String.valueOf(MessageFormat.format("Hi{0}! Welcome to our onboarding tour: \"Create and run your first API test\".", firstName)) + "\r\n\r\nLet's start with creating an API request!\r\n" + "\r\n" + "Right-click on the \"Object Repository\" folder, then choose [New] > [Web Service Request].", "");
            this.addStep2InputApiName(tour, "input-request-name", "Let's give your request a name.", "");
            this.addStep3SelectRequestType(tour, "selecte-request-type", "For request type, choose \"RESTful\".", "");
            this.addStep4ClickOK(tour, "click-ok", "Then, click [OK].", "");
            this.addStep5SelectRequestMethod(tour, "select-request-method", "Good job! You've created a new web service request under the Object Repository.\r\n\r\nNow, let's choose a request method. There's a lot to choose from, but we'll go with \"POST\" for now.", "");
            this.addStep6InputUrl(tour, "set-input-url", "In this box, you will need to input the API endpoint for configuration. Let's use this demo endpoint here.", "");
            this.addStep7BasicAuthorization(tour, "select-basic-auth-type", "Next step, authorization. Let's try the \"Basic\" authentication this time. This is the simplest authorization for a request.", "");
            this.addStep8InputCredential(tour, "input-credential", "With basic credentials, you will need to input your credentials to authenticate the request. We have already filled in our demo credentials for you.", "");
            this.addStep9UpdateToHeader(tour, "update-to-header", "These credentials will be encoded into the Authorization request headers.\r\n\r\nDon't forget to update this configuration to make it effective. Click on [Update to HTTP Header].", "");
            this.addStep10OpenHeaderTab(tour, "open-header-tab", "Great! Now, let's switch to the HTTP Header tab.", "");
            this.addStep11ViewRequestHeaders(tour, "view-request-headers", "Here is where you can add more headers to your request. For now, just leave it as it is.", "");
            this.addStep12OpenBodyTab(tour, "open-body-tab", "Next, let's explore the HTTP Body tab.", "");
            this.addStep13ViewRequestBody(tour, "view-request-body", "The request body is the main data that you can send along with the request.\r\nWe have already filled out a sample request body with the JSON type here for you.", "");
            this.addStep14TestRequest(tour, "test-request", "The request is looking good now. Let's send it by clicking on this button.", "");
            this.addStep15CheckResult(tour, "check-result", "After you send the request, the response displays here.", "");
            this.addStep16AddToTestCase(tour, "add-to-test-case", "Great! You've learned how to configure and send an API request.\r\n\r\nNow it's time to add this request to a new test case.\r\n\r\nClick on this button.", "");
            this.addStep17InputTestCaseName(tour, "input-test-case-name", "Give your test case a name.", "");
            this.addStep18CreateTestCase(tour, "click-ok", "And click [OK].", "");
            this.addStep19ViewTestCaseEditor(tour, "view-test-case-editor", "Voil\u00e0! You've just created a new test case. Here is the editor view, where you can design your test in more detail.", "");
            this.addStep20MoveToScriptView(tour, "move-to-script-view", "Let's check the \"Script\" tab.", "");
            this.addStep21IntroScriptView(tour, "intro-script-view", "The script view is where you can program your test at the script level.", "");
            this.addStep22AddVerificationScript(tour, "add-verification-script", "Here, you can add some more scripts to verify the response returned from the server.", "");
            this.addStep23RunTestCase(tour, "run-test-case", "Now, let's try to run this test.", "");
            this.addStep24WaitForLauncher(tour, "wait-for-launcher", "", "");
            this.addStep25CheckTheResult(tour, "check-the-result", "Okay, your test has been completed.\r\n\r\nLet's check the result to see if the request passed.", "");
            this.addStep26OpenImporter(tour, "open-importer", "Great! You've done the main part of this tour. But wait, there's more. How do we import requests from another source?\r\n\r\nFrom this dropdown menu, let's select \"Import OpenAPI 2 (Swagger)\".", "");
            this.addStep27InputFileLocation(tour, "input-file-location", "Here is where you can input your API package file location. For this tour, we will use this sample file.", "");
            this.addStep28StartImport(tour, "start-importing", "To start importing, click [OK].", "");
            this.addStep29OpenAPI(tour, "open-request", "Great! You've just imported an API package to the Object Repository. Now let's open it up and see what it looks like.\r\nDouble-click on this.", "");
            this.addStep30ShowAPIEditor(tour, "show-request-editor", "You see, everything is just like what you already learned, except they were imported from your current working environments like Postman, SoapUl or Swagger files.", "");
            tour.onEnd(() -> {
                Text urlInput;
                Trackings.trackTourAction((String)tour.getType().name(), (String)TourAction.END.name());
                DialogUtil.close((Shell)this.mainOverlay);
                Shell importDialog = ComponentFinder.findShell((String)IMPORT_SWAGGER_DIALOG_TITLE);
                DialogUtil.setCanCloseAndClickOK((Shell)importDialog, (boolean)true);
                Button cancelButton = (Button)ComponentFinder.findByTypeAndText((Widget)importDialog, Button.class, (String)GlobalStringConstants.DIA_CANCEL);
                ControlUtil.setEnabled((Control)cancelButton, (boolean)true);
                Text fileUrlInput = (Text)ComponentFinder.findByType((Widget)importDialog, Text.class);
                ControlUtil.setEnabled((Control)fileUrlInput, (boolean)true);
                Shell newApiDialog = ComponentFinder.findShell((String)"New");
                DialogUtil.setCanCloseAndClickOK((Shell)newApiDialog, (boolean)true);
                Button cancelButton1 = (Button)ComponentFinder.findByTypeAndText((Widget)newApiDialog, Button.class, (String)GlobalStringConstants.DIA_CANCEL);
                ControlUtil.setEnabled((Control)cancelButton1, (boolean)true);
                Table headerTable = (Table)ComponentFinder.findByType((Widget)this.headerTabContent, Table.class);
                ControlUtil.setEnabled((Control)headerTable, (boolean)true);
                Composite bodyTabInnerContent = (Composite)ComponentFinder.findByType((Widget)this.bodyTabContent, Composite.class);
                ControlUtil.recursiveSetEnabled((Widget)bodyTabInnerContent, (boolean)true);
                Label usernameLabel = (Label)ComponentFinder.findByTypeAndText((Widget)this.requestEditor, Label.class, (String)"Username");
                if (!ControlUtil.isDisposed((Widget)usernameLabel)) {
                    ControlUtil.recursiveSetEnabled((Widget)usernameLabel.getParent(), (boolean)true);
                }
                if (!ControlUtil.isDisposed((Widget)(urlInput = (Text)ComponentSelector.from((Widget)this.requestMethodCCombo).nextElementSibling().get()))) {
                    ControlUtil.setEnabled((Control)urlInput, (boolean)true);
                }
                if (tour.isSkipped() || !tour.isTerminated()) {
                    UserProfile curProfile = UserProfileHelper.getCurrentProfile();
                    curProfile.addCompletedTour(tour.getType().name());
                    curProfile.addCompletedTour(QuickStartTourType.GENERIC_TESTING.name());
                    UserProfileHelper.saveProfile((UserProfile)curProfile);
                    TourEventBroker.refreshPageAfterCompletedTour(QuickStartTourType.TEST_PLANNING);
                    if (tour.isSkipped()) {
                        return;
                    }
                }
                if (!tour.isTerminated()) {
                    new OpenQuickStartOverviewHandler().execute(tour.getType(), QuickStartTourType.TEST_PLANNING);
                }
            });
            tour.start();
        });
    }

    private void addStep1CreateAnApiManually(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            this.mainOverlay = APITestingTourHandler.createOverlay();
            this.mainOverlay.open();
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> ComponentFinder.findByText((Widget)mainShell, (String)"Object Repository");
        stepInfo.keepOverlay = true;
        stepInfo.waitToEnd = timer -> {
            Shell newRequestShell = ComponentFinder.findShell((String)"New");
            return ComponentFinder.findByText((Widget)newRequestShell, (String)"Web Service Request") != null;
        };
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep2InputApiName(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ComponentFinder.findShell((String)"New");
        stepInfo.setupDialog = dialog -> {
            DialogUtil.setCanCloseAndClickOK((Shell)dialog, (boolean)false);
            Button cancelButton = (Button)ComponentFinder.findByTypeAndText((Widget)dialog, Button.class, (String)"Cancel");
            ControlUtil.setEnabled((Control)cancelButton, (boolean)false);
            Text requestNameInput = (Text)ComponentFinder.findByType((Widget)dialog, Text.class);
            this.customRequestName = requestNameInput.getText();
            ComponentEventUtil.onChange((Control)requestNameInput, event -> {
                this.customRequestName = requestNameInput.getText();
            });
        };
        stepInfo.targetFinder = dialog -> ComponentFinder.findByTypeAndText((Widget)dialog, Text.class, (String)"/.*/");
        stepInfo.nextable = true;
        stepInfo.keepOverlay = true;
        stepInfo.afterStep = () -> {
            this.newRequestOverlay = stepInfo.overlay;
        };
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep3SelectRequestType(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.newRequestOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ComponentFinder.findShell((String)"New");
        stepInfo.setupDialog = dialog -> {
            this.requestTypeCombo = (Combo)ComponentFinder.findByType((Widget)dialog, Combo.class);
            this.requestTypeCombo.select(0);
            ComponentEventUtil.onSelection((Widget)this.requestTypeCombo, event -> {
                String selection = this.requestTypeCombo.getItem(this.requestTypeCombo.getSelectionIndex());
                if (StringUtils.equals((CharSequence)selection, (CharSequence)"RESTful")) {
                    apiTestingTour.next();
                }
            });
        };
        stepInfo.targetFinder = parentShell -> ComponentFinder.findByType((Widget)parentShell, Combo.class);
        stepInfo.nextable = false;
        stepInfo.keepOverlay = true;
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep4ClickOK(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.newRequestOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ComponentFinder.findShell((String)"New");
        stepInfo.setupDialog = dialog -> DialogUtil.setCanClickOK((Shell)dialog, (boolean)true);
        stepInfo.targetFinder = parentShell -> ComponentFinder.findByTypeAndText((Widget)parentShell, Button.class, (String)GlobalStringConstants.DIA_OK);
        stepInfo.triggerWhenClickTarget = true;
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep5SelectRequestMethod(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> {
            Composite editorPartStack = (Composite)KatalonPartHelper.getEditorPartStack().getWidget();
            String editorTabNamePattern = MessageFormat.format("/.*{0}/", Pattern.quote(this.customRequestName));
            this.requestEditor = (Composite)ComponentFinder.findByTypeAndText((Widget)editorPartStack, Composite.class, (String)editorTabNamePattern);
            if (this.requestEditor == null) {
                return null;
            }
            return ShellManager.getMainShell();
        };
        stepInfo.targetFinder = parentShell -> {
            this.requestMethodCCombo = (CCombo)ComponentFinder.findByTypeAndText((Widget)this.requestEditor, CCombo.class, (String)"GET");
            return this.requestMethodCCombo;
        };
        stepInfo.keepOverlay = true;
        stepInfo.waitToEnd = timer -> StringUtils.equals((CharSequence)ComponentDataUtil.getAnyText((Widget)this.requestMethodCCombo), (CharSequence)"POST");
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep6InputUrl(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = parentShell -> {
            Text urlInput = (Text)ComponentSelector.from((Widget)this.requestMethodCCombo).nextElementSibling().get();
            urlInput.setText("http://jira-demo.katalon.com:8080/rest/api/2/issue/");
            ControlUtil.setEnabled((Control)urlInput, (boolean)false);
            return urlInput;
        };
        stepInfo.keepOverlay = true;
        stepInfo.nextable = true;
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep7BasicAuthorization(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = parentShell -> {
            this.authorizationTypeCCombo = (CCombo)ComponentFinder.findByTypeAndText((Widget)this.requestEditor, CCombo.class, (String)"No Authorization");
            return this.authorizationTypeCCombo;
        };
        stepInfo.keepOverlay = true;
        stepInfo.waitToEnd = timer -> StringUtils.equals((CharSequence)ComponentDataUtil.getAnyText((Widget)this.authorizationTypeCCombo), (CharSequence)"Basic");
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep8InputCredential(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = parentShell -> {
            Label usernameLabel = (Label)ComponentFinder.findByTypeAndText((Widget)this.requestEditor, Label.class, (String)"Username");
            ControlUtil.recursiveSetEnabled((Widget)usernameLabel.getParent(), (boolean)false);
            Text usernameInput = (Text)ComponentSelector.from((Widget)usernameLabel).nextElementSibling().get();
            ComponentEventUtil.triggerModifyEvent((Widget)usernameInput, (String)"demo");
            Text passwordInput = (Text)ComponentSelector.from((Widget)usernameInput).nextElementSibling().nextElementSibling().get();
            ComponentEventUtil.triggerModifyEvent((Widget)passwordInput, (String)"demo123");
            return usernameLabel != null ? usernameLabel.getParent() : null;
        };
        stepInfo.keepOverlay = true;
        stepInfo.nextable = true;
        stepInfo.afterStep = () -> PartHelper.saveEditorPart(this.requestEditor);
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep9UpdateToHeader(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = parentShell -> {
            Button updateToHeaderButton = (Button)ComponentFinder.findByTypeAndText((Widget)this.requestEditor, Button.class, (String)"Update to HTTP Header");
            ComponentUtil.setVisible((Control)updateToHeaderButton.getParent(), (boolean)false);
            updateToHeaderButton.getParent().pack();
            ComponentUtil.setVisible((Control)updateToHeaderButton.getParent(), (boolean)true);
            return updateToHeaderButton;
        };
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.keepOverlay = true;
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep10OpenHeaderTab(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.setupDialog = parentShell -> {
            this.headerTabContent = (Composite)ComponentFinder.findByTypeAndText((Widget)this.requestEditor, Composite.class, (String)HTTP_HEADER);
        };
        stepInfo.targetFinder = parentShell -> ComponentFinder.findByTypeAndText((Widget)this.requestEditor, CTabItem.class, (String)HTTP_HEADER);
        stepInfo.waitToEnd = timer -> this.headerTabContent.getVisible();
        stepInfo.keepOverlay = true;
        stepInfo.afterStep = () -> PartHelper.saveEditorPart(this.requestEditor);
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep11ViewRequestHeaders(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = parentShell -> {
            Composite headerTab = (Composite)ComponentFinder.findByTypeAndText((Widget)this.requestEditor, Composite.class, (String)HTTP_HEADER);
            Table headerTable = (Table)ComponentFinder.findByType((Widget)headerTab, Table.class);
            UITimeUtil.setTimeout(() -> ControlUtil.setEnabled((Control)headerTable, (boolean)false), (long)1000L);
            return headerTable;
        };
        stepInfo.keepOverlay = true;
        stepInfo.nextable = true;
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep12OpenBodyTab(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.setupDialog = parentShell -> {
            this.bodyTabContent = (Composite)ComponentFinder.findByTypeAndText((Widget)this.requestEditor, Composite.class, (String)HTTP_BODY);
        };
        stepInfo.targetFinder = parentShell -> ComponentFinder.findByTypeAndText((Widget)this.requestEditor, CTabItem.class, (String)HTTP_BODY);
        stepInfo.waitToEnd = timer -> this.bodyTabContent.getVisible();
        stepInfo.keepOverlay = true;
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep13ViewRequestBody(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.setupDialog = parentShell -> {
            Button noneTypeRadio = (Button)ComponentFinder.findByTypeAndText((Widget)this.bodyTabContent, Button.class, (String)"none");
            ComponentEventUtil.triggerSelectionEvent((Widget)noneTypeRadio, (boolean)false);
            Button textTypeRadio = (Button)ComponentFinder.findByTypeAndText((Widget)this.bodyTabContent, Button.class, (String)"text");
            ComponentEventUtil.triggerSelectionEvent((Widget)textTypeRadio);
            Button jsonTypeRadio = (Button)ComponentFinder.findByTypeAndText((Widget)this.bodyTabContent, Button.class, (String)"JSON");
            ComponentEventUtil.triggerSelectionEvent((Widget)jsonTypeRadio);
            MirrorEditor bodyEditor = (MirrorEditor)ComponentFinder.findByType((Widget)this.bodyTabContent, MirrorEditor.class);
            bodyEditor.setText("{\r\n  \"fields\":{\r\n      \"project\": { \"key\": \"KT\"}, \r\n      \"issuetype\": {\"name\": \"Task\"},\r\n      \"summary\": \"Jira Ticket Summary\"\r\n   }  \r\n}");
            UITimeUtil.setTimeout(() -> {
                Composite bodyTabInnerContent = (Composite)ComponentFinder.findByType((Widget)this.bodyTabContent, Composite.class);
                ControlUtil.recursiveSetEnabled((Widget)bodyTabInnerContent, (boolean)false);
            }, (long)1000L);
        };
        stepInfo.targetFinder = parentShell -> ComponentFinder.findByType((Widget)this.bodyTabContent, Composite.class);
        stepInfo.keepOverlay = true;
        stepInfo.nextable = true;
        stepInfo.afterStep = () -> PartHelper.saveEditorPart(this.requestEditor);
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep14TestRequest(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = parentShell -> {
            this.testRequestButton = (ToolItem)ComponentFinder.findByTypeAndText((Widget)this.requestEditor, ToolItem.class, (String)"Test Request");
            ComponentUtil.removeToolItemMenu((Widget)this.testRequestButton);
            return this.testRequestButton;
        };
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.keepOverlay = true;
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep15CheckResult(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.setupDialog = parentShell -> {
            this.responsePart = (Composite)ComponentFinder.findByTypeAndText((Widget)this.requestEditor, Composite.class, (String)"Response");
        };
        stepInfo.targetFinder = parentShell -> {
            this.responsePart = (Composite)ComponentFinder.findByTypeAndText((Widget)this.requestEditor, Composite.class, (String)"Response");
            return this.responsePart;
        };
        stepInfo.keepOverlay = true;
        stepInfo.nextable = true;
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep16AddToTestCase(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = parentShell -> {
            ToolItem addToTestCaseButton = (ToolItem)ComponentFinder.findByTypeAndText((Widget)this.requestEditor, ToolItem.class, (String)"Add to new Test Case");
            ComponentUtil.removeToolItemMenu((Widget)addToTestCaseButton);
            return addToTestCaseButton;
        };
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.keepOverlay = true;
        stepInfo.afterStep = () -> {
            Object requestPart = PartHelper.getPartFromRenderer(this.requestEditor);
            WebServiceRequestEntity testObject = (WebServiceRequestEntity)ObjectUtil.getField((Object)requestPart, (String)"originalWsObject");
            this.testObjectId = testObject.getIdForDisplay();
        };
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep17InputTestCaseName(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ComponentFinder.findShell((String)"New");
        stepInfo.setupDialog = dialog -> {
            DialogUtil.setCanCloseAndClickOK((Shell)dialog, (boolean)false);
            Text testCaseNameInput = (Text)ComponentFinder.findByType((Widget)dialog, Text.class);
            this.testCaseName = testCaseNameInput.getText();
            ComponentEventUtil.onChange((Control)testCaseNameInput, event -> {
                this.testCaseName = testCaseNameInput.getText();
            });
        };
        stepInfo.targetFinder = mainShell -> ComponentFinder.findByType((Widget)mainShell, Text.class);
        stepInfo.keepOverlay = true;
        stepInfo.nextable = true;
        stepInfo.afterStep = () -> {
            this.newTestCaseOverlay = stepInfo.overlay;
        };
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep18CreateTestCase(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.newTestCaseOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ComponentFinder.findShell((String)"New");
        stepInfo.setupDialog = dialog -> {
            DialogUtil.setCanClickOK((Shell)dialog, (boolean)true);
            Text testCaseNameInput = (Text)ComponentFinder.findByType((Widget)dialog, Text.class);
            this.testCaseName = testCaseNameInput.getText();
        };
        stepInfo.targetFinder = mainShell -> ComponentFinder.findByTypeAndText((Widget)mainShell, Button.class, (String)GlobalStringConstants.DIA_OK);
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.keepOverlay = false;
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep19ViewTestCaseEditor(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> {
            Composite editorPartStack = (Composite)KatalonPartHelper.getEditorPartStack().getWidget();
            String editorTabNamePattern = MessageFormat.format("/.*{0}/", Pattern.quote(this.testCaseName));
            this.testCaseEditor = (Composite)ComponentFinder.findByTypeAndText((Widget)editorPartStack, Composite.class, (String)editorTabNamePattern);
            return this.testCaseEditor;
        };
        stepInfo.keepOverlay = true;
        stepInfo.nextable = true;
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep20MoveToScriptView(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> ComponentFinder.findByTypeAndText((Widget)this.testCaseEditor, CTabItem.class, (String)"/Script.*\\.groovy/");
        stepInfo.keepOverlay = true;
        stepInfo.waitToEnd = timer -> {
            this.scriptView = (Composite)ComponentFinder.findByTypeAndText((Widget)this.testCaseEditor, Composite.class, (String)"/Script.*\\.groovy/");
            return this.scriptView.isVisible();
        };
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep21IntroScriptView(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> this.scriptView;
        stepInfo.keepOverlay = true;
        stepInfo.nextable = true;
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep22AddVerificationScript(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.setupDialog = parentShell -> {
            StyledText scriptEditor = (StyledText)ComponentFinder.findByType((Widget)this.testCaseEditor, StyledText.class);
            String currentScript = scriptEditor.getText();
            currentScript = currentScript.replace("import internal.GlobalVariable as GlobalVariable", "import internal.GlobalVariable as GlobalVariable\r\n\r\nimport com.kms.katalon.core.testobject.ResponseObject // >> Remember to import ResponseObject to use this type in your script\r\n                                                      //    (You can place your cursor at the end of the ResponseObject below and then press [Ctrl] + [Space] to auto import)\r\n");
            String verifyScript = MessageFormat.format("// The below script demonstrates how to verify the response returned from the server.\r\n\r\nResponseObject response = WS.sendRequest(findTestObject(''{0}'')) // Get the response object\r\n\r\nWS.verifyResponseStatusCode(response, 201) // Then you can verify the HTTP status code to see if it was sent successfully\r\n\r\n", this.testObjectId);
            scriptEditor.setText(String.valueOf(currentScript) + verifyScript);
        };
        stepInfo.targetFinder = mainShell -> this.scriptView;
        stepInfo.keepOverlay = true;
        stepInfo.nextable = true;
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep23RunTestCase(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> ComponentFinder.findByTypeAndText((Widget)mainShell, ToolItem.class, (String)"/Run.*/");
        stepInfo.customClickHandler = event -> {
            if (event.detail == 4) {
                Widget runButton = ComponentFinder.findByTypeAndText((Widget)ShellManager.getMainShell(), ToolItem.class, (String)"/Run.*/");
                UITimeUtil.cancel((Timer)this.waitForRunMenuTimer);
                UITimeUtil.waitFor(timer -> {
                    this.waitForRunMenuTimer = timer;
                    return ComponentFinder.findByTypeAndText((Widget)runButton, Menu.class, (String)"Run") != null;
                }, () -> {
                    Menu runMenu = (Menu)ComponentFinder.findByTypeAndText((Widget)runButton, Menu.class, (String)"Run");
                    ComponentEventUtil.handleDropdownClick((Menu)runMenu, (Event)event, () -> apiTestingTour.next());
                }, (long)0L);
            }
        };
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.keepOverlay = true;
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep24WaitForLauncher(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.waitToStartTimeout = 0L;
        stepInfo.mainScript = () -> UITimeUtil.waitFor(timer -> LauncherManager.getInstance().isAnyLauncherRunning(), () -> apiTestingTour.next());
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep25CheckTheResult(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> (Composite)KatalonPartHelper.getConsolePartStack().getWidget();
        stepInfo.waitToStart = timer -> !LauncherManager.getInstance().isAnyLauncherRunning();
        stepInfo.waitToStartTimeout = 0L;
        stepInfo.guidingDialogPositionProvider = (shell, args) -> {
            Rectangle dialogArea = (Rectangle)args[1];
            Rectangle targetArea = (Rectangle)args[2];
            return new Point(targetArea.x + targetArea.width - dialogArea.width - 8, targetArea.y + targetArea.height - dialogArea.height - 8);
        };
        stepInfo.nextable = true;
        stepInfo.keepOverlay = true;
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep26OpenImporter(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> ComponentFinder.findByTypeAndText((Widget)mainShell, ToolItem.class, (String)"Import OpenAPI");
        stepInfo.keepOverlay = true;
        stepInfo.waitToEnd = timer -> {
            Shell newTestSuiteShell = ComponentFinder.findShell((String)IMPORT_SWAGGER_DIALOG_TITLE);
            return newTestSuiteShell != null;
        };
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep27InputFileLocation(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ComponentFinder.findShell((String)IMPORT_SWAGGER_DIALOG_TITLE);
        stepInfo.setupDialog = dialog -> {
            DialogUtil.setCanCloseAndClickOK((Shell)dialog, (boolean)false);
            Button cancelButton = (Button)ComponentFinder.findByTypeAndText((Widget)dialog, Button.class, (String)GlobalStringConstants.DIA_CANCEL);
            ControlUtil.setEnabled((Control)cancelButton, (boolean)false);
            Text input = (Text)ComponentFinder.findByTypeAndText((Widget)dialog, Text.class, (String)"/.*/");
            if (input != null) {
                input.setText(SAMPLE_SWAGGER_FILE);
                input.setEnabled(false);
            }
        };
        stepInfo.targetFinder = dialog -> ComponentFinder.findByTypeAndText((Widget)dialog, Text.class, (String)"/.*/");
        stepInfo.afterStep = () -> {
            this.importRequestsOverlay = stepInfo.overlay;
        };
        stepInfo.keepOverlay = true;
        stepInfo.nextable = true;
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep28StartImport(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.importRequestsOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ComponentFinder.findShell((String)IMPORT_SWAGGER_DIALOG_TITLE);
        stepInfo.setupDialog = dialog -> DialogUtil.setCanClickOK((Shell)dialog, (boolean)true);
        stepInfo.targetFinder = parentShell -> ComponentFinder.findByTypeAndText((Widget)parentShell, Button.class, (String)GlobalStringConstants.DIA_OK);
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.customClickHandler = event -> {
            TreeItem sampleRequest = (TreeItem)ComponentFinder.findByTypeAndText((Widget)ShellManager.getMainShell(), TreeItem.class, (String)SAMPLE_REQUEST_NAME);
            ControlUtil.dispose((Widget)sampleRequest);
        };
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep29OpenAPI(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> ComponentFinder.findByTypeAndText((Widget)ShellManager.getMainShell(), TreeItem.class, (String)SAMPLE_REQUEST_NAME);
        stepInfo.waitToStart = timer -> {
            TreeItem sampleRequest = (TreeItem)ComponentFinder.findByTypeAndText((Widget)ShellManager.getMainShell(), TreeItem.class, (String)SAMPLE_REQUEST_NAME);
            return !ControlUtil.isDisposed((Widget)sampleRequest);
        };
        stepInfo.waitToEnd = timer -> {
            Composite editorPart = (Composite)KatalonPartHelper.getEditorPartStack().getWidget();
            return ComponentFinder.findByTypeAndText((Widget)editorPart, Composite.class, (String)SAMPLE_REQUEST_NAME) != null;
        };
        stepInfo.keepOverlay = true;
        stepInfo.afterStep = () -> {
            this.newRequestOverlay = stepInfo.overlay;
        };
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private void addStep30ShowAPIEditor(KatalonTour apiTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> (Composite)KatalonPartHelper.getEditorPartStack().getWidget();
        stepInfo.nextable = true;
        stepInfo.keepOverlay = true;
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
        };
        stepInfo.guidingDialogPositionProvider = (shell, args) -> {
            Rectangle bestArea = (Rectangle)args[0];
            Rectangle dialogArea = (Rectangle)args[1];
            return new Point(bestArea.x + 8, bestArea.y - dialogArea.height - ComponentUtil.applyZoom((int)10));
        };
        APITestingTourHandler.createStep(apiTestingTour, stepInfo);
    }

    private static void createStep(KatalonTour testPlanningTour, StepInfo stepInfo) {
        testPlanningTour.addStep(new GeneralTourStep(testPlanningTour, stepInfo));
    }

    private static HighlightOverlay createOverlay() {
        HighlightOverlay overlay = new HighlightOverlay((Control)ShellManager.getMainShell());
        overlay.setAlpha(20);
        ComponentEventUtil.onClick((Widget)overlay, event -> {
            if (event.count == 5) {
                overlay.close();
                Trackings.trackTourAction((String)QuickStartTourType.API_TESTING.name(), (String)TourAction.BROKEN.name());
            }
        });
        return overlay;
    }
}

