/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.tour;

import com.kms.katalon.addons.QuickStartController;
import com.kms.katalon.application.KatalonApplicationActivator;
import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.composer.components.util.UITimeUtil;
import com.kms.katalon.composer.handlers.OpenQuickStartOverviewHandler;
import com.kms.katalon.composer.tour.KatalonTour;
import com.kms.katalon.composer.tour.QuickStartTourType;
import com.kms.katalon.composer.tour.TourAction;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.TourEventBroker;
import java.text.MessageFormat;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;

public class AnalyzeTestingTourHandler {
    @Execute
    public void execute() {
        UISynchronizeService.asyncExec(() -> {
            boolean teamAndProjectNotNull;
            KatalonTour tour = new KatalonTour(QuickStartTourType.ANALYZE_TEST_ACTIVITIES);
            AnalyticsSettingStore store = AnalyticsSettingStore.getStore();
            if (!store.isIntegrationEnabled()) {
                KatalonApplicationActivator.getTestOpsConfiguration().testOpsQuickIntergration(null);
            }
            boolean bl = teamAndProjectNotNull = store.getTeam() != null && store.getProject() != null;
            if (teamAndProjectNotNull) {
                String url = MessageFormat.format("{0}/team/{1}/project/{2}/overview", TestOpsService.getInstance().getTestOpsServer(), store.getTeam().getId().toString(), store.getProject().getId().toString());
                Program.launch((String)url);
            }
            tour.onEnd(() -> {
                if (!tour.isTerminated() && !tour.isSkipped()) {
                    UITimeUtil.waitFor(timer -> {
                        Shell dialog = ShellManager.getTestOpsInterationDialog();
                        return dialog == null || dialog.isDisposed();
                    }, () -> Trackings.trackTourAction((String)tour.getType().name(), (String)TourAction.END.name()));
                }
                if (tour.isSkipped() || !tour.isTerminated()) {
                    if (teamAndProjectNotNull) {
                        UserProfile curProfile = UserProfileHelper.getCurrentProfile();
                        curProfile.addCompletedTour(tour.getType().name());
                        UserProfileHelper.saveProfile((UserProfile)curProfile);
                        TourEventBroker.refreshPageAfterCompletedTour(QuickStartTourType.TEST_CLOUD_TESTING);
                    }
                    if (tour.isSkipped()) {
                        return;
                    }
                }
                if (!tour.isTerminated() && teamAndProjectNotNull) {
                    QuickStartTourType tourType = QuickStartController.getCurrentTourTypeFromQuickStartPart();
                    new OpenQuickStartOverviewHandler().execute(tourType, QuickStartTourType.ANALYZE_TEST_ACTIVITIES, QuickStartTourType.TEST_CLOUD_TESTING);
                }
            });
            tour.start();
        });
    }
}

