/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.tour;

import com.kms.katalon.addons.QuickStartController;
import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.application.utils.LicenseUtil;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.overlay.HighlightOverlay;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentFinder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.composer.components.util.UITimeUtil;
import com.kms.katalon.composer.handlers.OpenQuickStartOverviewHandler;
import com.kms.katalon.composer.helpers.KatalonPartHelper;
import com.kms.katalon.composer.tour.GeneralTourStep;
import com.kms.katalon.composer.tour.KatalonTour;
import com.kms.katalon.composer.tour.QuickStartTourType;
import com.kms.katalon.composer.tour.StepInfo;
import com.kms.katalon.composer.tour.TourAction;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.dal.fileservice.manager.EntityFileServiceManager;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.TourEventBroker;
import java.io.File;
import java.nio.file.Paths;
import java.util.Timer;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class BDDTestingRunTourHandler {
    private HighlightOverlay mainOverlay;
    private Timer waitForRunMenuTimer;
    private TestCaseEntity testCaseEntity;
    private IEventBroker eventBroker;
    private Rectangle rectInputCell;

    @Execute
    public void execute() {
        UISynchronizeService.asyncExec(() -> {
            KatalonTour tour = new KatalonTour(QuickStartTourType.BDD_TESTING_ADDING_TO_TEST_CASE);
            this.beforeStartTour();
            this.addStep1ViewTestCaseFolder(tour, "introduce-test-case-folder", "To create a new test case, in the [Test Cases] folder, right-click > [New] > [Test case].\r\n\nFor now, let's open one of our sample test cases.", "");
            this.addStep2AddNewStep(tour, "introduce-add-button", "You can verify a feature file in a test case by using our built-in Cucumber keywords. You can always add steps by clicking this button in the [Manual] view.", "");
            this.addStep3MapFeatureFile(tour, "introduce-input-for-feature-file", "After adding the steps, the feature files can be mapped by double-clicking the [Input] column.", "");
            this.addStep4RunTestCase(tour, "introduce-run-test-case-button", "That will be it for now, try running this test case by clicking [Run].", "");
            this.addStep5CheckLogViewer(tour, "show-results", "Okay, it's done! Let's check the result to make sure that all the tests were passed!", "");
            tour.onEnd(() -> {
                Trackings.trackTourAction((String)tour.getType().name(), (String)TourAction.END.name());
                DialogUtil.close((Shell)this.mainOverlay);
                DialogUtil.setCanCloseAndClickOK((Shell)ShellManager.getWebRecorderDialog(), (boolean)true);
                DialogUtil.setCanCloseAndClickOK((Shell)ShellManager.getTestCaseSavingDialog(), (boolean)true);
                DialogUtil.setCanCloseAndClickOK((Shell)ShellManager.getTestObjectsSavingDialog(), (boolean)true);
                if (tour.isSkipped() || !tour.isTerminated()) {
                    UserProfile curProfile = UserProfileHelper.getCurrentProfile();
                    curProfile.addCompletedTour(QuickStartTourType.BDD_TESTING_ADDING_TO_TEST_CASE.name());
                    curProfile.addCompletedTour(QuickStartTourType.GENERIC_TESTING.name());
                    UserProfileHelper.saveProfile((UserProfile)curProfile);
                    TourEventBroker.refreshPageAfterCompletedTour(QuickStartTourType.TEST_PLANNING);
                    if (tour.isSkipped()) {
                        return;
                    }
                }
                if (!tour.isTerminated()) {
                    QuickStartTourType tourType = QuickStartController.getCurrentTourTypeFromQuickStartPart();
                    new OpenQuickStartOverviewHandler().execute(tourType, QuickStartTourType.BDD_TESTING_ADDING_TO_TEST_CASE, QuickStartTourType.TEST_PLANNING);
                }
            });
            tour.start();
        });
    }

    private void addStep1ViewTestCaseFolder(KatalonTour webTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> ComponentFinder.findByText((Widget)mainShell, (String)"Test Cases");
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.nextable = true;
        stepInfo.keepOverlay = true;
        stepInfo.beforeStep = () -> {
            this.mainOverlay = BDDTestingRunTourHandler.createOverlay();
            this.mainOverlay.open();
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        BDDTestingRunTourHandler.createStep(webTestingTour, stepInfo);
    }

    private void addStep2AddNewStep(KatalonTour webTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> ComponentFinder.findByTypeAndText((Widget)mainShell, ToolItem.class, (String)"Add");
        stepInfo.nextable = true;
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.keepOverlay = true;
        BDDTestingRunTourHandler.createStep(webTestingTour, stepInfo);
    }

    private void addStep3MapFeatureFile(KatalonTour webTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> {
            CTabFolder editorPartStack = (CTabFolder)KatalonPartHelper.getEditorPartStack().getWidget();
            Tree tree = (Tree)ComponentFinder.findAllByType((Widget)editorPartStack, Tree.class).get(0);
            return tree.getItem(0);
        };
        stepInfo.highlightAreaProvider = (target, parentShell) -> {
            Rectangle targetArea = ComponentUtil.getScreenArea((Widget)target, (Control)parentShell);
            this.rectInputCell = ((TreeItem)target).getBounds(2);
            targetArea.x += this.rectInputCell.x;
            targetArea.width = this.rectInputCell.width;
            return targetArea;
        };
        stepInfo.guidingDialogPositionProvider = (shell, args) -> {
            Rectangle bestArea = (Rectangle)args[0];
            int x = (int)((double)this.rectInputCell.x + (double)this.rectInputCell.width * 1.7);
            return new Point(x, bestArea.y);
        };
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.keepOverlay = true;
        stepInfo.nextable = true;
        BDDTestingRunTourHandler.createStep(webTestingTour, stepInfo);
    }

    private void addStep4RunTestCase(KatalonTour webTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> ComponentFinder.findByTypeAndText((Widget)mainShell, ToolItem.class, (String)"/Run.*/");
        stepInfo.customClickHandler = event -> {
            if (event.detail == 4) {
                Widget runButton = ComponentFinder.findByTypeAndText((Widget)ShellManager.getMainShell(), ToolItem.class, (String)"/Run.*/");
                UITimeUtil.cancel((Timer)this.waitForRunMenuTimer);
                UITimeUtil.waitFor(timer -> {
                    this.waitForRunMenuTimer = timer;
                    return ComponentFinder.findByTypeAndText((Widget)runButton, Menu.class, (String)"Run") != null;
                }, () -> {
                    Menu runMenu = (Menu)ComponentFinder.findByTypeAndText((Widget)runButton, Menu.class, (String)"Run");
                    ComponentEventUtil.handleDropdownClick((Menu)runMenu, (Event)event, () -> webTestingTour.next());
                }, (long)0L);
            }
        };
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.keepOverlay = true;
        BDDTestingRunTourHandler.createStep(webTestingTour, stepInfo);
    }

    private void addStep5CheckLogViewer(KatalonTour webTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> (Composite)KatalonPartHelper.getConsolePartStack().getWidget();
        stepInfo.waitToStart = timer -> !LauncherManager.getInstance().isAnyLauncherRunning();
        stepInfo.waitToStartTimeout = 0L;
        stepInfo.guidingDialogPositionProvider = (shell, args) -> {
            Rectangle dialogArea = (Rectangle)args[1];
            Rectangle targetArea = (Rectangle)args[2];
            return new Point(targetArea.x + targetArea.width - dialogArea.width - 8, targetArea.y + targetArea.height - dialogArea.height - 8);
        };
        stepInfo.keepOverlay = true;
        stepInfo.nextable = true;
        if (LicenseUtil.isFreeLicense() && SystemUtils.IS_OS_LINUX) {
            stepInfo.blockingUI = false;
        }
        BDDTestingRunTourHandler.createStep(webTestingTour, stepInfo);
    }

    private void beforeStartTour() {
        this.eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
        this.eventBroker.post("EXPLORER/COLLAPSE_ALL_ITEMS", null);
        try {
            this.openTestCase();
            this.expandTrees();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openTestCase() throws ControllerException {
        this.testCaseEntity = TestCaseController.getInstance().getTestCaseByDisplayId("Test Cases/operations/Verify Divide");
        this.eventBroker.post("TESTCASE/OPEN", (Object)this.testCaseEntity);
    }

    private void expandTrees() throws Exception {
        Widget component = ComponentFinder.findByText((Widget)ShellManager.getMainShell(), (String)"Verify Divide");
        if (component != null && component instanceof TreeItem) {
            return;
        }
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        FolderTreeEntity testCaseTreeEntity = new FolderTreeEntity(FolderController.getInstance().getTestCaseRoot(projectEntity), null);
        this.eventBroker.post("EXPLORER/EXPAND_TREE_ENTITY", (Object)testCaseTreeEntity);
        String path = Paths.get(projectEntity.getFolderLocation(), "/Test Cases/operations").toString();
        FolderTreeEntity subFolderTreeEntity = new FolderTreeEntity(EntityFileServiceManager.getFolder((File)new File(path)), null);
        this.eventBroker.post("EXPLORER/EXPAND_TREE_ENTITY", (Object)subFolderTreeEntity);
    }

    private static HighlightOverlay createOverlay() {
        HighlightOverlay overlay = new HighlightOverlay((Control)ShellManager.getMainShell());
        overlay.setAlpha(20);
        ComponentEventUtil.onClick((Widget)overlay, event -> {
            if (event.count == 5) {
                overlay.close();
                Trackings.trackTourAction((String)QuickStartTourType.BDD_TESTING_ADDING_TO_TEST_CASE.name(), (String)TourAction.BROKEN.name());
            }
        });
        return overlay;
    }

    private static void createStep(KatalonTour testPlanningTour, StepInfo stepInfo) {
        testPlanningTour.addStep(new GeneralTourStep(testPlanningTour, stepInfo));
    }
}

