/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.tour;

import com.kms.katalon.activation.dialog.ChooseTestingTypeForGenericProjectDialog;
import com.kms.katalon.activation.dialog.SaveProjectBeforeCloningBDDSampleDialog;
import com.kms.katalon.composer.components.services.PartServiceSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.handlers.OpenQuickStartPageHandler;
import com.kms.katalon.composer.tour.KatalonTour;
import com.kms.katalon.composer.tour.QuickStartTourType;
import com.kms.katalon.composer.tour.TourAction;
import com.kms.katalon.entity.project.QuickStartProjectType;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.ComposerActivationInfoCollector;
import com.kms.katalon.util.TourEventBroker;
import com.kms.katalon.util.TourUtil;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.widgets.Shell;

public class GenericTestingTourHandler {
    @Execute
    public void execute() {
        UISynchronizeService.asyncExec(() -> {
            KatalonTour tour = new KatalonTour(QuickStartTourType.GENERIC_TESTING);
            ChooseTestingTypeForGenericProjectDialog dialog = new ChooseTestingTypeForGenericProjectDialog(new Shell());
            if (dialog.open() == 1) {
                QuickStartProjectType chosenTestingType = dialog.getChosenTestingType();
                boolean cloneSuccess = true;
                if (chosenTestingType == QuickStartProjectType.BDD) {
                    int agreeCloneBDDSample = new SaveProjectBeforeCloningBDDSampleDialog(null).open();
                    switch (agreeCloneBDDSample) {
                        case 1: {
                            boolean isSaved = PartServiceSingleton.getInstance().getPartService().saveAll(true);
                            if (isSaved) break;
                            return;
                        }
                        case 0: {
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                    try {
                        cloneSuccess = ComposerActivationInfoCollector.quickCreateFirstBDDSampleProject();
                    }
                    catch (Exception e) {
                        LogUtil.logError((Throwable)e);
                    }
                }
                if (cloneSuccess) {
                    TourUtil.setIsUsingBDDSampleProject(true);
                    new OpenQuickStartPageHandler().execute(chosenTestingType);
                    TourEventBroker.refreshPageAfterCompletedTour(TourUtil.getProjectTourType(chosenTestingType));
                    return;
                }
            }
            tour.onEnd(() -> Trackings.trackTourAction((String)tour.getType().name(), (String)TourAction.END.name()));
            tour.start();
        });
    }
}

