/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.tour;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.composer.components.impl.overlay.HighlightOverlay;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentFinder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.composer.tour.GeneralTourStep;
import com.kms.katalon.composer.tour.KatalonTour;
import com.kms.katalon.composer.tour.QuickStartTourType;
import com.kms.katalon.composer.tour.StepInfo;
import com.kms.katalon.controller.ProjectController;
import java.text.MessageFormat;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class IntroduceStudioAssistHandler {
    private HighlightOverlay mainOverlay = null;
    private String STUDIOASSIST_DOCUMENT_URL = "https://docs.katalon.com/docs/proof-of-concept/studioassist-in-katalon-studio";
    private String title = "Hi {0}! Meet StudioAssist, your AI assistant for simplified scripting and improved testing efficiency.";

    @Execute
    public void execute() {
        this.setupIntroduceStudioAssist();
    }

    private void setupIntroduceStudioAssist() {
        UISynchronizeService.asyncExec(() -> {
            if (ProjectController.getInstance().getCurrentProject() != null) {
                KatalonTour tour = new KatalonTour(QuickStartTourType.INTRODUCE_STUDIOASSIST);
                String firstName = ApplicationContext.getInstance().getUserFirstName();
                this.addStep1ClickOnStudioAssistIcon(tour, "click_studioassist_icon", MessageFormat.format(this.title, firstName), "");
                tour.onEnd(() -> {
                    DialogUtil.close((Shell)this.mainOverlay);
                    UserProfile curProfile = UserProfileHelper.getCurrentProfile();
                    curProfile.setNumberOfOpenTimes(curProfile.getNumberOfOpenTimes() + 1);
                    curProfile.addCompletedTour(tour.getType().name());
                    UserProfileHelper.saveProfile((UserProfile)curProfile);
                });
                tour.start();
            }
        });
    }

    private void addStep1ClickOnStudioAssistIcon(KatalonTour tour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> ComponentFinder.findByTypeAndText((Widget)mainShell, ToolItem.class, (String)"StudioAssist");
        stepInfo.blockingUI = false;
        stepInfo.nextable = true;
        stepInfo.nextButtonText = "Learn more here";
        stepInfo.hasActionBeforeClose = false;
        stepInfo.afterStep = () -> ComponentUtil.triggerLink((String)this.STUDIOASSIST_DOCUMENT_URL);
        stepInfo.waitToEnd = timer -> {
            Shell sh = ComponentFinder.findShell((String)"Preferences");
            return sh != null;
        };
        IntroduceStudioAssistHandler.createStep(tour, stepInfo);
    }

    private static void createStep(KatalonTour introduceStudioAssistTour, StepInfo stepInfo) {
        introduceStudioAssistTour.addStep(new GeneralTourStep(introduceStudioAssistTour, stepInfo));
    }
}

