/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.tour;

import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.tour.BaseSetUpInstructionDialog;
import com.kms.katalon.composer.tour.KatalonTour;
import com.kms.katalon.composer.tour.TourAction;
import com.kms.katalon.composer.tour.TourCancellationSurvey;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.webserver.WebViewController;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class KRESetUpInstructionDialog
extends BaseSetUpInstructionDialog {
    private Composite body;
    private String url;
    private String title = "Open Command Prompt for KRE execution";
    private boolean okClicked = false;
    private KatalonTour currentTour;

    public void setOkClicked(boolean state) {
        this.okClicked = state;
    }

    public KRESetUpInstructionDialog(Shell parentShell, String url) {
        super(parentShell);
        this.url = url;
    }

    @Override
    protected int getShellStyle() {
        return super.getShellStyle() | 0x4020;
    }

    @Override
    protected void createContent(Composite container) {
        this.body = (Composite)ComponentBuilder.gridContainer((Composite)container).minWidth(995).margin(0, 0, 0).marginLeft(15).build();
        this.createGuidings(this.body);
    }

    public void setDialogTitle(String dialogTitle) {
        this.title = dialogTitle;
    }

    public String getDialogTitle() {
        return this.title;
    }

    private void createGuidings(Composite parent) {
        WebViewController.getInstance().ensureStarted();
        Browser webview = (Browser)ComponentBuilder.browser((Composite)parent).defaultBrowserConfig().fill().minHeight(ComponentUtil.applyZoom((int)(SystemUtils.IS_OS_MAC ? 510 : 380))).minWidth(ComponentUtil.applyZoom((int)(SystemUtils.IS_OS_MAC ? 1300 : 960))).build();
        webview.setUrl(this.url);
    }

    @Override
    protected void adjustLayout() {
        ComponentUtil.adjustChildrenWidth((Composite)this.body);
        super.adjustLayout();
    }

    @Override
    public boolean close() {
        if (!this.okClicked) {
            TourCancellationSurvey tourCancellationSurveyDialog = new TourCancellationSurvey(this.getShell());
            int returnCode = tourCancellationSurveyDialog.open();
            if (returnCode == 0) {
                if (this.currentTour != null) {
                    Trackings.trackTourAction((String)this.currentTour.getType().name(), (String)TourAction.CONTINUE.name());
                }
                return false;
            }
            if (returnCode == 1) {
                if (this.currentTour != null) {
                    this.currentTour.finish();
                    Trackings.trackTourAction((String)this.currentTour.getType().name(), (String)TourAction.SKIP.name());
                }
                return super.close();
            }
            if (returnCode == 16) {
                if (this.currentTour != null) {
                    this.currentTour.stop();
                    Trackings.trackTourAction((String)this.currentTour.getType().name(), (String)TourAction.REMIND.name());
                }
                return super.close();
            }
        }
        return super.close();
    }

    @Override
    protected boolean isClosable() {
        return true;
    }

    public KatalonTour getCurrentTour() {
        return this.currentTour;
    }

    public void setCurrentTour(KatalonTour currentTour) {
        this.currentTour = currentTour;
    }
}

