/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.tour;

import com.kms.katalon.application.preference.TourStatusPreference;
import com.kms.katalon.composer.tour.KatalonTourStep;
import com.kms.katalon.composer.tour.QuickStartTourType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KatalonTour {
    private Map<Object, Object> data = new HashMap<Object, Object>();
    private List<KatalonTourStep> steps = new ArrayList<KatalonTourStep>();
    private KatalonTourStep curStep;
    private Runnable endListener;
    private boolean isTerminated;
    private boolean isSkipped;
    private QuickStartTourType type;
    private TourStatusPreference pref = new TourStatusPreference();

    public KatalonTour(QuickStartTourType type) {
        this.type = type;
    }

    public QuickStartTourType getType() {
        return this.type;
    }

    public void setType(QuickStartTourType type) {
        this.type = type;
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    public void setTerminated(boolean isTerminated) {
        this.isTerminated = isTerminated;
    }

    public boolean isSkipped() {
        return this.isSkipped;
    }

    public void setSkipped(boolean isSkipped) {
        this.isSkipped = isSkipped;
    }

    public Object getData(Object key) {
        return this.data.get(key);
    }

    public Object setData(Object key, Object value) {
        return this.data.put(key, value);
    }

    public List<KatalonTourStep> getSteps() {
        return this.steps;
    }

    public void setSteps(List<KatalonTourStep> steps) {
        this.steps = steps;
    }

    public void addStep(KatalonTourStep.StepListener step) {
        this.steps.add(new KatalonTourStep(step));
    }

    public void addStep(KatalonTourStep step) {
        this.steps.add(step);
    }

    public void start() {
        this.start(0);
    }

    public void start(int index) {
        this.setTerminated(false);
        this.setSkipped(false);
        this.pref.setIsInTour(true);
        if (index < 0 || index >= this.steps.size()) {
            this.notifyEnd();
            return;
        }
        KatalonTourStep firstStep = this.steps.get(index % this.steps.size());
        if (firstStep == null) {
            this.notifyEnd();
            return;
        }
        this.runStep(firstStep);
    }

    private void runStep(KatalonTourStep step) {
        this.curStep = step;
        if (step == null) {
            return;
        }
        step.setEnded(false);
        step.setInterupted(false);
        step.clearEndInternal();
        step.onEndInternal(stepz -> {
            boolean isLastStep;
            if (stepz.isInterupted()) {
                return;
            }
            boolean bl = isLastStep = this.getCurStepIndex() == this.steps.size() - 1;
            if (isLastStep) {
                this.notifyEnd();
                return;
            }
            this.runNextStep();
        });
        step.run();
    }

    private void runNextStep() {
        KatalonTourStep nextStep = this.getNextStep();
        this.runStep(nextStep);
    }

    public void next() {
        if (this.curStep != null) {
            this.curStep.next();
        }
    }

    public void back() {
        int curStepIndex = this.getCurStepIndex();
        if (this.curStep != null) {
            this.curStep.stop();
        }
        this.start(curStepIndex - 1);
    }

    private KatalonTourStep getNextStep() {
        int curStepIndex = this.getCurStepIndex();
        if (curStepIndex == this.steps.size()) {
            return null;
        }
        int nextStepIndex = (curStepIndex + 1) % this.steps.size();
        return this.steps.get(nextStepIndex);
    }

    public int getNumSteps() {
        return this.steps.size();
    }

    public int getCurStepIndex() {
        return this.curStep == null ? -1 : this.steps.indexOf(this.curStep);
    }

    public KatalonTourStep getCurStep() {
        return this.curStep;
    }

    public boolean isCurStep(KatalonTourStep step) {
        return step == this.curStep;
    }

    public void finish() {
        this.setSkipped(true);
        if (this.curStep != null) {
            this.curStep.stop();
        }
        this.notifyEnd();
    }

    public void stop() {
        this.setTerminated(true);
        if (this.curStep != null) {
            this.curStep.stop();
        }
        this.notifyEnd();
    }

    public void onEnd(Runnable callback) {
        this.endListener = callback;
    }

    public void notifyEnd() {
        this.pref.setIsInTour(false);
        if (this.endListener != null) {
            this.endListener.run();
        }
    }
}

