/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.tour;

import com.kms.katalon.composer.components.impl.overlay.HighlightOverlay;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentFinder;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.composer.components.util.UITimeUtil;
import com.kms.katalon.composer.tour.KatalonTour;
import com.kms.katalon.composer.tour.QuickStartTourType;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class KatalonWorkspaceTourHandler {
    @Execute
    public void execute() {
        UISynchronizeService.asyncExec(() -> {
            KatalonTour workspaceTour = new KatalonTour(QuickStartTourType.KATALON_WORKSPACE);
            HighlightOverlay overlay = this.createOverlay();
            this.addStep1Toolbar(workspaceTour, overlay);
            this.addStep2TestExplorer(workspaceTour, overlay);
            this.addStep3EditorView(workspaceTour, overlay);
            this.addStep4ResultView(workspaceTour, overlay);
            ComponentEventUtil.onClick((Widget)overlay, event -> workspaceTour.next());
            overlay.open();
            workspaceTour.start();
        });
    }

    private void addStep1Toolbar(KatalonTour workspaceTour, HighlightOverlay overlay) {
        Shell mainShell = ShellManager.getMainShell();
        workspaceTour.addStep(step -> {
            ToolItem buttonGit = (ToolItem)ComponentFinder.findByTypeAndText((Widget)mainShell, ToolItem.class, (String)"Git");
            if (buttonGit != null) {
                Composite toolbar = buttonGit.getParent().getParent();
                overlay.add((Widget)toolbar, false);
            }
            UITimeUtil.setTimeout(() -> {
                if (!workspaceTour.isCurStep(step) || overlay.isDisposed()) {
                    return;
                }
                if (buttonGit != null && buttonGit.getParent() != null) {
                    overlay.add((Widget)buttonGit.getParent(), "Katalon Plugins");
                }
            }, (long)100L);
            UITimeUtil.setTimeout(() -> {
                if (!workspaceTour.isCurStep(step) || overlay.isDisposed()) {
                    return;
                }
                ToolItem buttonRecordWeb = (ToolItem)ComponentFinder.findByTypeAndText((Widget)mainShell, ToolItem.class, (String)"Record Web");
                if (buttonRecordWeb != null && buttonRecordWeb.getParent() != null) {
                    overlay.add((Widget)buttonRecordWeb.getParent(), "Spy and Recorder Tools");
                }
            }, (long)1100L);
            UITimeUtil.setTimeout(() -> {
                if (!workspaceTour.isCurStep(step) || overlay.isDisposed()) {
                    return;
                }
                ToolItem buttonCLI = (ToolItem)ComponentFinder.findByTypeAndText((Widget)mainShell, ToolItem.class, (String)"Build CMD");
                if (buttonCLI != null && buttonCLI.getParent() != null) {
                    overlay.add((Widget)buttonCLI.getParent(), "Quick Actions");
                }
            }, (long)2100L);
        });
        workspaceTour.onEnd(() -> overlay.close());
    }

    private void addStep2TestExplorer(KatalonTour workspaceTour, HighlightOverlay overlay) {
        Shell mainShell = ShellManager.getMainShell();
        workspaceTour.addStep(step -> {
            Composite testExplorer = (Composite)ComponentFinder.findByText((Widget)mainShell, (String)"Tests Explorer");
            overlay.removeAll();
            overlay.add((Widget)testExplorer.getParent());
        });
    }

    private void addStep3EditorView(KatalonTour workspaceTour, HighlightOverlay overlay) {
        Shell mainShell = ShellManager.getMainShell();
        workspaceTour.addStep(step -> {
            Composite quickStart = (Composite)ComponentFinder.findByText((Widget)mainShell, (String)"Studio Walkthrough");
            overlay.removeAll();
            overlay.add((Widget)quickStart.getParent());
        });
    }

    private void addStep4ResultView(KatalonTour workspaceTour, HighlightOverlay overlay) {
        Shell mainShell = ShellManager.getMainShell();
        workspaceTour.addStep(step -> {
            Composite selfHealingInsights = (Composite)ComponentFinder.findByText((Widget)mainShell, (String)"Self-healing Insights");
            overlay.removeAll();
            overlay.add((Widget)selfHealingInsights.getParent());
        });
    }

    private HighlightOverlay createOverlay() {
        HighlightOverlay overlay = new HighlightOverlay((Control)ShellManager.getMainShell());
        ComponentEventUtil.onClick((Widget)overlay, event -> {
            event.widget.setData((Object)((event.widget.getData() != null ? (Integer)event.widget.getData() : 0) + 1));
            if (event.widget.getData() != null && (Integer)event.widget.getData() > 10) {
                overlay.close();
            }
        });
        return overlay;
    }
}

