/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.tour;

import com.kms.katalon.addons.QuickStartController;
import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentFinder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.handlers.OpenQuickStartPageHandler;
import com.kms.katalon.composer.tour.KRESetUpInstructionDialog;
import com.kms.katalon.composer.tour.QuickStartTourType;
import com.kms.katalon.composer.tour.TourAction;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.TourEventBroker;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Shell;

public class LearnMoreAboutCICDPipelineHandler {
    @Execute
    public void execute() {
        this.closeDialog();
        this.navigateToDocument();
    }

    private void closeDialog() {
        UISynchronizeService.asyncExec(() -> {
            Shell targetShell = ComponentFinder.findShell((String)"Open Command Prompt for KRE execution");
            if (targetShell.isVisible() && targetShell.getData() instanceof Dialog) {
                KRESetUpInstructionDialog dialog = (KRESetUpInstructionDialog)((Object)((Object)targetShell.getData()));
                dialog.setOkClicked(true);
            }
            DialogUtil.close((Shell)targetShell);
            targetShell = ComponentFinder.findShell((String)"Generate Command for Console Mode");
            DialogUtil.close((Shell)targetShell);
        });
    }

    private void navigateToDocument() {
        Trackings.trackTourStep((String)QuickStartTourType.SET_UP_KRE.name(), (String)"learn-more");
        QuickStartTourType quickStartTourType = QuickStartController.getCurrentTourTypeFromQuickStartPart();
        UserProfile curProfile = UserProfileHelper.getCurrentProfile();
        UISynchronizeService.syncExec(() -> {
            curProfile.addCompletedTour(QuickStartTourType.SET_UP_KRE.name());
            UserProfileHelper.saveProfile((UserProfile)curProfile);
            new OpenQuickStartPageHandler().execute(quickStartTourType);
            TourEventBroker.refreshPageAfterCompletedTour(QuickStartTourType.SET_UP_KRE);
            Trackings.trackTourAction((String)QuickStartTourType.SET_UP_KRE.name(), (String)TourAction.END.name());
        });
        ComponentUtil.triggerLink((String)DocumentationMessageConstants.LEARN_MORE_ABOUT_CI_CD_LINK);
    }
}

