/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.tour;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.preference.TourStatusPreference;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.overlay.HighlightOverlay;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentDataUtil;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentFinder;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.composer.components.util.UITimeUtil;
import com.kms.katalon.composer.handlers.OpenQuickStartOverviewHandler;
import com.kms.katalon.composer.project.dialog.NewProjectDialog;
import com.kms.katalon.composer.project.handlers.NewProjectHandler;
import com.kms.katalon.composer.tour.CreateFirstProjectNotificationDialog;
import com.kms.katalon.composer.tour.GeneralTourStep;
import com.kms.katalon.composer.tour.KatalonTour;
import com.kms.katalon.composer.tour.QuickStartTourType;
import com.kms.katalon.composer.tour.StepInfo;
import com.kms.katalon.composer.tour.TourAction;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.internal.NamingUtil;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.TourEventBroker;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class OpenFirstProjectTourHandler {
    private HighlightOverlay mainOverlay;
    private Shell newProjectDialogShell;
    private Canvas newProj = null;
    private String projectType = null;

    @Execute
    public void execute() {
        this.setupOpenFirstProject();
    }

    private void setupOpenFirstProject() {
        UISynchronizeService.asyncExec(() -> {
            if (ProjectController.getInstance().getCurrentProject() != null) {
                int acceptCloseCurrentProject = new CreateFirstProjectNotificationDialog(null).open();
                if (acceptCloseCurrentProject == 1) {
                    IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
                    eventBroker.send("PROJECT/CLOSE", null);
                } else {
                    return;
                }
            }
            KatalonTour tour = new KatalonTour(QuickStartTourType.CREATE_FIRST_PROJECT);
            this.addStep1ClickNewProjectButton(tour, "click_new_project_button", "First, click here to create a new project.", "");
            this.addStep2CreateNewProject(tour, "create_new_project_success", "Give your project a name and choose a project type. Then click [OK].", "");
            tour.onEnd(() -> {
                TourStatusPreference pref = new TourStatusPreference();
                DialogUtil.close((Shell)this.mainOverlay);
                if (!tour.isTerminated() && !tour.isSkipped()) {
                    pref.setIsInTour(true);
                    UITimeUtil.waitFor(timer -> {
                        Shell dialog = ComponentFinder.findShell((String)"New Project");
                        return dialog == null || dialog.isDisposed();
                    }, () -> {
                        Trackings.trackTourAction((String)tour.getType().name(), (String)TourAction.END.name());
                        new OpenQuickStartOverviewHandler().execute(this.convertTourTypeToQuickStartTourType(this.projectType), tour.getType(), this.convertTourTypeToQuickStartTourType(this.projectType));
                        pref.setIsInTour(false);
                    });
                }
                if (tour.isSkipped() || !tour.isTerminated()) {
                    UserProfile curProfile = UserProfileHelper.getCurrentProfile();
                    curProfile.addCompletedTour(tour.getType().name());
                    UserProfileHelper.saveProfile((UserProfile)curProfile);
                    TourEventBroker.refreshPageAfterCompletedTour(this.convertTourTypeToQuickStartTourType(this.projectType));
                    if (tour.isSkipped()) {
                        return;
                    }
                }
            });
            if (!this.isExplorerPartVisible()) {
                new NewProjectHandler().execute(ShellManager.getMainShell());
                tour.start(1);
            } else {
                tour.start();
            }
        });
    }

    private void addStep1ClickNewProjectButton(KatalonTour tour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            this.mainOverlay = OpenFirstProjectTourHandler.createOverlay();
            this.mainOverlay.open();
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> {
            Arrays.asList(ShellManager.getShells()).forEach(shell -> {
                List buttons = ComponentFinder.findAllByType((Widget)shell, Canvas.class);
                Optional<Canvas> optNewProj = buttons.stream().filter(button -> {
                    String text = ComponentDataUtil.getText((Widget)button);
                    return text.equals("New Project");
                }).findFirst();
                if (optNewProj.isPresent()) {
                    this.newProj = optNewProj.get();
                    return;
                }
            });
            return this.newProj;
        };
        stepInfo.keepOverlay = true;
        stepInfo.waitToEnd = timer -> {
            Shell sh = ComponentFinder.findShell((String)"New Project");
            return sh != null;
        };
        OpenFirstProjectTourHandler.createStep(tour, stepInfo);
    }

    private void addStep2CreateNewProject(KatalonTour tour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.waitToStart = timer -> {
            Shell sh = ComponentFinder.findShell((String)"New Project");
            return sh != null;
        };
        stepInfo.waitToStartTimeout = 0L;
        stepInfo.beforeStep = () -> {
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ComponentFinder.findShell((String)"New Project");
        stepInfo.setupDialog = dialogShell -> {
            this.newProjectDialogShell = dialogShell;
            DialogUtil.setCanClose((Shell)dialogShell, (boolean)false);
            ((Button)ComponentFinder.findByTypeAndText((Widget)dialogShell, Button.class, (String)"Cancel")).setEnabled(false);
            Label nameLabel = (Label)ComponentFinder.findByTypeAndText((Widget)dialogShell, Label.class, (String)"Name");
            Text nameInput = (Text)nameLabel.getParent().getChildren()[1];
            nameInput.setText(this.getFirstProjectName());
        };
        stepInfo.targetFinder = shell -> ComponentFinder.findByTypeAndText((Widget)shell, Button.class, (String)"OK");
        stepInfo.keepOverlay = true;
        stepInfo.blockingUI = false;
        stepInfo.afterStep = () -> {
            Shell aShell = ComponentFinder.findShell((String)"New Project");
            if (aShell.isVisible() && aShell.getData() instanceof Dialog) {
                this.projectType = ((NewProjectDialog)aShell.getData()).getProjectType();
            }
            DialogUtil.setCanClose((Shell)this.newProjectDialogShell, (boolean)true);
            ((Button)ComponentFinder.findByTypeAndText((Widget)this.newProjectDialogShell, Button.class, (String)"Cancel")).setEnabled(true);
        };
        stepInfo.waitToEnd = timer -> {
            Shell sh = ComponentFinder.findShell((String)"New Project");
            return sh == null || sh.isDisposed();
        };
        OpenFirstProjectTourHandler.createStep(tour, stepInfo);
    }

    private static void createStep(KatalonTour testPlanningTour, StepInfo stepInfo) {
        testPlanningTour.addStep(new GeneralTourStep(testPlanningTour, stepInfo));
    }

    private static HighlightOverlay createOverlay() {
        HighlightOverlay overlay = new HighlightOverlay((Control)ShellManager.getMainShell());
        overlay.setAlpha(20);
        ComponentEventUtil.onClick((Widget)overlay, event -> {
            if (event.count == 5) {
                overlay.close();
                Trackings.trackTourAction((String)QuickStartTourType.CREATE_FIRST_PROJECT.name(), (String)TourAction.BROKEN.name());
            }
        });
        return overlay;
    }

    private boolean isExplorerPartVisible() {
        List haveExplorerList = Arrays.asList(ShellManager.getShells()).stream().filter(shell -> {
            Widget explorer = ComponentFinder.findByText((Widget)shell, (String)"Tests Explorer");
            return explorer != null;
        }).collect(Collectors.toList());
        return !haveExplorerList.isEmpty();
    }

    private QuickStartTourType convertTourTypeToQuickStartTourType(String aTourType) {
        if (aTourType == null) {
            return null;
        }
        switch (aTourType) {
            case "Web": {
                return QuickStartTourType.WEB_TESTING;
            }
            case "API/Web Service": {
                return QuickStartTourType.API_TESTING;
            }
            case "Mobile": {
                return QuickStartTourType.MOBILE_TESTING;
            }
            case "Desktop": {
                return QuickStartTourType.DESKTOP_TESTING;
            }
            case "Generic": {
                return QuickStartTourType.BDD_TESTING;
            }
        }
        return null;
    }

    private String getFirstProjectName() {
        String projectName = "My First Project";
        File firstProjectFolder = new File(GlobalStringConstants.DEFAULT_PROJECT_LOCATION);
        firstProjectFolder.mkdirs();
        return NamingUtil.getUniqueFileName((String)projectName, (String)firstProjectFolder.getAbsolutePath());
    }
}

