/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.tour;

import com.kms.katalon.addons.QuickStartController;
import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.composer.components.impl.constants.ComposerComponentsImplMessageConstants;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.impl.overlay.HighlightOverlay;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentFinder;
import com.kms.katalon.composer.components.util.ComponentSelector;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.composer.components.util.UITimeUtil;
import com.kms.katalon.composer.handlers.OpenQuickStartOverviewHandler;
import com.kms.katalon.composer.helpers.KatalonPartHelper;
import com.kms.katalon.composer.tour.GeneralTourStep;
import com.kms.katalon.composer.tour.KatalonTour;
import com.kms.katalon.composer.tour.QuickStartTourType;
import com.kms.katalon.composer.tour.StepInfo;
import com.kms.katalon.composer.tour.TourAction;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.core.util.ObjectUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.feature.FeatureConfigurations;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.KSEFeature;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.TourEventBroker;
import java.text.MessageFormat;
import java.util.List;
import java.util.Timer;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class TestPlanningTourHandler {
    private HighlightOverlay mainOverlay;
    private String testSuiteName;
    private Timer waitForRunMenuTimer;

    @Execute
    public void execute() {
        UISynchronizeService.asyncExec(() -> {
            if (!FeatureServiceConsumer.getServiceInstance().canUse(KSEFeature.UNLIMITED_TEST_SUITE_CREATIONS)) {
                try {
                    ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
                    List tsList = TestSuiteController.getInstance().getAllTestSuites(currentProject);
                    if (tsList.size() >= FeatureConfigurations.LIMITED_TEST_SUITES) {
                        String dialogTitle = ComposerComponentsImplMessageConstants.DIA_KSE_FEATURE_RESTRICT_UNLIMITED_TEST_SUITE_CREATIONS;
                        String dialogMessage = ComposerComponentsImplMessageConstants.MSG_KSE_FEATURE_RESTRICT_UNLIMITED_TEST_SUITE_CREATIONS;
                        KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.UNLIMITED_TEST_SUITE_CREATIONS, (String)dialogTitle, (String)dialogMessage);
                        return;
                    }
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                    return;
                }
            }
            KatalonTour tour = new KatalonTour(QuickStartTourType.TEST_PLANNING);
            String firstName = ApplicationContext.getInstance().getUserFirstName();
            firstName = StringUtils.isNotBlank((CharSequence)firstName) ? MessageFormat.format(" {0}", firstName) : "";
            this.addStep1CreateNewTestSuite(tour, "create-new-test-suite", MessageFormat.format("Hi{0}! Let''s start planning a test! First, right-click on the \"Test Suites\" folder and select [New] > [Test Suite].", firstName), "");
            this.addStep2InputTestSuiteInfo(tour, "input-test-suite-info", "Give your suite a name and then click [OK].", "");
            this.addStep3AddTestCases(tour, "select-test-cases", "Now, let's add some test cases to your test suite.", "");
            this.addStep4ApplySelectedTestCases(tour, "add-test-cases", "Select all the test cases that are appropriate to your suite. Then, click [OK].", "");
            this.addStep5ConfigTestSuite(tour, "config-test-suite", "Expand the \"Execution Information\" to configure your test suite and help the test be more accurate ...", "");
            this.addStep6ConfigTimeout(tour, "config-timeout", "... by avoiding timing issues with an appropriate timeout, ...", "");
            this.addStep7ConfigRetry(tour, "config-retry", "... or controlling test flakiness with some retry strategies.", "");
            this.addStep8RunYourTestSuite(tour, "run-test-suite", "Looking good! Now, it's time to run your test suite.", "");
            this.addStep9WaitForLauncher(tour, "wait-for-launcher", "", "");
            this.addStep10CheckTheResult(tour, "check-the-result", "Okay, it's done! Let's check the results to make sure that all the tests passed.", "");
            this.addStep11SendReportToYourTeam(tour, "share-reports", "Oh, and one more thing! You can also set up to automatically send reports to your teammates via email.", "");
            tour.onEnd(() -> {
                Trackings.trackTourAction((String)tour.getType().name(), (String)TourAction.END.name());
                DialogUtil.close((Shell)this.mainOverlay);
                DialogUtil.setCanClose((Shell)ShellManager.getWebRecorderDialog(), (boolean)true);
                DialogUtil.setCanClose((Shell)ShellManager.getTestCaseSavingDialog(), (boolean)true);
                DialogUtil.setCanClose((Shell)ShellManager.getTestObjectsSavingDialog(), (boolean)true);
                if (tour.isSkipped() || !tour.isTerminated()) {
                    UserProfile curProfile = UserProfileHelper.getCurrentProfile();
                    curProfile.addCompletedTour(tour.getType().name());
                    UserProfileHelper.saveProfile((UserProfile)curProfile);
                    TourEventBroker.refreshPageAfterCompletedTour(QuickStartTourType.ANALYZE_TEST_ACTIVITIES);
                    if (tour.isSkipped()) {
                        return;
                    }
                }
                if (!tour.isTerminated()) {
                    QuickStartTourType tourType = QuickStartController.getCurrentTourTypeFromQuickStartPart();
                    new OpenQuickStartOverviewHandler().execute(tourType, QuickStartTourType.TEST_PLANNING, QuickStartTourType.ANALYZE_TEST_ACTIVITIES);
                }
            });
            tour.start();
        });
    }

    private void addStep1CreateNewTestSuite(KatalonTour testPlanningTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> ComponentFinder.findByText((Widget)mainShell, (String)"Test Suites");
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.keepOverlay = true;
        stepInfo.beforeStep = () -> {
            this.mainOverlay = TestPlanningTourHandler.createOverlay();
            this.mainOverlay.open();
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.waitToEnd = timer -> {
            Shell newTestSuiteShell = ComponentFinder.findShell((String)"New");
            return newTestSuiteShell != null && ComponentFinder.findByText((Widget)newTestSuiteShell, (String)"Test Suite") != null;
        };
        TestPlanningTourHandler.createStep(testPlanningTour, stepInfo);
    }

    private void addStep2InputTestSuiteInfo(KatalonTour testPlanningTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.blockingUI = false;
        stepInfo.dialogFinder = timer -> {
            boolean isNewTestSuiteDialog;
            Shell newTestSuiteShell = ComponentFinder.findShell((String)"New");
            boolean bl = isNewTestSuiteDialog = newTestSuiteShell != null && ComponentFinder.findByText((Widget)newTestSuiteShell, (String)"Test Suite") != null;
            if (!isNewTestSuiteDialog) {
                return null;
            }
            DialogUtil.setCanClose((Shell)newTestSuiteShell, (boolean)false);
            Button cancelButton = (Button)ComponentFinder.findByTypeAndText((Widget)newTestSuiteShell, Button.class, (String)"Cancel");
            cancelButton.setEnabled(false);
            return newTestSuiteShell;
        };
        stepInfo.targetFinder = dialog -> ComponentFinder.findByTypeAndText((Widget)dialog, Button.class, (String)"OK");
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.customClickHandler = event -> {
            Label nameLabel = (Label)ComponentFinder.findByTypeAndText((Widget)((Button)event.widget).getShell(), Label.class, (String)"Name");
            Text nameInput = (Text)nameLabel.getParent().getChildren()[1];
            this.testSuiteName = nameInput.getText();
        };
        stepInfo.beforeStep = () -> {
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.afterStep = () -> {
            boolean isNewTestSuiteDialog;
            Shell newTestSuiteShell = ComponentFinder.findShell((String)"New");
            boolean bl = isNewTestSuiteDialog = newTestSuiteShell != null && ComponentFinder.findByText((Widget)newTestSuiteShell, (String)"Test Suite") != null;
            if (!isNewTestSuiteDialog) {
                return;
            }
            DialogUtil.setCanClose((Shell)newTestSuiteShell, (boolean)true);
            Button cancelButton = (Button)ComponentFinder.findByTypeAndText((Widget)newTestSuiteShell, Button.class, (String)"Cancel");
            cancelButton.setEnabled(true);
        };
        TestPlanningTourHandler.createStep(testPlanningTour, stepInfo);
    }

    private void addStep3AddTestCases(KatalonTour testPlanningTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = dialog -> {
            Widget testSuitePart = ComponentFinder.findByTypeAndText((Widget)dialog, Composite.class, (String)this.testSuiteName);
            return ComponentFinder.findByTypeAndText((Widget)testSuitePart, ToolItem.class, (String)"Add");
        };
        stepInfo.waitToStartTimeout = 0L;
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.keepOverlay = true;
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        TestPlanningTourHandler.createStep(testPlanningTour, stepInfo);
    }

    private void addStep4ApplySelectedTestCases(KatalonTour testPlanningTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.dialogFinder = timer -> {
            Shell testCaseBrowserShell = ComponentFinder.findShell((String)"Test Case Browser");
            if (testCaseBrowserShell != null) {
                DialogUtil.setCanClose((Shell)testCaseBrowserShell, (boolean)false);
                Button cancelButton = (Button)ComponentFinder.findByTypeAndText((Widget)testCaseBrowserShell, Button.class, (String)"Cancel");
                cancelButton.setEnabled(false);
                Button okButton = (Button)ComponentFinder.findByTypeAndText((Widget)testCaseBrowserShell, Button.class, (String)"OK");
                UITimeUtil.setInterval(timer1 -> {
                    boolean hasSelectedAnyTestCase;
                    if (ControlUtil.isDisposed((Widget)testCaseBrowserShell)) {
                        timer1.cancel();
                        return;
                    }
                    Tree testCaseTree = (Tree)ComponentFinder.findByType((Widget)testCaseBrowserShell, Tree.class);
                    Object columnViewer = testCaseTree.getData("org.eclipse.jface.columnViewer");
                    ContainerCheckedTreeViewer checkedTreeViewer = (ContainerCheckedTreeViewer)ObjectUtil.getField((Object)columnViewer, (String)"viewer");
                    boolean bl = hasSelectedAnyTestCase = checkedTreeViewer.getCheckedElements().length > 0;
                    if (okButton.getEnabled() != hasSelectedAnyTestCase) {
                        okButton.setEnabled(hasSelectedAnyTestCase);
                    }
                }, (long)500L);
            }
            return testCaseBrowserShell;
        };
        stepInfo.targetFinder = dialog -> ComponentFinder.findByTypeAndText((Widget)dialog, Button.class, (String)"OK");
        stepInfo.waitToStartTimeout = 0L;
        stepInfo.blockingUI = false;
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.keepOverlay = false;
        stepInfo.beforeStep = () -> {
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.afterStep = () -> {
            Shell testCaseBrowserShell = ComponentFinder.findShell((String)"Test Case Browser");
            if (testCaseBrowserShell != null) {
                DialogUtil.setCanClose((Shell)testCaseBrowserShell, (boolean)true);
                Button cancelButton = (Button)ComponentFinder.findByTypeAndText((Widget)testCaseBrowserShell, Button.class, (String)"Cancel");
                cancelButton.setEnabled(true);
            }
        };
        TestPlanningTourHandler.createStep(testPlanningTour, stepInfo);
    }

    private void addStep5ConfigTestSuite(KatalonTour testPlanningTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = dialog -> {
            Widget testSuitePart = ComponentFinder.findByTypeAndText((Widget)dialog, Composite.class, (String)this.testSuiteName);
            Label configurationLabel = (Label)ComponentFinder.findByTypeAndText((Widget)testSuitePart, Label.class, (String)"Execution Information");
            Widget configurationCaret = ComponentSelector.from((Widget)configurationLabel).parent().firstChild().get();
            ComponentEventUtil.replaceEventListener((Widget)configurationCaret, event -> testPlanningTour.next(), (int[])new int[]{3});
            ComponentEventUtil.replaceEventListener((Widget)configurationLabel, event -> testPlanningTour.next(), (int[])new int[]{3});
            return configurationLabel.getParent();
        };
        stepInfo.waitToStartTimeout = 0L;
        stepInfo.triggerWhenClickTarget = false;
        stepInfo.keepOverlay = true;
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        TestPlanningTourHandler.createStep(testPlanningTour, stepInfo);
    }

    private void addStep6ConfigTimeout(KatalonTour testPlanningTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = dialog -> {
            Widget testSuitePart = ComponentFinder.findByTypeAndText((Widget)dialog, Composite.class, (String)this.testSuiteName);
            return ComponentFinder.findByTypeAndText((Widget)testSuitePart, Group.class, (String)"Implicit timeout");
        };
        stepInfo.keepOverlay = true;
        stepInfo.nextable = true;
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        TestPlanningTourHandler.createStep(testPlanningTour, stepInfo);
    }

    private void addStep7ConfigRetry(KatalonTour testPlanningTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = dialog -> {
            Widget testSuitePart = ComponentFinder.findByTypeAndText((Widget)dialog, Composite.class, (String)this.testSuiteName);
            Group timeoutGroup = (Group)ComponentFinder.findByTypeAndText((Widget)testSuitePart, Group.class, (String)"Implicit timeout");
            return ComponentSelector.from((Widget)timeoutGroup).parent().children(1).get();
        };
        stepInfo.keepOverlay = true;
        stepInfo.nextable = true;
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        TestPlanningTourHandler.createStep(testPlanningTour, stepInfo);
    }

    private void addStep8RunYourTestSuite(KatalonTour testPlanningTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> ComponentFinder.findByTypeAndText((Widget)mainShell, ToolItem.class, (String)"/Run.*/");
        stepInfo.keepOverlay = true;
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.customClickHandler = event -> {
            if (event.detail == 4) {
                Widget runButton = ComponentFinder.findByTypeAndText((Widget)ShellManager.getMainShell(), ToolItem.class, (String)"/Run.*/");
                UITimeUtil.cancel((Timer)this.waitForRunMenuTimer);
                UITimeUtil.waitFor(timer -> {
                    this.waitForRunMenuTimer = timer;
                    return ComponentFinder.findByTypeAndText((Widget)runButton, Menu.class, (String)"Run") != null;
                }, () -> {
                    Menu runMenu = (Menu)ComponentFinder.findByTypeAndText((Widget)runButton, Menu.class, (String)"Run");
                    ComponentEventUtil.handleDropdownClick((Menu)runMenu, (Event)event, () -> testPlanningTour.next());
                }, (long)0L);
            }
        };
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        TestPlanningTourHandler.createStep(testPlanningTour, stepInfo);
    }

    private void addStep9WaitForLauncher(KatalonTour testPlanningTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.waitToStartTimeout = 0L;
        stepInfo.mainScript = () -> UITimeUtil.waitFor(timer -> LauncherManager.getInstance().isAnyLauncherRunning(), () -> testPlanningTour.next());
        TestPlanningTourHandler.createStep(testPlanningTour, stepInfo);
    }

    private void addStep10CheckTheResult(KatalonTour testPlanningTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.waitToStartTimeout = 0L;
        stepInfo.waitToStart = timer -> !LauncherManager.getInstance().isAnyLauncherRunning();
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> (Composite)KatalonPartHelper.getConsolePartStack().getWidget();
        stepInfo.guidingDialogPositionProvider = (shell, args) -> {
            Rectangle dialogArea = (Rectangle)args[1];
            Rectangle targetArea = (Rectangle)args[2];
            return new Point(targetArea.x + targetArea.width - dialogArea.width - 8, targetArea.y + targetArea.height - dialogArea.height - 8);
        };
        stepInfo.nextable = true;
        stepInfo.keepOverlay = true;
        TestPlanningTourHandler.createStep(testPlanningTour, stepInfo);
    }

    private void addStep11SendReportToYourTeam(KatalonTour testPlanningTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> (Composite)KatalonPartHelper.getConsolePartStack().getWidget();
        stepInfo.guidingDialogPositionProvider = (shell, args) -> {
            Rectangle dialogArea = (Rectangle)args[1];
            Rectangle targetArea = (Rectangle)args[2];
            return new Point(targetArea.x + targetArea.width - dialogArea.width - 8, targetArea.y + targetArea.height - dialogArea.height - 8);
        };
        stepInfo.nextable = true;
        stepInfo.nextButtonText = ">> Learn more";
        stepInfo.afterStep = () -> ComponentUtil.triggerLink((String)DocumentationMessageConstants.SEND_REPORT_TO_YOUR_TEAM);
        TestPlanningTourHandler.createStep(testPlanningTour, stepInfo);
    }

    private static void createStep(KatalonTour testPlanningTour, StepInfo stepInfo) {
        testPlanningTour.addStep(new GeneralTourStep(testPlanningTour, stepInfo));
    }

    private static HighlightOverlay createOverlay() {
        HighlightOverlay overlay = new HighlightOverlay((Control)ShellManager.getMainShell());
        overlay.setAlpha(20);
        ComponentEventUtil.onClick((Widget)overlay, event -> {
            if (event.count == 5) {
                overlay.close();
                Trackings.trackTourAction((String)QuickStartTourType.TEST_PLANNING.name(), (String)TourAction.BROKEN.name());
            }
        });
        return overlay;
    }

    public String getTestSuiteName() {
        return this.testSuiteName;
    }
}

